/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.controlebancohoras;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorBancoHoras;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityControleBancoHoras {
    public List findApuracaoColaborador(Date dataInicio, Date dataFinal, Empresa empresa, List lista) {
        if (lista.isEmpty()) {
            String hql = " select distinct c  from Colaborador c  where  c.empresa = :empresa  and  c.ativo = 1  and  (c.dataDemissao is null or c.dataDemissao > :dataFinal) and  (c.tipoColaborador.identificador = :empregado  or  c.tipoColaborador.identificador = :menorAprendiz )  order by c.pessoa.nome ";
            List colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).list();
            if (colaboradores == null || colaboradores.isEmpty()) {
                return colaboradores;
            }
            ArrayList<ColaboradorBancoHoras> bancosHoras = new ArrayList<ColaboradorBancoHoras>();
            for (Colaborador c : colaboradores) {
                if (c.getNumeroRegistro().equals("237")) {
                    System.out.println("");
                }
                Date mesAnterior = this.getDataAnterior(dataFinal);
                Double saldoAnterior = this.getSaldoAnterior(c, mesAnterior);
                Double horasCompensadas = this.getHorasCompensadas(c, dataFinal);
                ColaboradorBancoHoras banco = new ColaboradorBancoHoras();
                banco.setColaborador(c);
                banco.setSaldoAnterior(saldoAnterior);
                banco.setSaldoBanco(saldoAnterior);
                banco.setHorasPagas(this.getDoubleParaHora(horasCompensadas));
                Double saldoAtual = this.getHoraParaDouble(banco.getHorasPositivas()) - this.getHoraParaDouble(banco.getHorasNegativas()) - this.getHoraParaDouble(banco.getHorasPagas()) + this.getHoraParaDouble(banco.getSaldoAnterior());
                banco.setSaldoBanco(this.getDoubleParaHora(saldoAtual));
                bancosHoras.add(banco);
            }
            return bancosHoras;
        }
        for (Object object : lista) {
            ColaboradorBancoHoras banco = (ColaboradorBancoHoras)object;
            Double horasCompensadas = this.getHorasCompensadas(banco.getColaborador(), dataFinal);
            banco.setHorasPagas(this.getDoubleParaHora(horasCompensadas));
        }
        return lista;
    }

    private Double getSaldoAnterior(Colaborador c, Date periodoAnterior) {
        String hql = " from ColaboradorBancoHoras c  where  c.colaborador = :colaborador  and  c.controleBdHoras.periodoApuracao = :periodoAnterior";
        ColaboradorBancoHoras col = (ColaboradorBancoHoras)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("periodoAnterior", periodoAnterior).uniqueResult();
        if (col != null) {
            return col.getSaldoBanco();
        }
        return 0.0;
    }

    private Date getDataAnterior(Date dataFinal) {
        Date mesAnterior = ToolDate.nextMonth((Date)dataFinal, (int)-1);
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(mesAnterior);
        g.set(5, g.getActualMaximum(5));
        return g.getTime();
    }

    private Double getHorasCompensadas(Colaborador c, Date dataFinal) {
        String hql = " select item.referencia as REFERENCIA,  item.eventoColaborador.tipoCalculoEvento.evento.descricao as ID_ITEM  from ItemMovimentoFolha item  where  item.movimentoFolha.aberturaPeriodo.dataFinal = :dataFinal  and  item.eventoColaborador.tipoCalculoEvento.deduzirBancoHoras = :sim  and  item.movimentoFolha.colaborador = :colaborador  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = 0 ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("dataFinal", (Object)dataFinal).setParameter("sim", (Object)1).setParameter("colaborador", (Object)c).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (retorno == null || retorno.isEmpty()) {
            return 0.0;
        }
        Double referenciaTotal = 0.0;
        for (Object object : retorno) {
            HashMap h = (HashMap)object;
            Double referencia = (Double)h.get("REFERENCIA");
            referenciaTotal = referenciaTotal + referencia;
        }
        return referenciaTotal;
    }

    private Double getDoubleParaHora(Double valor) {
        boolean negativo = false;
        if (valor < 0.0) {
            negativo = true;
        }
        valor = Math.abs(valor);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        Double dec = ContatoFormatUtil.arrredondarNumero((Double)((double)decimal.intValue() * 60.0 / 100.0), (int)0);
        Double retorno = 0.0;
        retorno = dec < 10.0 ? Double.valueOf(inteira + ".0" + dec.intValue()) : Double.valueOf(inteira + "." + dec.intValue());
        if (negativo) {
            return 0.0 - retorno;
        }
        return retorno;
    }

    private Double getHoraParaDouble(Double valor) {
        boolean negativo = false;
        if (valor < 0.0) {
            negativo = true;
        }
        valor = Math.abs(valor);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        Double dec = ContatoFormatUtil.arrredondarNumero((Double)((double)decimal.intValue() * 100.0 / 60.0), (int)0);
        Double retorno = 0.0;
        retorno = dec < 10.0 ? Double.valueOf(inteira + ".0" + dec.intValue()) : Double.valueOf(inteira + "." + dec.intValue());
        if (negativo) {
            return 0.0 - retorno;
        }
        return retorno;
    }
}

