/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimento1200DecimoTerceiro;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimento1210DecimoTerceiro;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimentoS1210;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimentosS1200;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1200;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1210;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1280;

public class ServiceEsocFechamentoFolha
extends CoreService {
    public static final String FIND_MOVIMENTOS_S_1010 = "findMovimentosS1010";
    public static final String FIND_MOVIMENTOS_S_1020 = "findMovimentosS1020";
    public static final String FIND_MOVIMENTOS_S_1010_13 = "findMovimentosS101013";
    public static final String FIND_MOVIMENTOS_S_1020_13 = "findMovimentosS102013";
    public static final String SALVAR_EVENTOS_ESOCIAL_FECHAMENTO = "esocEventosEsocialFechamento";
    public static final String EXCLUSAO_FECHAMENTO_FOLHA_ESOC = "exclusaoFechamentoFolhaEsoc";
    public static final String GERAR_EXCLUSAO_EVENTO_1210 = "gerarExclusaoEvento1210";
    public static final String GERAR_EXCLUSAO_EVENTO_1200 = "gerarExclusaoEvento1200";
    public static final String SALVAR_ESOC_FECHAMENTO_FOLHA = "salvarEsocFechamentoFolha";
    public static final String REPROCESSAR_FOLHA_FECHAMENTO = "reprocessarFechamento";

    public List findMovimentosS1010(CoreRequestContext request) throws ExceptionService {
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityFindMovimentosS1200().findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa, empresaRh);
    }

    public List findMovimentosS1020(CoreRequestContext request) throws ExceptionService {
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityFindMovimentoS1210().findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa, empresaRh);
    }

    public List findMovimentosS101013(CoreRequestContext request) throws ExceptionService {
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityFindMovimento1200DecimoTerceiro().findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa, empresaRh);
    }

    public List findMovimentosS102013(CoreRequestContext request) {
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)request.getAttribute("grupoEmpresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityFindMovimento1210DecimoTerceiro().findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa, empresaRh);
    }

    public void esocEventosEsocialFechamento(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao1200().gerarEventosFechamentoESocial(vo, usuario, empresa);
        new UtilityGeracao1210().gerarEventosFechamentoESocial(vo, usuario, empresa);
        if (vo.getGerarInformacoesComplementares().equals((short)1)) {
            new UtilityGeracao1280().gerarEventosFechamentoESocial(vo, usuario, empresa);
        }
    }

    public void exclusaoFechamentoFolhaEsoc(CoreRequestContext r) throws ExceptionService {
        MovimentoFolha mov;
        EsocFechamentoFolha e = (EsocFechamentoFolha)r.getAttribute("vo");
        if (e.getGerarEventos1210().equals((short)1)) {
            for (ESocS1020 eSocS1020 : e.getEsocS1020()) {
                for (EsocItemS1020 esoc : eSocS1020.getItensS1020()) {
                    if (esoc.getMovimentoFolha() == null) continue;
                    mov = esoc.getMovimentoFolha();
                    Iterator<Rubricas1210> rub1210 = new ArrayList();
                    for (Rubricas1210 rub : mov.getRubricas1210()) {
                        rub.setMovimentoFolha(null);
                        rub1210.add(rub);
                    }
                    Iterator iterator = rub1210.iterator();
                    while (iterator.hasNext()) {
                        Rubricas1210 rubricas1210 = (Rubricas1210)iterator.next();
                        ServiceEsocFechamentoFolha.simpleDelete(CoreDAOFactory.getInstance().getDAORubricas1210(), rubricas1210);
                    }
                }
            }
        }
        if (e.getGerarEventos1200().equals((short)1)) {
            for (EsocS1010 esocS1010 : e.getEsocS1010()) {
                for (EsocItemS1010 esocItemS1010 : esocS1010.getItensS1010()) {
                    if (esocItemS1010.getFerias() != null) {
                        ArrayList<RubricasFerias> rubricassFerias = new ArrayList<RubricasFerias>();
                        for (RubricasFerias rubricasFeria : esocItemS1010.getFerias().getRubricasFerias()) {
                            rubricasFeria.setFerias(null);
                            rubricassFerias.add(rubricasFeria);
                        }
                        esocItemS1010.getFerias().setRubricasFerias(new ArrayList());
                        for (RubricasFerias rubFerias : rubricassFerias) {
                            ServiceEsocFechamentoFolha.simpleDelete(CoreDAOFactory.getInstance().getDAORubricasFerias(), rubFerias);
                        }
                        continue;
                    }
                    if (esocItemS1010.getMovimentoFolha() == null) continue;
                    mov = esocItemS1010.getMovimentoFolha();
                    ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
                    if (mov != null) {
                        for (Rubricas1200 rr : mov.getRubricas1200()) {
                            rr.setMovimentoFolha(null);
                            rubricas.add(rr);
                        }
                        mov.setRubricas1200(new ArrayList());
                    }
                    for (Rubricas1200 rubrica : rubricas) {
                        ServiceEsocFechamentoFolha.simpleDelete(CoreDAOFactory.getInstance().getDAORubricas1200(), rubrica);
                    }
                }
            }
        }
        ServiceEsocFechamentoFolha.simpleDelete(CoreDAOFactory.getInstance().getDAOEsocFechamentoFolha(), e);
    }

    public void gerarExclusaoEvento1210(CoreRequestContext r) throws ExceptionService {
        EsocFechamentoFolha esocFechamento = (EsocFechamentoFolha)r.getAttribute("vo");
        block0: for (ESocS1020 eSocS1020 : esocFechamento.getEsocS1020()) {
            for (EsocPreEvento e : eSocS1020.getPreEventosEsocial()) {
                if (e.getEsocEvento() == null || e.getEventoPosterior() != null || !e.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !e.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
                this.criarExclusaoEvento1210(e);
                continue block0;
            }
        }
    }

    private void criarExclusaoEvento1210(EsocPreEvento e) throws ExceptionService {
        ExclusaoEventosEsocial vo = new ExclusaoEventosEsocial();
        vo.setEmpresa(e.getEmpresa());
        vo.setDataCadastro(new Date());
        vo.setDataAtualizacao(null);
        vo.setEsocEventoAExcluir(e.getEsocEvento());
        vo.setMotivo("EXCLUSAO PELO FECHAMENTO DE FOLHA");
        vo.setTipoEventoEsocial(e.getTipoEventoEsocial());
        vo.setPeriodoApuracao(e.getEsocS1210().getEsocFechamento().getPeriodoApuracao());
        vo.setNumeroRecibo(e.getEsocEvento().getNrRecibo());
        vo.setColaborador(e.getEsocS1210().getColaborador());
        vo = (ExclusaoEventosEsocial)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOExclusaoEventosEsocial(), vo);
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("vo", vo);
        r.setAttribute("usuario", e.getUsuario());
        r.setAttribute("empresa", e.getEmpresa());
        CoreServiceFactory.getServiceSaneamentoColaboradorEsocial().execute(r, "gerarEventoExclusao");
    }

    public void gerarExclusaoEvento1200(CoreRequestContext r) throws ExceptionService {
        EsocFechamentoFolha esocFechamento = (EsocFechamentoFolha)r.getAttribute("vo");
        block0: for (EsocS1010 esoc : esocFechamento.getEsocS1010()) {
            for (EsocPreEvento e : esoc.getPreEventosEsocial()) {
                if (e.getEsocEvento() == null || e.getEventoPosterior() != null || !e.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !e.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
                this.criarExclusaoEvento1200(e);
                continue block0;
            }
        }
    }

    private void criarExclusaoEvento1200(EsocPreEvento e) throws ExceptionService {
        ExclusaoEventosEsocial vo = new ExclusaoEventosEsocial();
        vo.setEmpresa(e.getEmpresa());
        vo.setDataCadastro(new Date());
        vo.setDataAtualizacao(null);
        vo.setEsocEventoAExcluir(e.getEsocEvento());
        vo.setMotivo("EXCLUSAO PELO FECHAMENTO DE FOLHA");
        vo.setTipoEventoEsocial(e.getTipoEventoEsocial());
        vo.setPeriodoApuracao(e.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao());
        vo.setNumeroRecibo(e.getEsocEvento().getNrRecibo());
        vo.setColaborador(e.getEsocS1200().getColaborador());
        vo = (ExclusaoEventosEsocial)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOExclusaoEventosEsocial(), vo);
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("vo", vo);
        r.setAttribute("usuario", e.getUsuario());
        r.setAttribute("empresa", e.getEmpresa());
        CoreServiceFactory.getServiceSaneamentoColaboradorEsocial().execute(r, "gerarEventoExclusao");
    }

    public Object salvarEsocFechamentoFolha(CoreRequestContext r) throws ExceptionDatabase {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)r.getAttribute("vo");
        List folhasComplementares = (List)r.getAttribute("folhasComplementares");
        for (Object obj : folhasComplementares) {
            FolhaComplementarPeriodo folha = (FolhaComplementarPeriodo)obj;
            CoreDAOFactory.getInstance().getDAOFolhaComplementarPeriodo().saveOrUpdate(folha);
        }
        vo = (EsocFechamentoFolha)CoreDAOFactory.getInstance().getDAOEsocFechamentoFolha().saveOrUpdate(vo);
        return vo;
    }

    public Object reprocessarFechamento(CoreRequestContext r) throws ExceptionDatabase {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)r.getAttribute("vo");
        EmpresaRh e = (EmpresaRh)r.getAttribute("empresaRh");
        String hql = " from FeriasColaborador f  where  f.periodoFerias.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  f.dataPagamento between :dataInicio and :dataFinal     ";
        List ferias = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)vo.getGrupoEmpresa()).setDate("dataInicio", ToolDate.getDateFirstMonthDay((Date)vo.getPeriodoApuracao())).setDate("dataFinal", ToolDate.getDateLastMonthDay((Date)vo.getPeriodoApuracao())).list();
        for (Object obj : ferias) {
            FeriasColaborador f = (FeriasColaborador)obj;
            HashMap h = this.criarRubricasFerias(f, e);
            f.getRubricasFerias().clear();
            f.getRubricasFerias().addAll((List)h.get("RUBRICAS_FERIAS"));
            CoreDAOFactory.getInstance().getDAOFeriasColaborador().saveOrUpdate(f);
        }
        return vo;
    }

    private HashMap criarRubricasFerias(FeriasColaborador f, EmpresaRh empresaRh) {
        if (f.getRubricasFerias() == null) {
            f.setRubricasFerias(new ArrayList());
        }
        ArrayList<RubricasFerias> rubricasFerias = new ArrayList<RubricasFerias>();
        Double baseIrrfFerias = 0.0;
        Double baseInssFerias = 0.0;
        Double valorAntecipacaoFerias = 0.0;
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            TipoCalculoEvento tipo = i.getEventoColaborador().getTipoCalculoEvento();
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                rubricasFerias.add(new RubricasFerias(tipo, Double.valueOf(0.0), i.getValor(), f));
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssFerias = baseInssFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            } else if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInssFerias = baseInssFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfFerias = baseIrrfFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13")) continue;
            baseIrrfFerias = baseIrrfFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
            baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
        }
        if (valorAntecipacaoFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpAntecipacaoFerias(), Double.valueOf(0.0), valorAntecipacaoFerias, f));
        }
        if (f.getVrIrrfFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpIrrfFerias(), Double.valueOf(0.0), f.getVrIrrfFerias(), f));
        }
        if (f.getVrInssFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpInssFerias(), Double.valueOf(0.0), f.getVrInssFerias(), f));
        }
        if (baseIrrfFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseIrrfFerias(), Double.valueOf(0.0), baseIrrfFerias, f));
        }
        if (baseInssFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInssFerias, f));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FERIAS", f);
        h.put("RUBRICAS_FERIAS", rubricasFerias);
        h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
        return h;
    }
}

