/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityFindMovimento1210DecimoTerceiro {
    public List findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) {
        ArrayList itens = new ArrayList();
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        String hql = " from MovimentoFolha m  where  m.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :decimoTerceiro  and  m.aberturaPeriodo.dataPagamento between :dataInicio and :dataFinal  and  (m.colaborador.dataDemissao is null or  m.colaborador.dataDemissao > m.aberturaPeriodo.dataFinal) and  not exists (from EsocItemS1020 e where e.movimentoFolha = m )  order by  m.aberturaPeriodo.dataPagamento desc ";
        List movFolhas = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)grupoEmpresa).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).list();
        if (movFolhas != null && !movFolhas.isEmpty()) {
            for (MovimentoFolha m : movFolhas) {
                if (!this.verificarValidacaoEventosFolha(m)) continue;
                HashMap h = this.criarRubricas1210Folha(m, empresaRh);
                hashs.add(h);
            }
        }
        if (hashs.isEmpty()) {
            new ArrayList();
        }
        return hashs;
    }

    private boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (movFolha.getItensMovimentoFolha().isEmpty()) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public HashMap criarRubricas1210Folha(MovimentoFolha m, EmpresaRh empresaRh) {
        if (m.getRubricas1210() == null) {
            m.setRubricas1210(new ArrayList());
        }
        ArrayList<Rubricas1210> rubricas = new ArrayList<Rubricas1210>();
        Double baseIrrf = 0.0;
        Double baseIrrfDec = 0.0;
        for (ItemMovimentoFolha i : m.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || tp.getEsocRubricasFolhaPagamento() == null || !tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
            rubricas.add(new Rubricas1210(tp, Double.valueOf(0.0), i.getValor(), m));
        }
        if (m.getVrIrrf13Sal() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), m.getVrIrrf13Sal(), m));
        }
        if (baseIrrfDec - m.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getEventoBaseIrrfDec(), Double.valueOf(0.0), Double.valueOf(baseIrrfDec - m.getVrInss13Sal()), m));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", m);
        h.put("RUBRICAS", rubricas);
        h.put("COLABORADOR", m.getColaborador());
        return h;
    }
}

