/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;

public class UtilityFindMovimentoS1210 {
    public List findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) throws ExceptionService {
        ArrayList itens = new ArrayList();
        ArrayList<Object> hashs = new ArrayList<Object>();
        String rescisao = " from Recisao r  where  (r.recisaoComplementar = :nao or r.recisaoComplementarAc is not null ) and  r.dataPagamento between :dataInicio and :dataFinal  and  r.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  not exists (from EsocItemS1020 e where e.rescisao = r ) ";
        List retornoRescisoes = CoreBdUtil.getInstance().getSession().createQuery(rescisao).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).setShort("nao", (short)0).setEntity("grupoEmpresa", (Object)grupoEmpresa).list();
        if (retornoRescisoes != null && !retornoRescisoes.isEmpty()) {
            for (Recisao r : retornoRescisoes) {
                if (!this.validarRescisao(r)) continue;
                HashMap<String, Recisao> h = new HashMap<String, Recisao>();
                h.put("RECISAO", r);
                h.put("COLABORADOR", (Recisao)r.getColaborador());
                hashs.add(h);
            }
        }
        String hql = " from MovimentoFolha m  where  m.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  m.aberturaPeriodo.dataPagamento between :dataInicio and :dataFinal  and  ((m.colaborador.dataDemissao is null or  m.colaborador.dataDemissao > m.aberturaPeriodo.dataFinal or m.aberturaPeriodo.tipoCalculo.tipoFolha = 2) or  (m.aberturaPeriodo.tipoCalculo.tipoFolha != 0 and m.colaborador.dataDemissao is not null and  m.colaborador.dataDemissao between  :dataInicio and :dataFinal and m.vrIrrfSalario > 0)) and  not exists (from EsocItemS1020 e where e.movimentoFolha = m )  order by  m.aberturaPeriodo.dataPagamento desc ,  m.colaborador.esocCategoriaTrabalhador.codigo ";
        List movFolhas = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).list();
        if (movFolhas != null && !movFolhas.isEmpty()) {
            for (MovimentoFolha m : movFolhas) {
                if (!this.verificarValidacaoEventosFolha(m)) continue;
                if (m.getPagamentoFolhaComplementar() == null) {
                    HashMap h = this.criarRubricas1210Folha(m, empresaRh);
                    hashs.add(h);
                    continue;
                }
                if (m.getPagamentoFolhaComplementar() == null) continue;
                List<HashMap> hashComp = this.criarRubricaFolhaComplementar(m, empresaRh);
                for (HashMap hashMap : hashComp) {
                    hashs.add(hashMap);
                }
            }
        }
        hql = " from FeriasColaborador f  where  f.periodoFerias.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  f.dataPagamento between :dataInicio and :dataFinal  and  not exists (from EsocItemS1020 e where e.feriasColaborador = f ) ";
        List ferias = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).list();
        for (Object obj : ferias) {
            FeriasColaborador f = (FeriasColaborador)obj;
            hashs.add(this.criarRubricasFerias(f, empresaRh));
        }
        if (hashs.isEmpty()) {
            new ArrayList();
        }
        return hashs;
    }

    private boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (movFolha.getItensMovimentoFolha().isEmpty()) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    private HashMap criarRubricasFerias(FeriasColaborador f, EmpresaRh empresaRh) {
        if (f.getRubricasFerias() != null && !f.getRubricasFerias().isEmpty()) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FERIAS", f);
            h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
            return h;
        }
        ArrayList<RubricasFerias> rubricasFerias = new ArrayList<RubricasFerias>();
        Double baseIrrfFerias = 0.0;
        Double baseInssFerias = 0.0;
        Double valorAntecipacaoFerias = 0.0;
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            TipoCalculoEvento tipo = i.getEventoColaborador().getTipoCalculoEvento();
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                rubricasFerias.add(new RubricasFerias(tipo, Double.valueOf(0.0), i.getValor(), f));
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssFerias = baseInssFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            } else if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInssFerias = baseInssFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfFerias = baseIrrfFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13")) continue;
            baseIrrfFerias = baseIrrfFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
            baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
        }
        if (valorAntecipacaoFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpAntecipacaoFerias(), Double.valueOf(0.0), valorAntecipacaoFerias, f));
        }
        if (f.getVrIrrfFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpIrrfFerias(), Double.valueOf(0.0), f.getVrIrrfFerias(), f));
        }
        if (f.getVrInssFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpInssFerias(), Double.valueOf(0.0), f.getVrInssFerias(), f));
        }
        if (baseIrrfFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseIrrfFerias(), Double.valueOf(0.0), baseIrrfFerias, f));
        }
        if (baseInssFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInssFerias, f));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FERIAS", f);
        h.put("RUBRICAS_FERIAS", rubricasFerias);
        h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
        return h;
    }

    public HashMap criarRubricas1210Folha(MovimentoFolha m, EmpresaRh empresaRh) {
        if (m.getRubricas1210() == null) {
            m.setRubricas1210(new ArrayList());
        }
        if (m.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO.getValue()) && m.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()) && m.getRubricas1200().isEmpty()) {
            return null;
        }
        ArrayList<Rubricas1210> rubricas = new ArrayList<Rubricas1210>();
        Double baseIrrf = 0.0;
        Double baseIrrfDec = 0.0;
        for (ItemMovimentoFolha i : m.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || tp.getEsocRubricasFolhaPagamento() == null || tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) {
                // empty if block
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("11") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrf = baseIrrf + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrf = ContatoFormatUtil.arrredondarNumero((Double)baseIrrf, (int)2);
            } else if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("11")) {
                baseIrrf = baseIrrf - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrf = ContatoFormatUtil.arrredondarNumero((Double)baseIrrf, (int)2);
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("12") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfDec = baseIrrfDec + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrfDec = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfDec, (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("12")) continue;
            baseIrrfDec = baseIrrfDec - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
            baseIrrfDec = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfDec, (int)2);
        }
        if (m.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getTpIrrf(), Double.valueOf(0.0), m.getVrIrrfSalario(), m));
        }
        if (m.getVrIrrf13Sal() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), m.getVrIrrf13Sal(), m));
        }
        if (baseIrrf - m.getVrInssSalario() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getEventoBaseIrrf(), Double.valueOf(0.0), Double.valueOf(baseIrrf - m.getVrInssSalario()), m));
        }
        if (baseIrrfDec - m.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1210(empresaRh.getEventoBaseIrrfDec(), Double.valueOf(0.0), Double.valueOf(baseIrrfDec - m.getVrInss13Sal()), m));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", m);
        h.put("RUBRICAS", rubricas);
        h.put("COLABORADOR", m.getColaborador());
        return h;
    }

    public void criarRubricas1210FolhaRetificacao(MovimentoFolha m, EmpresaRh empresaRh) {
        m.setRubricas1210(new ArrayList());
        Double baseIrrf = 0.0;
        Double baseIrrfDec = 0.0;
        for (ItemMovimentoFolha i : m.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || tp.getEsocRubricasFolhaPagamento() == null || tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) {
                // empty if block
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("11") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrf = baseIrrf + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrf = ContatoFormatUtil.arrredondarNumero((Double)baseIrrf, (int)2);
            } else if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("11")) {
                baseIrrf = baseIrrf - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrf = ContatoFormatUtil.arrredondarNumero((Double)baseIrrf, (int)2);
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("12") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfDec = baseIrrfDec + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrfDec = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfDec, (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("12")) continue;
            baseIrrfDec = baseIrrfDec - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
            baseIrrfDec = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfDec, (int)2);
        }
        if (m.getVrIrrfSalario() > 0.0) {
            m.getRubricas1210().add(new Rubricas1210(empresaRh.getTpIrrf(), Double.valueOf(0.0), m.getVrIrrfSalario(), m));
        }
        if (m.getVrIrrf13Sal() > 0.0) {
            m.getRubricas1210().add(new Rubricas1210(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), m.getVrIrrf13Sal(), m));
        }
        if (baseIrrf - m.getVrInssSalario() > 0.0) {
            m.getRubricas1210().add(new Rubricas1210(empresaRh.getEventoBaseIrrf(), Double.valueOf(0.0), Double.valueOf(baseIrrf - m.getVrInssSalario()), m));
        }
        if (baseIrrfDec - m.getVrInss13Sal() > 0.0) {
            m.getRubricas1210().add(new Rubricas1210(empresaRh.getEventoBaseIrrfDec(), Double.valueOf(0.0), Double.valueOf(baseIrrfDec - m.getVrInss13Sal()), m));
        }
    }

    private boolean validarFerias(FeriasColaborador f) {
        if (f.getItemMovimentoFerias().isEmpty()) {
            return false;
        }
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    private boolean validarRescisao(Recisao r) {
        if (r.getItemRescisao().isEmpty()) {
            return false;
        }
        for (ItemMovimentoRescisao item : r.getItemRescisao()) {
            if (!(item.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    private List<HashMap> criarRubricaFolhaComplementar(MovimentoFolha mov, EmpresaRh empresaRh) {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        for (FolhaComplementarPeriodo folhaComp : mov.getPagamentoFolhaComplementar().getFolhaComplementares()) {
            ArrayList<Rubricas1210> rubricas = new ArrayList<Rubricas1210>();
            if (folhaComp.getRubricas1210() == null) {
                folhaComp.setRubricas1210(new ArrayList());
            }
            for (FolhaComplementarPeriodoItem i : folhaComp.getFolhaComplementarPeriodoItem()) {
                TipoCalculoEvento tp = i.getTipoCalculoEvento();
                if (!(i.getValorComplemento() > 0.0) || tp.getEsocRubricasFolhaPagamento() == null || !tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                rubricas.add(new Rubricas1210(tp, i.getValorComplemento(), folhaComp));
            }
            if (folhaComp.getVrIrrf() > 0.0) {
                rubricas.add(new Rubricas1210(empresaRh.getTpIrrf(), folhaComp.getVrIrrf(), folhaComp));
            }
            if (folhaComp.getVrIrrfDec() > 0.0) {
                rubricas.add(new Rubricas1210(empresaRh.getTpIrrfDec(), folhaComp.getVrIrrfDec(), folhaComp));
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FOLHA", mov);
            h.put("RUBRICAS", rubricas);
            h.put("FOLHA_COMP", folhaComp);
            h.put("COLABORADOR", mov.getColaborador());
            hashs.add(h);
        }
        return hashs;
    }
}

