/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;

public class UtilityFindMovimentosS1200 {
    public List findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) throws ExceptionService {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        String hql = " from MovimentoFolha m  where  (m.colaborador.dataDemissao is null or m.colaborador.dataDemissao > :dataFinal )  and  m.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  (m.aberturaPeriodo.tipoCalculo.tipoFolha != :decimoTerceiro and m.aberturaPeriodo.tipoCalculo.tipoFolha != :compDecimoTerceiro ) and  m.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal  and  not exists (from EsocItemS1010 e where e.movimentoFolha = m ) order by  m.colaborador.esocCategoriaTrabalhador.codigo  ";
        List movFolhas = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).setShort("decimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setShort("compDecimoTerceiro", EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR_DEC.getValue().shortValue()).list();
        for (MovimentoFolha movFolha : movFolhas) {
            if (!this.verificarValidacaoEventosFolha(movFolha)) continue;
            HashMap h = null;
            if (!(movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) || movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue()) || movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue()))) {
                if (!movFolha.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                    h = this.criarRubricas1200(movFolha, empresaRh);
                } else {
                    if (empresaRh.getVrBaseInssAutonomoFrete() == null || empresaRh.getVrBaseIrrfAutonomoFrete() == null) {
                        throw new ExceptionService("Eventos de Base de Impostos n\u00e3o foram informados na Empresa Rh");
                    }
                    h = this.criarRubricas1200AutonomoFrete(movFolha, empresaRh, hashs);
                }
            } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                h = this.criarRubricas1200Adiantamento13(movFolha, empresaRh);
            } else if (movFolha.getPagamentoFolhaComplementar() == null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                h = this.criarRubricas1200(movFolha, empresaRh);
            } else if (movFolha.getPagamentoFolhaComplementar() != null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                h = null;
                List<HashMap> aux = this.criarRubricas1200FolhaComplementar(movFolha, empresaRh);
                for (HashMap hashMap : aux) {
                    hashs.add(hashMap);
                }
            }
            if (h == null) continue;
            hashs.add(h);
        }
        hql = " from FeriasColaborador f  where  f.periodoFerias.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  f.dataPagamento between :dataInicio and :dataFinal  and  not exists (from EsocItemS1010 e where e.ferias = f ) ";
        List ferias = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)grupoEmpresa).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).list();
        for (Object obj : ferias) {
            FeriasColaborador f = (FeriasColaborador)obj;
            hashs.add(this.criarRubricasFerias(f, empresaRh));
        }
        return hashs;
    }

    private HashMap criarRubricasFerias(FeriasColaborador f, EmpresaRh empresaRh) {
        if (f.getRubricasFerias() == null) {
            f.setRubricasFerias(new ArrayList());
        }
        ArrayList<RubricasFerias> rubricasFerias = new ArrayList<RubricasFerias>();
        Double baseIrrfFerias = 0.0;
        Double baseInssFerias = 0.0;
        Double valorAntecipacaoFerias = 0.0;
        for (ItemMovimentoFerias i : f.getItemMovimentoFerias()) {
            TipoCalculoEvento tipo = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo(), (Object)"11") || ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo(), (Object)"11") || ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento(), (Object)empresaRh.getTpAddDec()) || ToolMethods.isEquals((Object)i.getEventoColaborador().getTipoCalculoEvento(), (Object)empresaRh.getTpliquidoAddDec()))) {
                rubricasFerias.add(new RubricasFerias(tipo, Double.valueOf(0.0), i.getValor(), f));
            }
            if ((i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") || i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11")) && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssFerias = baseInssFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            } else if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInssFerias = baseInssFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseInssFerias = ContatoFormatUtil.arrredondarNumero((Double)baseInssFerias, (int)2);
                valorAntecipacaoFerias = valorAntecipacaoFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                valorAntecipacaoFerias = ContatoFormatUtil.arrredondarNumero((Double)valorAntecipacaoFerias, (int)2);
            }
            if (i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13") && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseIrrfFerias = baseIrrfFerias + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaIrrf().getCodigo().equals("13")) continue;
            baseIrrfFerias = baseIrrfFerias - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
            baseIrrfFerias = ContatoFormatUtil.arrredondarNumero((Double)baseIrrfFerias, (int)2);
        }
        if (valorAntecipacaoFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpAntecipacaoFerias(), Double.valueOf(0.0), valorAntecipacaoFerias, f));
        }
        if (f.getVrIrrfFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpIrrfFerias(), Double.valueOf(0.0), f.getVrIrrfFerias(), f));
        }
        if (f.getVrInssFerias() > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getTpInssFerias(), Double.valueOf(0.0), f.getVrInssFerias(), f));
        }
        if (baseIrrfFerias > 0.0) {
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseIrrfFerias(), Double.valueOf(0.0), baseIrrfFerias, f));
        }
        if (baseInssFerias > 0.0) {
            if (ToolMethods.isNull((Object)empresaRh.getEventoBaseInss()).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0050.006"));
            }
            rubricasFerias.add(new RubricasFerias(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInssFerias, f));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FERIAS", f);
        h.put("RUBRICAS_FERIAS", rubricasFerias);
        h.put("COLABORADOR", f.getPeriodoAqFeriasColab().getColaborador());
        return h;
    }

    public HashMap criarRubricas1200(MovimentoFolha mov, EmpresaRh empresaRh) {
        if (mov.getRubricas1200() == null) {
            mov.setRubricas1200(new ArrayList());
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        Double baseInss = 0.0;
        Double baseInssDec = 0.0;
        Double baseFgts = 0.0;
        Double baseFgtsDec = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (!tp.getDescartarRubricaEsocial().equals((short)0)) continue;
            if (item.getValor() > 0.0 && tp.getEsocRubricasFolhaPagamento() != null) {
                System.err.println(tp.getEvento().getCodigo());
                if (item.getEventoColaborador().getEventoConsignado() != null) {
                    rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), mov, item.getEventoColaborador().getEventoConsignado()));
                } else {
                    rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), mov));
                }
            }
            if ((item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") || item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("15") || item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("21")) && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInss = baseInss + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInss = baseInss - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssDec = baseInssDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12")) {
                baseInssDec = baseInssDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgts = baseFgts + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11")) {
                baseFgts = baseFgts - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgtsDec = baseFgtsDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12")) continue;
            baseFgtsDec = baseFgtsDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
            baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
        }
        if (mov.getVrInssSalario() + mov.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInss(), mov.getAliqInssSalario(), Double.valueOf(mov.getVrInssSalario() + mov.getVrInssFerias()), mov));
        }
        if (mov.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), mov.getAliqInss13Sal(), mov.getVrInss13Sal(), mov));
        }
        if (mov.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoDevolucaoInssFerias(), mov.getAliqInssFerias(), mov.getVrInssFerias(), mov));
        }
        if (baseInss > 0.0) {
            if (ToolMethods.isNull((Object)empresaRh.getEventoBaseInss()).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0050.006"));
            }
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInss, mov));
        }
        if (baseInssDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), baseInssDec, mov));
        }
        if (baseFgts > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), Double.valueOf(0.0), baseFgts, mov));
        }
        if (baseFgtsDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), baseFgtsDec, mov));
        }
        if (mov.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), Double.valueOf(0.0), mov.getVrIrrfSalario(), mov));
        }
        if (mov.getVrIrrf13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrfDec(), Double.valueOf(0.0), mov.getVrIrrf13Sal(), mov));
        }
        if (mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()), mov));
        }
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", mov);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    private Double valorDescontoFerias(MovimentoFolha movFolha) {
        Double valorProventoFerias = 0.0;
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (i.getItemFeriasFolha() != null && i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                valorProventoFerias = ContatoFormatUtil.arrredondarNumero((Double)(valorProventoFerias + i.getValor()), (int)2);
                continue;
            }
            if (i.getItemFeriasFolha() == null || !i.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("2") || i.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(ConstantsESocial.LIQUIDO_FERIAS)) continue;
            valorProventoFerias = ContatoFormatUtil.arrredondarNumero((Double)(valorProventoFerias - i.getValor()), (int)2);
        }
        return valorProventoFerias;
    }

    public void retificarRubricas1200Retificacao(MovimentoFolha mov, EmpresaRh empresaRh) {
        if (mov.getRubricas1200() == null) {
            mov.setRubricas1200(new ArrayList());
        }
        Double baseInss = 0.0;
        Double baseInssDec = 0.0;
        Double baseFgts = 0.0;
        Double baseFgtsDec = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (item.getValor() > 0.0 && (tp.getEsocRubricasFolhaPagamento() == null || !tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA))) {
                mov.getRubricas1200().add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), mov));
            }
            if ((item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") || item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("21")) && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInss = baseInss + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInss = baseInss - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssDec = baseInssDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12")) {
                baseInssDec = baseInssDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgts = baseFgts + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11")) {
                baseFgts = baseFgts - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgtsDec = baseFgtsDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12")) continue;
            baseFgtsDec = baseFgtsDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
            baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
        }
        if (mov.getVrInssSalario() + mov.getVrInssFerias() > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getTpInss(), mov.getAliqInssSalario(), Double.valueOf(mov.getVrInssSalario() + mov.getVrInssFerias()), mov));
        }
        if (mov.getVrInss13Sal() > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getTpInssDec(), mov.getAliqInss13Sal(), mov.getVrInss13Sal(), mov));
        }
        if (mov.getVrInssFerias() > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getEventoDevolucaoInssFerias(), mov.getAliqInssFerias(), mov.getVrInssFerias(), mov));
        }
        if (baseInss > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInss, mov));
        }
        if (baseInssDec > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), baseInssDec, mov));
        }
        if (baseFgts > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getEventoBaseFgts(), Double.valueOf(0.0), baseFgts, mov));
        }
        if (baseFgtsDec > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), baseFgtsDec, mov));
        }
        if (mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario() > 0.0) {
            mov.getRubricas1200().add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()), mov));
        }
    }

    public HashMap criarRubricas1200AutonomoFrete(MovimentoFolha movFolha, EmpresaRh empresaRh, List<HashMap> hashs) {
        HashMap h = null;
        MovimentoFolha movAux = null;
        for (HashMap hash : hashs) {
            MovimentoFolha m = (MovimentoFolha)hash.get("FOLHA");
            if (!ToolString.refina((String)movFolha.getColaborador().getPessoa().getComplemento().getCnpj()).equals(ToolString.refina((String)m.getColaborador().getPessoa().getComplemento().getCnpj()))) continue;
            h = hash;
            movAux = m;
            break;
        }
        if (h == null) {
            h = new HashMap();
            movAux = movFolha;
        }
        Double bcInss = 0.0;
        Double bcIrrf = 0.0;
        Double totalPrestacaoServico = 0.0;
        TipoCalculoEvento tpPrestacaoServico = null;
        bcInss = movFolha.getBcInssSalario();
        bcIrrf = movFolha.getBcIrrfSalario();
        for (Object item : movFolha.getItensMovimentoFolha()) {
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PRESTACAO_SERVICO)) continue;
            totalPrestacaoServico = totalPrestacaoServico + item.getValor();
            tpPrestacaoServico = item.getEventoColaborador().getTipoCalculoEvento();
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        totalPrestacaoServico = ContatoFormatUtil.arrredondarNumero((Double)(totalPrestacaoServico - bcInss - bcIrrf), (int)2);
        for (ItemMovimentoFolha item : movFolha.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (!(item.getValor() > 0.0) || tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PRESTACAO_SERVICO)) continue;
            rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), movAux));
        }
        if (totalPrestacaoServico > 0.0 && tpPrestacaoServico != null) {
            rubricas.add(new Rubricas1200(tpPrestacaoServico, Double.valueOf(0.0), totalPrestacaoServico, movAux));
        }
        if (bcInss > 0.0) {
            if (ToolMethods.isNull((Object)empresaRh.getEventoBaseInss()).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0050.006"));
            }
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), bcInss, movAux));
            rubricas.add(new Rubricas1200(empresaRh.getVrBaseInssAutonomoFrete(), Double.valueOf(0.0), bcInss, movAux));
        }
        if (bcIrrf > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getVrBaseIrrfAutonomoFrete(), Double.valueOf(0.0), bcIrrf, movAux));
        }
        if (movFolha.getVrInssSalario() + movFolha.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInss(), movFolha.getAliqInssSalario(), Double.valueOf(movFolha.getVrInssSalario() + movFolha.getVrInssFerias()), movAux));
        }
        if (movFolha.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), movFolha.getAliqInss13Sal(), movFolha.getVrInss13Sal(), movAux));
        }
        if (movFolha.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), Double.valueOf(0.0), movFolha.getVrIrrfSalario(), movFolha));
        }
        if (h.get("RUBRICAS") != null) {
            List rubricasAux = (List)h.get("RUBRICAS");
            rubricas.addAll(rubricasAux);
            h.put("RUBRICAS", rubricas);
            return null;
        }
        h.put("FOLHA", movAux);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    public HashMap criarRubricas1200Adiantamento13(MovimentoFolha mov, EmpresaRh empresaRh) throws ExceptionService {
        if (mov.getRubricas1200() == null) {
            mov.setRubricas1200(new ArrayList());
        }
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        Double baseInss = 0.0;
        Double baseInssDec = 0.0;
        Double baseFgts = 0.0;
        Double baseFgtsDec = 0.0;
        TipoCalculoEvento tp = empresaRh.getTpAddDec();
        if (tp == null) {
            throw new ExceptionService("Informe o Evento de Add de 13\u00ba na Empresa RH");
        }
        Double vlrAdd = 0.0;
        for (ItemMovimentoFolha i : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tpEvento = i.getEventoColaborador().getTipoCalculoEvento();
            if (!(i.getValor() > 0.0) || tpEvento.getEsocRubricasFolhaPagamento() != null && tpEvento.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
            if (i.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && (!i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario().equals((short)0) || i.getEventoColaborador().getTipoCalculoEvento().equals((Object)tp))) {
                vlrAdd = vlrAdd + ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                continue;
            }
            if (!i.getEventoColaborador().getTipoCalculoEvento().getMedia13Salario().equals((short)0)) {
                vlrAdd = vlrAdd - ContatoFormatUtil.arrredondarNumero((Double)i.getValor(), (int)2);
                continue;
            }
            rubricas.add(new Rubricas1200(i.getEventoColaborador().getTipoCalculoEvento(), Double.valueOf(0.0), i.getValor(), mov));
        }
        rubricas.add(new Rubricas1200(tp, Double.valueOf(0.0), vlrAdd, mov));
        rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), mov.getBcFgts13Sal(), mov));
        rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), mov.getVrFgts13Sal(), mov));
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("FOLHA", mov);
        h.put("RUBRICAS", rubricas);
        return h;
    }

    private boolean verificarValidacaoEventosFolha(MovimentoFolha movFolha) {
        if (movFolha.getItensMovimentoFolha().isEmpty()) {
            return false;
        }
        for (ItemMovimentoFolha i : movFolha.getItensMovimentoFolha()) {
            if (!(i.getValor() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public List<HashMap> criarRubricas1200FolhaComplementar(MovimentoFolha m, EmpresaRh empresaRh) {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        for (FolhaComplementarPeriodo folha : m.getPagamentoFolhaComplementar().getFolhaComplementares()) {
            if (folha.getRubricas1200() == null) {
                folha.setRubricas1200(new ArrayList());
            }
            ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
            for (FolhaComplementarPeriodoItem item : folha.getFolhaComplementarPeriodoItem()) {
                TipoCalculoEvento tp = item.getTipoCalculoEvento();
                if (!(item.getValorComplemento() > 0.0) || tp.getEsocRubricasFolhaPagamento() != null && tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                System.err.println(tp.getEvento().getCodigo());
                rubricas.add(new Rubricas1200(tp, item.getValorComplemento(), folha));
            }
            if (folha.getVrInss() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInss(), folha.getVrInss(), folha));
            }
            if (folha.getVrInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), folha.getVrInssDec(), folha));
            }
            if (folha.getBaseInss() > 0.0) {
                if (ToolMethods.isNull((Object)empresaRh.getEventoBaseInss()).booleanValue()) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0050.006"));
                }
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), folha.getBaseInss(), folha));
            }
            if (folha.getBaseInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), folha.getBaseInssDec(), folha));
            }
            if (folha.getBaseFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), folha.getBaseFgts(), folha));
            }
            if (folha.getVrFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), folha.getVrFgts(), folha));
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FOLHA", m);
            h.put("FOLHA_COMP", folha);
            h.put("RUBRICAS", rubricas);
            hashs.add(h);
        }
        return hashs;
    }
}

