/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimento1200DecimoTerceiro;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimentosS1200;

public class UtilityGeracao1200 {
    public void gerarEventosFechamentoESocial(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocS1010 item : vo.getEsocS1010()) {
            this.gerarEventoEsocialS1010(item, usuario, empresa);
        }
    }

    public void gerarEventoEsocialS1010(EsocS1010 vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        if (vo.getPreEventosEsocial().isEmpty()) {
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue(), (short)0);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
            preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
        }
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(EsocS1010 vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("s-1200");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(26L));
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (!(vo instanceof EsocS1010)) {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
        preEvento.setEsocS1200((EsocS1010)vo);
    }

    private String getReciboRetificacao(EsocS1010 vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1200) || e.getEventoPosterior() != null || !e.getEventoProdRestritaProducao().equals(prodEvento)) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS1200(EsocS1010 vo, Usuario usuario, Empresa empresa, Short tipoEvento, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1200) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                this.recalcularEventos(vo, empresaRh);
                return;
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
            this.recalcularEventos(vo, empresaRh);
        }
    }

    private void recalcularEventos(EsocS1010 vo, EmpresaRh empresaRh) throws ExceptionDatabase, ExceptionService {
        for (EsocItemS1010 esocItemS1010 : vo.getItensS1010()) {
            if (esocItemS1010.getMovimentoFolha() == null) continue;
            esocItemS1010.getMovimentoFolha().getAberturaPeriodo().getTipoCalculo().getDescricao();
            MovimentoFolha movFolha = esocItemS1010.getMovimentoFolha();
            movFolha.setRubricas1200(new ArrayList());
            HashMap h = null;
            if (movFolha.getPagamentoFolhaComplementar() == null && !movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) && !movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                if (!movFolha.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) {
                    h = new UtilityFindMovimentosS1200().criarRubricas1200(movFolha, empresaRh);
                } else {
                    if (empresaRh.getVrBaseInssAutonomoFrete() == null || empresaRh.getVrBaseIrrfAutonomoFrete() == null) {
                        throw new ExceptionService("Eventos de Base de Impostos n\u00e3o foram informados na Empresa Rh");
                    }
                    h = new UtilityFindMovimentosS1200().criarRubricas1200AutonomoFrete(movFolha, empresaRh, new ArrayList<HashMap>());
                }
            } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue())) {
                h = new UtilityFindMovimentosS1200().criarRubricas1200Adiantamento13(movFolha, empresaRh);
            } else if (movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                h = new UtilityFindMovimento1200DecimoTerceiro().criarRubricas120013(movFolha, empresaRh);
            } else if (movFolha.getPagamentoFolhaComplementar() != null && movFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
                h = null;
                this.criarRubricas1200FolhaComplementar(movFolha, empresaRh);
            }
            if (h == null) continue;
            List rubricas = (List)h.get("RUBRICAS");
            movFolha.setRubricas1200(rubricas);
            CoreDAOFactory.getInstance().getDAOMovimentoFolha().saveOrUpdate(movFolha);
        }
    }

    public List<HashMap> criarRubricas1200FolhaComplementar(MovimentoFolha m, EmpresaRh empresaRh) throws ExceptionDatabase {
        ArrayList<HashMap> hashs = new ArrayList<HashMap>();
        for (FolhaComplementarPeriodo folha : m.getPagamentoFolhaComplementar().getFolhaComplementares()) {
            if (folha.getRubricas1200() == null) {
                folha.setRubricas1200(new ArrayList());
            }
            ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
            for (FolhaComplementarPeriodoItem item : folha.getFolhaComplementarPeriodoItem()) {
                TipoCalculoEvento tp = item.getTipoCalculoEvento();
                if (!(item.getValorComplemento() > 0.0) || tp.getEsocRubricasFolhaPagamento() != null && tp.getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                System.err.println(tp.getEvento().getCodigo());
                rubricas.add(new Rubricas1200(tp, item.getValorComplemento(), folha));
            }
            if (folha.getVrInss() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInss(), folha.getVrInss(), folha));
            }
            if (folha.getVrInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), folha.getVrInssDec(), folha));
            }
            if (folha.getBaseInss() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), folha.getBaseInss(), folha));
            }
            if (folha.getBaseInssDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), folha.getBaseInssDec(), folha));
            }
            if (folha.getBaseFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), folha.getBaseFgts(), folha));
            }
            if (folha.getVrFgts() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), folha.getVrFgts(), folha));
            }
            if (folha.getVrIrrf() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), folha.getVrIrrf(), folha));
            }
            if (folha.getVrIrrfDec() > 0.0) {
                rubricas.add(new Rubricas1200(empresaRh.getTpIrrfDec(), folha.getVrIrrfDec(), folha));
            }
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("FOLHA", m);
            h.put("FOLHA_COMP", folha);
            h.put("RUBRICAS", rubricas);
            folha.setRubricas1200(rubricas);
            CoreDAOFactory.getInstance().getDAOFolhaComplementarPeriodo().saveOrUpdate(folha);
            hashs.add(h);
        }
        return hashs;
    }
}

