/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.fechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityFindMovimentoS1210;

public class UtilityGeracao1210 {
    public void gerarEventosFechamentoESocial(EsocFechamentoFolha vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (ESocS1020 item : vo.getEsocS1020()) {
            this.gerarEventoEsocialS1010(item, usuario, empresa);
        }
    }

    public void gerarEventoEsocialS1010(ESocS1020 vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        if (vo.getPreEventosEsocial().isEmpty()) {
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue(), (short)0);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
            preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
        }
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(ESocS1020 vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("s-1210");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(27L));
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (!(vo instanceof ESocS1020)) {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
        preEvento.setEsocS1210((ESocS1020)vo);
    }

    private String getReciboRetificacao(ESocS1020 vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1210) || e.getEventoPosterior() != null || !e.getEventoProdRestritaProducao().equals(prodEvento)) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS1210(ESocS1020 vo, Usuario usuario, Empresa empresa, Short tipoEvento, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1210) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                this.recalcularEventos(vo, empresaRh);
                return;
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
            this.recalcularEventos(vo, empresaRh);
        }
    }

    private void recalcularEventos(ESocS1020 vo, EmpresaRh empresa) throws ExceptionDatabase {
        for (EsocItemS1020 i : vo.getItensS1020()) {
            MovimentoFolha mov = i.getMovimentoFolha();
            if (mov == null) continue;
            mov.setRubricas1210(new ArrayList());
            new UtilityFindMovimentoS1210().criarRubricas1210FolhaRetificacao(mov, empresa);
            CoreDAOFactory.getInstance().getDAOMovimentoFolha().saveOrUpdate(mov);
        }
    }
}

