/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.migracaorecibo;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocInsercaoRecibo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemEsocInsercaoRecibo;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.migracaorecibo.UtilityServiceMigracaoRecibo;

public class ServiceEsocMigracaoRecibo
extends CoreService {
    public static final String BUSCAR_EVENTOS_SEM_RECIBO = "buscarEventosSemRecibo";
    public static final String SETAR_RECIBOS_EVENTOS = "setarRecibosEventos";
    public static final String EXCLUIR_RECIBOS_ESOCIAL = "excluirRecibosEsocial";

    public List buscarEventosSemRecibo(CoreRequestContext r) {
        TipoEventoEsocial tipoEventoEsocial = (TipoEventoEsocial)r.getAttribute("tipoEvento");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        return new UtilityServiceMigracaoRecibo().findEventosSemRecibo(grupoEmpresa, tipoEventoEsocial);
    }

    public void setarRecibosEventos(CoreRequestContext r) throws ExceptionDatabase {
        EsocInsercaoRecibo vo = (EsocInsercaoRecibo)r.getAttribute("vo");
        ArrayList<EsocEvento> esocs = new ArrayList<EsocEvento>();
        for (ItemEsocInsercaoRecibo item : vo.getItens()) {
            String recibo = item.getRecibo();
            Long status = item.getStatus();
            EsocEvento evento = item.getEsocEvento();
            evento.setNrRecibo(recibo);
            evento.setStatus(status);
            evento.setInformarReciboManual(Short.valueOf((short)1));
            esocs.add(evento);
        }
        for (EsocEvento esoc : esocs) {
            CoreDAOFactory.getInstance().getDAOEsocEvento().saveOrUpdate(esoc);
        }
    }

    public void excluirRecibosEsocial(CoreRequestContext r) throws ExceptionDatabase {
        EsocInsercaoRecibo vo = (EsocInsercaoRecibo)r.getAttribute("vo");
        ArrayList<EsocEvento> esocs = new ArrayList<EsocEvento>();
        for (ItemEsocInsercaoRecibo item : vo.getItens()) {
            EsocEvento esocEvento = item.getEsocEvento();
            esocEvento.setNrRecibo(null);
            esocEvento.setStatus(ConstantsESocial.STATUS_REJEITAO_401);
            esocEvento.setInformarReciboManual(Short.valueOf((short)0));
            esocs.add(esocEvento);
        }
        for (EsocEvento esoc : esocs) {
            CoreDAOFactory.getInstance().getDAOEsocEvento().saveOrUpdate(esoc);
        }
        CoreDAOFactory.getInstance().getDAOEsocEvento().delete(vo);
    }
}

