/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.tabelasiniciais;

import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;

public class UtilityAlteracaoS1050 {
    public void gerarEventoAlteracaoEsocial(HorarioTrabalho horario, Usuario usuario, Short tipo, Date dataInicio, Date dataFinal, Empresa empresa) throws ExceptionService, ExceptionEsocial, ExceptionDatabase, ExceptionReflection {
        block9: {
            block8: {
                if (horario.getEsocCadastroHorario() == null) {
                    return;
                }
                if (horario.getEsocCadastroHorario().getTipoJornada().getCodigo().equals((short)1) || horario.getEsocCadastroHorario().getTipoJornada().getCodigo().equals("9")) break block8;
                if (horario.getEsocCadastroHorario().getInfoHorario().getPreEventosEsocial().isEmpty()) {
                    throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
                }
                for (EsocPreEvento esocPreEvento : horario.getEsocCadastroHorario().getInfoHorario().getPreEventosEsocial()) {
                    if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getEventoProdRestritaProducao().equals(tipo)) continue;
                    if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                        throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
                    }
                    EsocPreEvento newPreEvento = this.createNewPreEventoHorario(horario.getEsocCadastroHorario().getInfoHorario(), usuario, tipo, dataInicio, dataFinal, empresa);
                    newPreEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
                    newPreEvento.setEventoAnterior(esocPreEvento);
                    esocPreEvento.setEventoPosterior(newPreEvento);
                    CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
                    return;
                }
                break block9;
            }
            if (!horario.getEsocCadastroHorario().getTipoJornada().getCodigo().equals((short)1)) break block9;
            if (horario.getEsocCadastroHorario().getListaHorario().isEmpty()) {
                return;
            }
            for (InfoHorarioTrabalho info : horario.getEsocCadastroHorario().getListaHorario()) {
                if (info.getPreEventosEsocial().isEmpty()) continue;
                for (EsocPreEvento esocPreEvento : info.getPreEventosEsocial()) {
                    if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getEventoProdRestritaProducao().equals(tipo)) continue;
                    if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                        throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
                    }
                    EsocPreEvento newPreEvento = this.createNewPreEventoHorario(info, usuario, tipo, dataInicio, dataFinal, empresa);
                    newPreEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
                    newPreEvento.setEventoAnterior(esocPreEvento);
                    esocPreEvento.setEventoPosterior(newPreEvento);
                    CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
                }
            }
        }
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoHorario(InfoHorarioTrabalho vo, Usuario usuario, Short prodEvento, Date dataInicio, Date dataFinal, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(dataInicio);
        if (dataFinal != null) {
            pre.setDataFimVal(dataFinal);
        } else {
            pre.setDataFimVal(null);
        }
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(dataInicio);
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("Horario Trabalho");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(8L));
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (vo instanceof EmpresaRh) {
            preEvento.setEmpresaRH((EmpresaRh)vo);
        } else if (vo instanceof TipoCalculoEvento) {
            preEvento.setTipoCalculo((TipoCalculoEvento)vo);
        } else if (vo instanceof EsocCadastroEstabelcimento) {
            preEvento.setEstabelecimento((EsocCadastroEstabelcimento)vo);
        } else if (vo instanceof EsocCadastroLotacaoTributaria) {
            preEvento.setLotacaoTrbutaria((EsocCadastroLotacaoTributaria)vo);
        } else if (vo instanceof Funcao) {
            preEvento.setFuncao((Funcao)vo);
        } else if (vo instanceof InfoHorarioTrabalho) {
            preEvento.setInfoHorario((InfoHorarioTrabalho)vo);
        } else {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
    }
}

