/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.fichaconteudoimportacaofci.versao103;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.FichaConteudoImportacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoFichaConteudoImportacao;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.fichaconteudoimportacaofci.exceptions.FCIWritterException;
import mentorcore.service.impl.fichaconteudoimportacaofci.versao103.FCIFormat007;
import mentorcore.service.impl.spedfiscal.versao007.model.ContadorRegistros;
import mentorcore.tools.DateUtil;

public class FCIWritter001 {
    private FCIFormat007 form = new FCIFormat007();
    private String versao = "1.0";
    private String endOfRegister = "\r\n";
    private char separator = (char)124;
    private final TLogger logger = TLogger.get(this.getClass());
    private ContadorRegistros cont = new ContadorRegistros();

    public void fciWritter(FichaConteudoImportacao vo, File file) throws FCIWritterException, ExceptionDatabase, ExceptionService {
        try {
            Date dataIn = vo.getDataInicial();
            Empresa emp = vo.getEmpresa();
            List produtos = vo.getProdutos();
            File bloco0 = this.createWritterBlock0(emp);
            File bloco5 = this.createWritterBlock5(emp, produtos);
            File bloco9 = this.createWritterBlock9();
            this.apendToSomeFile(file, bloco0, bloco5, bloco9);
        }
        catch (IOException ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new FCIWritterException("Diret\u00f3rio n\u00e3o encontrado");
        }
    }

    private File getFilePath(String directory, Date date) {
        String fileName = "fci";
        String dtIn = DateUtil.dateToStr(date, "dd_MM_yyyy");
        File f = new File(directory + File.separatorChar + fileName + dtIn + ".txt");
        return f;
    }

    private File createWritterBlock0(Empresa emp) throws IOException, ExceptionDatabase, FCIWritterException {
        File f = File.createTempFile("fci_bloco_0", ".txt");
        PrintWriter p = new PrintWriter(f, "UTF-8");
        this.writterReg0000(p, emp);
        this.writterReg0001(p, "Texto em caracteres UTF-8: (d\u00edgrafo BR)'\u00e7\u00e3o',(d\u00edgrafo espanhol-enhe)'\u00f1',(trema)'\u00dc',(ordinais)'\u00aa\u00ba',(ligamento s+z alem\u00e3o)'\u00df'.");
        this.writterReg0010(p, emp);
        this.writterReg0990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg0000(PrintWriter p, Empresa emp) {
        p.append("0000");
        p.append(this.separator + this.form.clearString(emp.getPessoa().getComplemento().getCnpj()));
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 100));
        p.append(this.separator + this.versao);
        p.append(this.endOfRegister);
        this.cont.soma1("0000");
    }

    private void writterReg0001(PrintWriter p, String texto) {
        p.append("0001");
        p.append(this.separator + texto);
        p.append(this.endOfRegister);
    }

    private void writterReg0010(PrintWriter p, Empresa emp) {
        Endereco end = emp.getPessoa().getEndereco();
        p.append("0010");
        p.append(this.separator + this.form.formatString(this.form.clearString(emp.getPessoa().getComplemento().getCnpj()), 14));
        p.append(this.separator + this.form.formatString(emp.getPessoa().getNome(), 255));
        p.append(this.separator + this.form.formatString(this.form.clearString(emp.getPessoa().getComplemento().getInscEst()), 20));
        p.append(this.separator + this.form.formatString(end.getLogradouro(), 255));
        p.append(this.separator + this.form.formatStringClear(end.getCep(), 8));
        p.append(this.separator + this.form.formatString(end.getCidade().getDescricao(), 255));
        p.append(this.separator + this.form.formatString(end.getCidade().getUf().getSigla(), 2));
        p.append(this.endOfRegister);
        this.cont.soma1("0010");
    }

    private void writterReg0990(PrintWriter p) {
        p.append("0990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('0') + 2L));
        p.append(this.endOfRegister);
    }

    private File createWritterBlock5(Empresa emp, List produtos) throws IOException, ExceptionDatabase, FCIWritterException {
        File f = File.createTempFile("fci_bloco_5", ".txt");
        PrintWriter p = new PrintWriter(f, "UTF-8");
        this.writterReg5001(p);
        this.writterReg5020(p, produtos);
        this.writterReg5990(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg5001(PrintWriter p) {
        p.append("5001");
        p.append(this.endOfRegister);
    }

    private void writterReg5020(PrintWriter p, List produtos) {
        for (Object o : produtos) {
            ProdutoFichaConteudoImportacao pf = (ProdutoFichaConteudoImportacao)o;
            Produto prod = pf.getProduto();
            p.append("5020");
            p.append(this.separator + this.form.formatString(prod.getNome(), 255));
            p.append(this.separator + this.form.formatString(prod.getNcm().getCodigo(), 8));
            p.append(this.separator + this.form.formatString(prod.getIdentificador().toString(), 50));
            p.append("" + this.separator);
            p.append(this.separator + this.form.formatString(prod.getUnidadeMedida().getUnidadeMedidaFCI().getSigla(), 6));
            p.append(this.separator + this.form.formatNumber(pf.getValorSaidaMercadoria(), 2));
            p.append(this.separator + this.form.formatNumber(pf.getValorParcelaImportada(), 2));
            p.append(this.separator + this.form.formatNumber(pf.getCoeficienteImportacao(), 2));
            p.append(this.endOfRegister);
            this.cont.soma1("5020");
        }
    }

    private void writterReg5990(PrintWriter p) {
        p.append("5990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('5') + 2L));
        p.append(this.endOfRegister);
    }

    private File createWritterBlock9() throws FileNotFoundException, IOException {
        File f = File.createTempFile("fci_bloco_9", ".txt");
        PrintWriter p = new PrintWriter(f, "UTF-8");
        this.writterReg9001(p);
        this.writterReg9900(p);
        this.writterReg9990(p);
        this.writterReg9999(p);
        p.flush();
        p.close();
        return f;
    }

    private void writterReg9001(PrintWriter p) {
        p.append("9001");
        p.append(this.endOfRegister);
    }

    private void writterReg9900(PrintWriter p) {
        Set keys = this.cont.getContador().keySet();
        int contador = 0;
        for (Object o : keys) {
            String tk = (String)o;
            Long value = (Long)this.cont.getContador().get(tk);
            this.writterReg9900Aux(p, tk, value);
            ++contador;
        }
        this.cont.somaVarios("9900", contador);
        this.cont.soma1("9990");
        this.cont.soma1("9999");
    }

    private void writterReg9990(PrintWriter p) {
        p.append("9990");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhas('9')));
        p.append(this.endOfRegister);
    }

    private void writterReg9999(PrintWriter p) {
        p.append("9999");
        p.append(this.separator + this.form.formatNumberLong(this.cont.getNrLinhasTotal() + 5L));
        p.append(this.endOfRegister);
    }

    private void writterReg9900Aux(PrintWriter p, String tk, Long value) {
        p.append("9900");
        p.append(this.separator + tk);
        p.append(this.separator + String.valueOf(this.form.formatNumberInt(value.intValue())));
        p.append(this.endOfRegister);
    }

    private void apendToSomeFile(File file, File bloco0, File bloco5, File bloco9) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        this.copy(bloco0, out);
        this.copy(bloco5, out);
        this.copy(bloco9, out);
        bloco0.delete();
        bloco5.delete();
        bloco9.delete();
        ((OutputStream)out).close();
    }

    void copy(File src, OutputStream out) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)in).close();
    }
}

