/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro;

import com.touchcomp.basementor.constants.enums.meiopagamento.EnumConstTipoMeioPagamento;
import com.touchcomp.basementor.model.vo.CnabFolhaAtivos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabAutorizacaoDebito;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.LayoutCobranca;
import com.touchcomp.basementor.model.vo.LayoutFolhaPagamento;
import com.touchcomp.basementor.model.vo.OcorrenciaRetornoCnab;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.RemessaCnabAutorizacaoDebito;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.factory.CoreCnabRemessaFactory;
import mentorcore.service.impl.financeiro.cnabnovo.factory.CoreCnabRetornoFactory;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaAutorizacaoDebitoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityFinanceiro;
import mentorcore.service.impl.financeiro.utility.UtilityPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityRecebimentoCnab;
import mentorcore.utilities.impl.financeiro.UtilityRemessaCnab;
import mentorcore.utilities.impl.financeiro.UtilityRetornoCnab;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceCnab
extends CoreService {
    public static final String FIND_OCORRENCIA_COBRANCA = "findOcorrenciaCobranca";
    public static final String CRIAR_ARQUIVO_REMESSA_FOLHA = "criarArquivoRemessaFolha";
    public static final String GET_RETORNO_FOLHA_CNAB = "getRetornoFolhaCnab";
    public static final String GET_ITENS_REMESSA_FOLHA_CNAB = "getItensRemessaFolhaCnab";
    public static final String IMPRIMIR_COMPROVANTE_PGTO_FOLHA = "imprimirComprovantePgtoFolha";
    public static final String DELETE_TITULO_FROM_ITEM_REMESSA_FOLHA_CNAB = "deleteTituloFromItemRemessaFolhaCnab";
    public static final String DELETE_ITEM_REMESSA_FOLHA_CNAB = "deleteItemRemessaFolhaCnab";
    public static final String FIND_CONFIGURACAO_CNAB_TO_TITULO = "findConfiguracaoCnabToTitulo";
    public static final String GERAR_REMESSA_PAGAMENTO = "gerarRemessaPagamento";
    public static final String GERAR_REMESSA_COBRANCA = "gerarRemessaCobranca";
    public static final String GERAR_REMESSA_AUTORIZACAO_DEBITO = "gerarRemessaAutorizacaoDebito";
    public static final String GERAR_RETORNO_COBRANCA = "gerarRetornoCobranca";
    public static final String GERAR_RETORNO_PAGAMENTO = "gerarRetornoPagamento";

    public OcorrenciaRetornoCnab findOcorrenciaCobranca(CoreRequestContext request) throws IOException {
        LayoutCobranca layoutCobranca = (LayoutCobranca)request.getAttribute("layoutCobranca");
        String codigo = (String)request.getAttribute("codigo");
        return UtilityFinanceiro.findOcorrenciaCobranca(layoutCobranca, codigo);
    }

    public void criarArquivoRemessaFolha(CoreRequestContext request) throws IOException, ExceptionService {
        RemessaFolhaCnab remessaFolhaCnab = (RemessaFolhaCnab)request.getAttribute("arquivoRemessaFolha");
        File file = (File)request.getAttribute("file");
        UtilityRemessaCnab.criarArquivoRemessaFolha(file, remessaFolhaCnab);
    }

    public HashMap getRetornoFolhaCnab(CoreRequestContext request) throws IOException, FileNotFoundException, ExceptionService, Exception {
        CnabFolhaAtivos cnabFolhaAtivos = (CnabFolhaAtivos)request.getAttribute("cnabFolhaAtivos");
        File file = (File)request.getAttribute("file");
        LayoutFolhaPagamento layoutFolhaCnab = (LayoutFolhaPagamento)request.getAttribute("layoutFolhaCnab");
        Short tipoTitulosFolha = (Short)request.getAttribute("tipoTitulosFolha");
        EmpresaFinanceiro empresaFinanceiro = (EmpresaFinanceiro)request.getAttribute("empresaFinanceiro");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesGerenciais opGer = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        return UtilityRetornoCnab.getRetornoFolhaCnab(cnabFolhaAtivos, file, layoutFolhaCnab, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
    }

    public List getItensRemessaFolhaCnab(CoreRequestContext request) {
        Date dataPgtoInicial = (Date)request.getAttribute("dataPgtoInicial");
        Date dataPgtoFinal = (Date)request.getAttribute("dataPgtoFinal");
        CnabFolhaAtivos cnabFolhaAtivos = (CnabFolhaAtivos)request.getAttribute("cnabFolhaAtivos");
        Short tipoTituloFolha = (Short)request.getAttribute("tipoTituloFolha");
        Short tipoRemessaFolha = (Short)request.getAttribute("tipoRemessaFolha");
        Short buscarRejeitados = (Short)request.getAttribute("buscarRejeitados");
        List fechamentos = (List)request.getAttribute("fechamentos");
        List listRemessaFolhaCnab = (List)request.getAttribute("listRemessaFolhaCnab");
        return UtilCnabFolha.getItensRemessaFolhaCnab(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos, tipoTituloFolha, tipoRemessaFolha, buscarRejeitados, listRemessaFolhaCnab, fechamentos);
    }

    public JasperPrint imprimirComprovantePgtoFolha(CoreRequestContext r) throws ExceptionService, FileNotFoundException, IOException {
        File file = (File)r.getAttribute("file");
        CnabFolhaAtivos banco = (CnabFolhaAtivos)r.getAttribute("banco");
        LayoutFolhaPagamento layout = (LayoutFolhaPagamento)r.getAttribute("layout");
        HashMap parametros = (HashMap)r.getAttribute("parametros");
        JasperPrint jasperPrint = UtilityRetornoCnab.imprimirComprovantePgtoFolha(file, banco, layout, parametros);
        return jasperPrint;
    }

    public void deleteTituloFromItemRemessaFolhaCnab(CoreRequestContext r) {
        Long idTitulo = (Long)r.getAttribute("idTitulo");
        UtilCnabFolha.deleteTituloFromItemRemessaFolhaCnab(idTitulo);
    }

    public void deleteItemRemessaFolhaCnab(CoreRequestContext r) {
        Long idItemRemessaFolhaCnab = (Long)r.getAttribute("idItemRemessaFolhaCnab");
        UtilCnabFolha.deleteItemRemessaFolhaCnab(idItemRemessaFolhaCnab);
    }

    public List<Titulo> findConfiguracaoCnabToTitulo(CoreRequestContext request) {
        List titulos = (List)request.getAttribute("titulos");
        for (Titulo titulo : titulos) {
            ConfiguracaoCnab confCnab = CoreDAOFactory.getInstance().getDAORemessaCnabCobranca().findConfiguracaoCnabToTitulo(titulo);
            if (confCnab == null) continue;
            titulo.setConfiguracaoCnab(confCnab);
        }
        return titulos;
    }

    public void gerarRemessaPagamento(CoreRequestContext request) throws IOException, ExceptionCnab, ExceptionValidation, ExceptionService {
        RemessaCnabPagamento vo = (RemessaCnabPagamento)request.getAttribute("remessa");
        File file = (File)request.getAttribute("file");
        String codificacaoArquivo = (String)request.getAttribute("codificacaoArquivo");
        InstituicaoValores instValor = vo.getInstituicaoValores();
        ConfiguracaoCnab configuracao = null;
        for (ItemRemessaCnabPagamento i : vo.getItemRemessaPagamento()) {
            if (i.getItemBordero().getItemLiberacao().getTitulo().getConfiguracaoCnab() == null) continue;
            configuracao = i.getItemBordero().getItemLiberacao().getTitulo().getConfiguracaoCnab();
            break;
        }
        if (configuracao == null) {
            throw new ExceptionCnab("N\u00e3o foi encontrada nenhuma Configura\u00e7\u00e3o CNAB nos T\u00edtulos da Remessa. Opera\u00e7\u00e3o cancelada!");
        }
        if (configuracao.getLayout() == null) {
            throw new ExceptionCnab("A Configura\u00e7\u00e3o CNAB n\u00e3o possui um Layout ou nenhum T\u00edtulo possui Configura\u00e7\u00e3o CNAB!");
        }
        for (ItemRemessaCnabPagamento i : vo.getItemRemessaPagamento()) {
            if (ToolMethods.isEquals((Object)i.getItemBordero().getMeioPagamento().getTipoMeioPagamento(), (Object)EnumConstTipoMeioPagamento.TRANSFERENCIA.value) || ToolMethods.isEquals((Object)i.getItemBordero().getMeioPagamento().getTipoMeioPagamento(), (Object)EnumConstTipoMeioPagamento.PAGAMENTO.value)) continue;
            throw new ExceptionCnab("No cadastro do Meio de Pagamento informado nos itens do bordero de pagamento, o campo Tipo Pagamento CNAB Pagamento deve estar marcado como Pagamento ou Transferencia");
        }
        RemessaPagamentoCnabInterface pagamento = this.getInterfaceRemessaPagamento(instValor, configuracao.getLayout());
        if (instValor.getNrBanco().equals("341")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "341", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("001")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "001", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("237")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "237", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("104")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "104", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("033")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "033", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("756")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "756", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("422")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento400(file, "422", pagamento, vo, codificacaoArquivo);
        } else if (instValor.getNrBanco().equals("136")) {
            UtilityPagamentoCnab.gerarArquivoRemessaPagamento240(file, "136", pagamento, vo, codificacaoArquivo);
        } else {
            throw new ExceptionCnab("Banco n\u00e3o suportado.");
        }
    }

    public void gerarRemessaCobranca(CoreRequestContext request) throws IOException, ExceptionCnab {
        RemessaCnabCobranca remessa = (RemessaCnabCobranca)request.getAttribute("arquivoRemessaCnab");
        File file = (File)request.getAttribute("file");
        Short tipoNumero = (Short)request.getAttribute("tipoNumero");
        String codificacaoArquivo = (String)request.getAttribute("codificacaoArquivo");
        InstituicaoValores instValor = remessa.getInstituicaoValores();
        ConfiguracaoCnab configuracao = null;
        for (ItemRemessaCnabCobranca i : remessa.getItemRemessaCobranca()) {
            if (i.getItemBordero().getTitulo().getConfiguracaoCnab() == null) continue;
            configuracao = i.getItemBordero().getTitulo().getConfiguracaoCnab();
            break;
        }
        if (configuracao == null) {
            throw new ExceptionCnab("N\u00e3o foi encontrada nenhuma Configura\u00e7\u00e3o CNAB nos T\u00edtulos da Remessa. Opera\u00e7\u00e3o cancelada!");
        }
        if (configuracao.getLayout() == null) {
            throw new ExceptionCnab("A Configura\u00e7\u00e3o CNAB n\u00e3o possui um Layout ou nenhum T\u00edtulo possui Configura\u00e7\u00e3o CNAB!");
        }
        RemessaRecebimentoCnabInterface recebimento = this.getInterfaceRecebimento(instValor, configuracao.getLayout());
        recebimento.createFile(file, ".txt", remessa.getNumeroSequenciaArquivo(), configuracao);
        recebimento.resetCounter();
        recebimento.buildHeaderFile(remessa, configuracao, codificacaoArquivo);
        recebimento.buildHeaderPackage(remessa, configuracao, codificacaoArquivo);
        recebimento.buildDetail(remessa, tipoNumero, configuracao, codificacaoArquivo);
        recebimento.buildTrailerPackage(configuracao, codificacaoArquivo);
        recebimento.buildTrailerFile(configuracao, codificacaoArquivo);
        recebimento.validationBeforePrint();
    }

    public void gerarRemessaAutorizacaoDebito(CoreRequestContext request) throws IOException, ExceptionCnab {
        RemessaCnabAutorizacaoDebito remessa = (RemessaCnabAutorizacaoDebito)request.getAttribute("arquivoRemessa");
        File file = (File)request.getAttribute("file");
        InstituicaoValores instValor = remessa.getInstituicaoValores();
        ConfiguracaoCnab configuracao = null;
        for (ItemRemessaCnabAutorizacaoDebito i : remessa.getItemRemessaAutorizacao()) {
            if (i.getItemBordero().getTitulo().getConfiguracaoCnab() == null) continue;
            configuracao = i.getItemBordero().getTitulo().getConfiguracaoCnab();
            break;
        }
        if (configuracao == null) {
            throw new ExceptionCnab("N\u00e3o foi encontrada nenhuma Configura\u00e7\u00e3o CNAB nos T\u00edtulos da Remessa. Opera\u00e7\u00e3o cancelada!");
        }
        if (configuracao.getLayout() == null) {
            throw new ExceptionCnab("A Configura\u00e7\u00e3o CNAB n\u00e3o possui um Layout ou nenhum T\u00edtulo possui Configura\u00e7\u00e3o CNAB!");
        }
        RemessaAutorizacaoDebitoCnabInterface recebimento = this.getInterfaceAutorizacaoDebito(instValor, configuracao.getLayout());
        recebimento.createFile(file, ".txt", remessa.getNumeroSequenciaArquivo(), configuracao);
        recebimento.resetCounter();
        recebimento.buildHeaderFile(remessa, configuracao);
        recebimento.buildDetail(remessa, configuracao);
        recebimento.buildTrailerFile(configuracao);
        recebimento.validationBeforePrint();
    }

    private RemessaRecebimentoCnabInterface getInterfaceRecebimento(InstituicaoValores instValor, String layout) throws ExceptionCnab {
        switch (layout) {
            case "200": {
                throw new ExceptionCnab("Layout 200 Bytes n\u00e3o suportado.");
            }
            case "240": {
                return this.getInterfaceRemessaRecebimento240(instValor);
            }
            case "240_V2": {
                return this.getInterfaceRemessaRecebimento240V2(instValor);
            }
            case "400": {
                return this.getInterfaceRemessaRecebimento400(instValor);
            }
            case "500": {
                throw new ExceptionCnab("Layout 500 Bytes n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaAutorizacaoDebitoCnabInterface getInterfaceAutorizacaoDebito(InstituicaoValores instValor, String layout) throws ExceptionCnab {
        switch (layout) {
            case "200": {
                return this.getInterfaceRemessaDebitoConta200(instValor);
            }
            case "240": {
                throw new ExceptionCnab("Layout 240 Bytes n\u00e3o suportado.");
            }
            case "400": {
                throw new ExceptionCnab("Layout 400 Bytes n\u00e3o suportado.");
            }
            case "500": {
                throw new ExceptionCnab("Layout 500 Bytes n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    public HashMap gerarRetornoCobranca(CoreRequestContext request) throws IOException, ExceptionCnab, ExceptionService, Exception {
        File file = (File)request.getAttribute("file");
        EmpresaFinanceiro empresaFinanceiro = (EmpresaFinanceiro)request.getAttribute("empresaFinanceiro");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        InstituicaoValores instValor = (InstituicaoValores)request.getAttribute("instValor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)request.getAttribute("empresaContabilidade");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        Short agruparBaixas = (Short)request.getAttribute("agruparBaixas");
        Date dataBaixa = (Date)request.getAttribute("dataBaixa");
        Short gerarTituloAntecipado = (Short)request.getAttribute("gerarTituloAntecipado");
        String layout = UtilityArquivoCnab.getLayoutArquivoCnab(file);
        RetornoRecebimentoCnabInterface retornoRecebimento = this.getInterfaceRetornoRecebimento(instValor, layout);
        retornoRecebimento.createBufferedReader(file);
        retornoRecebimento.resetVariables();
        if (!retornoRecebimento.isBankValid(instValor).booleanValue()) {
            throw new ExceptionCnab("O arquivo informado n\u00e3o confere com o Banco selecionado");
        }
        retornoRecebimento.readFile(opcoesFinanceiras);
        List<RetornoRecebimentoCnab> listRetorno = retornoRecebimento.getList();
        UtilityRecebimentoCnab.updateRetornoRecebimentoCnab(listRetorno, instValor, gerarTituloAntecipado);
        HashMap retornoCobranca = UtilityRecebimentoCnab.getRetornoCobranca(listRetorno, empresaFinanceiro, empresa, agruparBaixas, dataBaixa, instValor, empresaContabilidade, opcoesGerenciais, opcoesContabeis);
        return retornoCobranca;
    }

    private RetornoRecebimentoCnabInterface getInterfaceRetornoRecebimento(InstituicaoValores instValor, String layout) throws ExceptionCnab {
        switch (layout) {
            case "200": {
                throw new ExceptionCnab("Layout 200 Bytes n\u00e3o suportado.");
            }
            case "240": {
                return this.getInterfaceRetornoRecebimento240(instValor);
            }
            case "240_V2": {
                return this.getInterfaceRetornoRecebimento240V2(instValor);
            }
            case "400": {
                return this.getInterfaceRetornoRecebimento400(instValor);
            }
            case "500": {
                throw new ExceptionCnab("Layout 500 Bytes n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RetornoRecebimentoCnabInterface getInterfaceRetornoRecebimento400(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "237": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBradescoRecebimento400();
            }
            case "756": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSicoobRecebimento400();
            }
            case "041": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBanrisulRecebimento400();
            }
            case "341": {
                return CoreCnabRetornoFactory.getFactory().getRetornoItauRecebimento400();
            }
            case "033": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSantanderRecebimento400();
            }
            case "001": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBancoBrasilRecebimento400();
            }
            case "422": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSafraRecebimento400();
            }
            case "707": {
                return CoreCnabRetornoFactory.getFactory().getRetornoDaycovalRecebimento400();
            }
            case "637": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSofisaRecebimento400();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RetornoRecebimentoCnabInterface getInterfaceRetornoRecebimento240(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "104": {
                return CoreCnabRetornoFactory.getFactory().getRetornoCaixaRecebimento240();
            }
            case "001": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBancoBrasilRecebimento240();
            }
            case "399": {
                return CoreCnabRetornoFactory.getFactory().getRetornoHsbcRecebimento240();
            }
            case "033": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSantanderRecebimento240();
            }
            case "756": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSicoobRecebimento240();
            }
            case "237": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBradecoRecebimento240();
            }
            case "136": {
                return CoreCnabRetornoFactory.getFactory().getRetornoUnicredbRecebimento240();
            }
            case "655": {
                return CoreCnabRetornoFactory.getFactory().getRetornoVotorantimRecebimento240();
            }
            case "246": {
                return CoreCnabRetornoFactory.getFactory().getRetornoABCRecebimento240();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaPagamentoCnabInterface getInterfaceRemessaPagamento(InstituicaoValores instValor, String layout) throws ExceptionCnab {
        switch (layout) {
            case "150": {
                throw new ExceptionCnab("Layout 150 Bytes n\u00e3o suportado.");
            }
            case "200": {
                throw new ExceptionCnab("Layout 200 Bytes n\u00e3o suportado.");
            }
            case "240": {
                return this.getInterfaceRemessaPagamento240(instValor);
            }
            case "400": {
                return this.getInterfaceRemessaPagamento400(instValor);
            }
            case "500": {
                throw new ExceptionCnab("Layout 500 Bytes n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaPagamentoCnabInterface getInterfaceRemessaPagamento240(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "001": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoBrasilPagamento240();
            }
            case "041": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBanrisulPagamento240();
            }
            case "237": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBradescoPagamento240();
            }
            case "104": {
                return CoreCnabRemessaFactory.getFactory().getRemessaCaixaPagamento240();
            }
            case "399": {
                return CoreCnabRemessaFactory.getFactory().getRemessaHsbcPagamento240();
            }
            case "341": {
                return CoreCnabRemessaFactory.getFactory().getRemessaItauPagamento240();
            }
            case "033": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSantanderPagamento240();
            }
            case "756": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSicoobPagamento240();
            }
            case "136": {
                return CoreCnabRemessaFactory.getFactory().getRemessaUnicredPagamento240();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaPagamentoCnabInterface getInterfaceRemessaPagamento400(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "422": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSafraPagamento400();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaRecebimentoCnabInterface getInterfaceRemessaRecebimento400(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "237": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBradescoRecebimento400();
            }
            case "756": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSicoobRecebimento400();
            }
            case "041": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBanrisulRecebimento400();
            }
            case "341": {
                return CoreCnabRemessaFactory.getFactory().getRemessaItauRecebimento400();
            }
            case "033": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSantanderRecebimento400();
            }
            case "001": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoBrasilRecebimento400();
            }
            case "422": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSafraRecebimento400();
            }
            case "707": {
                return CoreCnabRemessaFactory.getFactory().getRemessaDaycovalRecebimento400();
            }
            case "637": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSofisaRecebimento400();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaRecebimentoCnabInterface getInterfaceRemessaRecebimento240(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "104": {
                return CoreCnabRemessaFactory.getFactory().getRemessaCaixaRecebimento240();
            }
            case "001": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoBrasilRecebimento240();
            }
            case "399": {
                return CoreCnabRemessaFactory.getFactory().getRemessaHsbcRecebimento240();
            }
            case "033": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSantanderRecebimento240();
            }
            case "756": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSicooRecebimento240();
            }
            case "237": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBradescoRecebimento240();
            }
            case "604": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoIndustriaBrasilRecebimento240();
            }
            case "136": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoUnicredRecebimento240();
            }
            case "655": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoVotorantimRecebimento240();
            }
            case "246": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBancoABCRecebimento240();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaAutorizacaoDebitoCnabInterface getInterfaceRemessaDebitoConta200(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "104": {
                throw new ExceptionCnab("Banco n\u00e3o suportado.");
            }
            case "001": {
                throw new ExceptionCnab("Banco n\u00e3o suportado.");
            }
            case "399": {
                throw new ExceptionCnab("Banco n\u00e3o suportado.");
            }
            case "033": {
                throw new ExceptionCnab("Banco n\u00e3o suportado.");
            }
            case "756": {
                return CoreCnabRemessaFactory.getFactory().getRemessaSicooAutorizacaoDebito200();
            }
            case "237": {
                throw new ExceptionCnab("Banco n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    public HashMap gerarRetornoPagamento(CoreRequestContext request) throws IOException, ExceptionCnab, ExceptionService, Exception {
        File file = (File)request.getAttribute("file");
        EmpresaFinanceiro empresaFinanceiro = (EmpresaFinanceiro)request.getAttribute("empresaFinanceiro");
        InstituicaoValores instValor = (InstituicaoValores)request.getAttribute("instValor");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)request.getAttribute("opcoesGerenciais");
        Short agruparBaixas = (Short)request.getAttribute("agruparBaixas");
        Date dataBaixa = (Date)request.getAttribute("dataBaixa");
        Double valorTolerancia = (Double)request.getAttribute("valorTolerancia");
        String layout = UtilityArquivoCnab.getLayoutArquivoCnab(file);
        RetornoPagamentoCnabInterface retornoPagto = this.getInterfaceRetornoPagamento(instValor, layout);
        retornoPagto.createBufferedReader(file);
        retornoPagto.resetVariables();
        if (!retornoPagto.isBankValid(instValor).booleanValue()) {
            throw new ExceptionCnab("O arquivo informado n\u00e3o confere com o Banco selecionado");
        }
        retornoPagto.readFile(empresaFinanceiro);
        List<RetornoPagamentoCnab> listRetorno = retornoPagto.getList();
        UtilityPagamentoCnab.updateRetornoPagamentoCnab(listRetorno);
        HashMap retornoPagamento = UtilityPagamentoCnab.getRetornoPagamento(listRetorno, empresa, agruparBaixas, dataBaixa, valorTolerancia, empresaFinanceiro, opcoesGerenciais);
        return retornoPagamento;
    }

    private RetornoPagamentoCnabInterface getInterfaceRetornoPagamento(InstituicaoValores instValor, String layout) throws ExceptionCnab {
        switch (layout) {
            case "150": {
                throw new ExceptionCnab("Layout 150 Bytes n\u00e3o suportado.");
            }
            case "200": {
                throw new ExceptionCnab("Layout 200 Bytes n\u00e3o suportado.");
            }
            case "240": {
                return this.getInterfaceRetornoPagamento240(instValor);
            }
            case "400": {
                return this.getInterfaceRetornoPagamento400(instValor);
            }
            case "500": {
                throw new ExceptionCnab("Layout 500 Bytes n\u00e3o suportado.");
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RetornoPagamentoCnabInterface getInterfaceRetornoPagamento240(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "001": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBancoBrasilPagamento240();
            }
            case "041": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBanrisulPagamento240();
            }
            case "237": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBradescoPagamento240();
            }
            case "104": {
                return CoreCnabRetornoFactory.getFactory().getRetornoCaixaPagamento240();
            }
            case "399": {
                return CoreCnabRetornoFactory.getFactory().getRetornoHsbcPagamento240();
            }
            case "341": {
                return CoreCnabRetornoFactory.getFactory().getRetornoItauPagamento240();
            }
            case "033": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSantanderPagamento240();
            }
            case "756": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSicoobPagamento240();
            }
            case "136": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSicoobPagamento240();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RetornoPagamentoCnabInterface getInterfaceRetornoPagamento400(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "422": {
                return CoreCnabRetornoFactory.getFactory().getRetornoSafraPagamento400();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RemessaRecebimentoCnabInterface getInterfaceRemessaRecebimento240V2(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "104": {
                return CoreCnabRemessaFactory.getFactory().getRemessaCaixaRecebimento240V2();
            }
            case "BRADESCO": {
                return CoreCnabRemessaFactory.getFactory().getRemessaBradescoRecebimento240V2();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }

    private RetornoRecebimentoCnabInterface getInterfaceRetornoRecebimento240V2(InstituicaoValores instValor) throws ExceptionCnab {
        switch (instValor.getNrBanco()) {
            case "104": {
                return CoreCnabRetornoFactory.getFactory().getRetornoCaixaRecebimento240V2();
            }
            case "237": {
                return CoreCnabRetornoFactory.getFactory().getRetornoBradescoRecebimento240V2();
            }
        }
        throw new ExceptionCnab("Banco n\u00e3o suportado.");
    }
}

