/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnab.bradesco;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.RemessaFolhaCnab;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutArquivoRemessaCnabBradesco {
    private static Integer numeroSequencial = 1;
    private static Double valorTotalFolha = 0.0;

    public static void gerarArquivoCnabFolhaBradesco(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException, ExceptionService {
        if (!remessaFolhaCnab.getLayoutFolhaPagamento().getPosicoes().equals("240")) {
            throw new IOException("Layout inv\u00e1lido, o mesmo deve ser de 240 posi\u00e7\u00f5es. Operacao cancelada.");
        }
        LayoutArquivoRemessaCnabBradesco.gerarArquivoCnabFolhaBradesco240(remessaFolhaCnab, file);
    }

    public static String getFileName() {
        Integer dia = DateUtil.dayFromDate(new Date());
        Integer mes = DateUtil.monthFromDate(new Date());
        Timestamp t = DateUtil.toTimestamp(new Date());
        Integer hora = t.getHours();
        Integer min = t.getMinutes();
        return "FP" + (String)(dia.toString().length() == 1 ? "0" + dia.toString() : dia.toString()) + (String)(mes.toString().length() == 1 ? "0" + mes.toString() : mes.toString()) + (String)(hora.toString().length() == 1 ? "0" + hora.toString() : hora.toString()) + (String)(min.toString().length() == 1 ? "0" + min.toString() : min.toString());
    }

    private static void gerarArquivoCnabFolhaBradesco240(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException, ExceptionService {
        File arquivo = new File(file, LayoutArquivoRemessaCnabBradesco.getFileName() + ".TXT");
        numeroSequencial = 1;
        valorTotalFolha = 0.0;
        if (!arquivo.exists()) {
            arquivo.createNewFile();
            ConfiguracaoCnab configuracao = LayoutArquivoRemessaCnabBradesco.getConfiguracaoCnab(remessaFolhaCnab);
            if (configuracao == null) {
                arquivo.delete();
                throw new ExceptionService("Nenhum dos T\u00edtulos que comp\u00f5em a remessa possuem Configura\u00e7\u00e3o Cnab. Operacao cancelada.");
            }
            LayoutArquivoRemessaCnabBradesco.buildHeaderFile(remessaFolhaCnab, arquivo);
            LayoutArquivoRemessaCnabBradesco.buildHeaderPackage(remessaFolhaCnab, arquivo, configuracao);
            for (ItemRemessaFolhaCnab itemRemessaFolhaCnab : remessaFolhaCnab.getItemRemessaFolhaCnab()) {
                LayoutArquivoRemessaCnabBradesco.buildDetailSegmentoA(itemRemessaFolhaCnab, arquivo, configuracao);
                LayoutArquivoRemessaCnabBradesco.buildDetailSegmentoB(itemRemessaFolhaCnab, arquivo, configuracao);
            }
        } else {
            arquivo.delete();
            throw new IOException("J\u00e1 existem um outro arquivo com mesmo nome na mesma pasta. Operacao cancelada.");
        }
        LayoutArquivoRemessaCnabBradesco.buildTrailerPackage(arquivo);
        LayoutArquivoRemessaCnabBradesco.buildTrailerFile(arquivo);
    }

    private static void buildHeaderFile(RemessaFolhaCnab remessaFolhaCnab, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaFolhaCnab.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaFolhaCnab.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha() != null) {
            if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().length() > 20) {
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento Folha excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento Folha");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(remessaFolhaCnab.getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getNrConta(), 12));
        if (remessaFolhaCnab.getContaValor().getDvConta().length() == 2) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(remessaFolhaCnab.getContaValor().getDvConta());
        }
        if (remessaFolhaCnab.getContaValor().getDvConta().length() == 2) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaFolhaCnab.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaFolhaCnab.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BRADESCO", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaFolhaCnab.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaFolhaCnab.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getNumRegistroDiario().toString(), 6));
        p.append("089");
        p.append("01600");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        p.println();
        p.flush();
        p.close();
    }

    private static void buildHeaderPackage(RemessaFolhaCnab remessaFolhaCnab, File arquivo, ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("1");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_OPERACAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_SERVICO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("FORMA_LANCAMENTO", configuracao));
        p.append("045");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaFolhaCnab.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha() != null) {
            if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().length() > 20) {
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento Folha excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento Folha");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(remessaFolhaCnab.getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getNrConta(), 12));
        if (remessaFolhaCnab.getContaValor().getDvConta().length() == 2) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(remessaFolhaCnab.getContaValor().getDvConta());
        }
        if (remessaFolhaCnab.getContaValor().getDvConta().length() == 2) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaFolhaCnab.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaFolhaCnab.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaFolhaCnab.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaFolhaCnab.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            throw new IOException(erro);
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro());
        if (logradouro.length() > 30) {
            p.append(logradouro.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaFolhaCnab.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaFolhaCnab.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.println();
        p.flush();
        p.close();
    }

    private static void buildDetailSegmentoA(ItemRemessaFolhaCnab itemRemessaFolhaCnab, File arquivo, ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        HashMap dadosColaborador = LayoutArquivoRemessaCnabBradesco.pesquisarColaborador(itemRemessaFolhaCnab, arquivo);
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_MOVIMENTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_INST_MOV", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_CAM_CENTRALIZADORA", configuracao));
        p.append(itemRemessaFolhaCnab.getRemessaFolhaCnab().getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)dadosColaborador.get("AGENCIA_COL"), 5));
        p.append((String)dadosColaborador.get("DIG_AGENCIA_COL"));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)dadosColaborador.get("CONTA_COL"), 12));
        String digitoVerificadorConta = (String)dadosColaborador.get("DIG_CONTA_COL");
        if (digitoVerificadorConta.length() == 2) {
            p.append(digitoVerificadorConta.substring(0, 1));
        } else {
            p.append(digitoVerificadorConta);
        }
        if (digitoVerificadorConta.length() == 2) {
            p.append(digitoVerificadorConta.substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeSacado = ToolString.substituiCaractereEspecial((String)itemRemessaFolhaCnab.getColaborador().getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(itemRemessaFolhaCnab.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(itemRemessaFolhaCnab.getRemessaFolhaCnab().getDataDebitoContaEmpresa()));
        p.append("BRL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        valorTotalFolha = valorTotalFolha + itemRemessaFolhaCnab.getValorPgto();
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)itemRemessaFolhaCnab.getValorPgto(), (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.getValueByKey("COMP_TIPO_SERVICO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private static void buildDetailSegmentoB(ItemRemessaFolhaCnab itemRemessaFolhaCnab, File arquivo, ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(itemRemessaFolhaCnab.getColaborador().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(itemRemessaFolhaCnab.getColaborador().getPessoa().getComplemento().getCnpj(), 14));
        Endereco enderecoColaborador = itemRemessaFolhaCnab.getColaborador().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoColaborador, itemRemessaFolhaCnab.getColaborador().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            throw new IOException(erro);
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getLogradouro());
        if (logradouro.length() > 30) {
            p.append(logradouro.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoColaborador.getNumero(), 5));
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoColaborador.getCep(), 1, itemRemessaFolhaCnab.getColaborador().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoColaborador.getCep(), 2, itemRemessaFolhaCnab.getColaborador().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoColaborador.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(itemRemessaFolhaCnab.getRemessaFolhaCnab().getDataDebitoContaEmpresa()));
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)itemRemessaFolhaCnab.getValorPgto(), (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private static HashMap pesquisarColaborador(ItemRemessaFolhaCnab itemRemessaFolhaCnab, File arquivo) throws IOException {
        HashMap dadosColaborador = UtilCnabFolha.getDadosColaborador(itemRemessaFolhaCnab.getColaborador());
        if (dadosColaborador == null || dadosColaborador.isEmpty()) {
            arquivo.delete();
            throw new IOException("Existem Colaboradores sem Dados Bancarios. V\u00e1 at\u00e9 o Recurso Manuten\u00e7\u00e3o de Colaborador e atualize o cadastro dos colaboradores sem Dados Banc\u00e1rios. Opera\u00e7\u00e3o cancelada! Colaborador: " + itemRemessaFolhaCnab.getColaborador().getIdentificador() + " - " + itemRemessaFolhaCnab.getColaborador().getPessoa().getNome());
        }
        return dadosColaborador;
    }

    private static void buildTrailerPackage(File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)valorTotalFolha, (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.println();
        p.flush();
        p.close();
    }

    private static void buildTrailerFile(File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("237");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    private static ConfiguracaoCnab getConfiguracaoCnab(RemessaFolhaCnab remessaFolhaCnab) {
        for (ItemRemessaFolhaCnab it : remessaFolhaCnab.getItemRemessaFolhaCnab()) {
            if (it.getTitulo() == null || it.getTitulo().getConfiguracaoCnab() == null) continue;
            return it.getTitulo().getConfiguracaoCnab();
        }
        return null;
    }
}

