/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnab.hsbc;

import com.touchcomp.basementor.constants.ConstantsTipoConta;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RemessaFolhaCnab;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.DateUtil;

public class LayoutArquivoRemessaCnabHSBC {
    private static Integer numeroSequencial = 1;
    private static Double valorTotalFolha = 0.0;

    public static void gerarArquivoCnabFolhaHSBC(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException, ExceptionService {
        if (remessaFolhaCnab.getLayoutFolhaPagamento().getPosicoes().equals("240")) {
            LayoutArquivoRemessaCnabHSBC.gerarArquivoCnabFolhaHSBC240(remessaFolhaCnab, file);
        }
    }

    public static void gerarArquivoCnabFolhaHSBC240(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException, ExceptionService {
        File arquivo = new File(file, LayoutArquivoRemessaCnabHSBC.criarNomeArquivoFolhaHSBC() + ".txt");
        numeroSequencial = 1;
        valorTotalFolha = 0.0;
        if (!arquivo.exists()) {
            try {
                arquivo.createNewFile();
                LayoutArquivoRemessaCnabHSBC.escreverHeaderFolhaHSBC240(remessaFolhaCnab, arquivo);
                LayoutArquivoRemessaCnabHSBC.escreverHeaderLoteFolhaHSBC240(remessaFolhaCnab, arquivo);
                for (ItemRemessaFolhaCnab itemRemessa : remessaFolhaCnab.getItemRemessaFolhaCnab()) {
                    LayoutArquivoRemessaCnabHSBC.escreverDetailSegmentoAFolhaHSBC240(itemRemessa, arquivo);
                }
                LayoutArquivoRemessaCnabHSBC.escreverTrailerLoteFolhaHSBC240(remessaFolhaCnab, arquivo);
                LayoutArquivoRemessaCnabHSBC.escreverTrailerFolhaHSBC240(remessaFolhaCnab, arquivo);
            }
            catch (IOException ex) {
                arquivo.delete();
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        } else {
            arquivo.delete();
            throw new IOException("J\u00e1 existem um outro arquivo com mesmo nome na mesma pasta. Operacao cancelada.");
        }
    }

    private static String criarNomeArquivoFolhaHSBC() {
        Timestamp dataCompleta = DateUtil.toTimestamp(new Date());
        Integer day = DateUtil.dayFromDate(new Date());
        Integer mes = DateUtil.monthFromDate(new Date());
        Integer horas = dataCompleta.getHours();
        Integer minutos = dataCompleta.getMinutes();
        String nomeArquivo = "FP_" + String.valueOf(day.toString().length() == 1 ? "0" + day.toString() : day) + String.valueOf(mes.toString().length() == 1 ? "0" + mes.toString() : mes) + "_" + String.valueOf(horas.toString().length() == 1 ? "0" + horas.toString() : horas) + String.valueOf(minutos.toString().length() == 1 ? "0" + minutos.toString() : minutos);
        return nomeArquivo;
    }

    private static void escreverHeaderFolhaHSBC240(RemessaFolhaCnab remessaFolhaCnab, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(remessaFolhaCnab.getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append("0000");
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(LayoutArquivoRemessaCnabHSBC.getTipoInscricaoEmpresa(remessaFolhaCnab.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha() != null) {
            if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().length() > 20) {
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento Folha excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento Folha");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha(), 20));
        if (remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(" ");
        if (remessaFolhaCnab.getContaValor().getNrConta() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getNrConta(), 12));
        if (remessaFolhaCnab.getContaValor().getDvConta() != null) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta());
        }
        p.append(" ");
        String nomeEmpresa = remessaFolhaCnab.getEmpresa().getPessoa().getNome();
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa, 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30));
        }
        String nomeBanco = remessaFolhaCnab.getLayoutFolhaPagamento().getCnabFolhaAtivos().getNomeBanco();
        if (nomeBanco.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBanco, 30));
        } else {
            p.append(nomeBanco.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaFolhaCnab.getDataCadastro()));
        p.append(LayoutArquivoRemessaCnabHSBC.getHoraGeracao(remessaFolhaCnab.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getNumRegistroDiario().toString(), 6));
        p.append("020");
        p.append("01600");
        p.append("CPG");
        p.append("Y2K");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 49));
        p.println();
        p.flush();
        p.close();
    }

    public static String getTipoInscricaoEmpresa(Pessoa pessoa) {
        if (pessoa.getComplemento().getCnpj().length() == 14) {
            return "2";
        }
        if (pessoa.getComplemento().getCnpj().length() == 11) {
            return "1";
        }
        return "";
    }

    public static String getHoraGeracao(Timestamp dataEHora) {
        Timestamp horaCorrente = DateUtil.toTimestamp(new Date());
        Integer hora = horaCorrente.getHours();
        Integer minu = horaCorrente.getMinutes();
        Integer segu = horaCorrente.getSeconds();
        return (String)(hora.toString().length() == 1 ? "0" + hora.toString() : hora.toString()) + (String)(minu.toString().length() == 1 ? "0" + minu.toString() : minu.toString()) + (String)(segu.toString().length() == 1 ? "0" + segu.toString() : segu.toString());
    }

    private static void escreverHeaderLoteFolhaHSBC240(RemessaFolhaCnab remessaFolhaCnab, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(remessaFolhaCnab.getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append("0001");
        p.append("1");
        p.append("C");
        p.append("30");
        p.append("01");
        p.append("020");
        p.append(" ");
        p.append(LayoutArquivoRemessaCnabHSBC.getTipoInscricaoEmpresa(remessaFolhaCnab.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha() != null) {
            if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().length() > 20) {
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento Folha excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento Folha");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha(), 20));
        if (remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(" ");
        if (remessaFolhaCnab.getContaValor().getNrConta() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getNrConta(), 12));
        if (remessaFolhaCnab.getContaValor().getDvConta() != null) {
            p.append(remessaFolhaCnab.getContaValor().getDvConta());
        }
        p.append(" ");
        String nomeEmpresa = remessaFolhaCnab.getEmpresa().getPessoa().getNome();
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa, 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        String logradouro = remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getLogradouro();
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getNumero().length() > 5) {
            throw new IOException("Para este arquivo de remessa, n\u00famero do endere\u00e7o da ag\u00eancia n\u00e3o pode conter mais de 5 d\u00edgitos. Maior n\u00famero permitido: N\u00ba: 99999");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getNumero(), 5));
        String complemento = remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getComplemento();
        if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento, 15));
        } else {
            p.append(complemento.substring(0, 15));
        }
        String cidade = remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao();
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(LayoutArquivoRemessaCnabHSBC.getDadosCep(remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getCep(), 1));
        p.append(LayoutArquivoRemessaCnabHSBC.getDadosCep(remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getCep(), 2));
        p.append(remessaFolhaCnab.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append("N");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.println();
        p.flush();
        p.close();
    }

    public static String getDadosCep(String cep, Integer tipo) throws IOException {
        if (cep == null || cep.isEmpty()) {
            throw new IOException("No cadastro da Ag\u00eancia est\u00e1 faltando o CEP. Opera\u00e7\u00e3o cancelada.");
        }
        if (tipo.equals(1)) {
            return cep.substring(0, 5);
        }
        return cep.substring(5, 8);
    }

    private static void escreverDetailSegmentoAFolhaHSBC240(ItemRemessaFolhaCnab itemRemessa, File arquivo) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(itemRemessa.getRemessaFolhaCnab().getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append("0001");
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append("0");
        p.append("00");
        p.append("000");
        p.append(itemRemessa.getRemessaFolhaCnab().getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        HashMap dadosColaborador = UtilCnabFolha.getDadosColaborador(itemRemessa.getColaborador());
        if (dadosColaborador == null || dadosColaborador.isEmpty()) {
            arquivo.delete();
            throw new IOException("Existem Colaboradores sem Dados Bancarios. V\u00e1 at\u00e9 o Recurso Manuten\u00e7\u00e3o de Colaborador e atualize o cadastro dos colaboradores sem Dados Banc\u00e1rios. Opera\u00e7\u00e3o cancelada! Colaborador: " + itemRemessa.getColaborador().getIdentificador() + " - " + itemRemessa.getColaborador().getPessoa().getNome());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)dadosColaborador.get("AGENCIA_COL"), 5));
        p.append(" ");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)dadosColaborador.get("CONTA_COL"), 12));
        String digitoConta = ((String)dadosColaborador.get("DIG_CONTA_COL")).length() == 2 ? ((String)dadosColaborador.get("DIG_CONTA_COL")).substring(0, 1) : (String)dadosColaborador.get("DIG_CONTA_COL");
        p.append(digitoConta);
        p.append(" ");
        String nomeColaborador = itemRemessa.getColaborador().getPessoa().getNome();
        if (nomeColaborador.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeColaborador, 30));
        } else {
            p.append(nomeColaborador.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(itemRemessa.getIdentificador().toString(), 16));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(itemRemessa.getRemessaFolhaCnab().getDataDebitoContaEmpresa()));
        p.append("R$ ");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        valorTotalFolha = valorTotalFolha + itemRemessa.getValorPgto();
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)itemRemessa.getValorPgto(), (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 13));
        p.append("S");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        ContaSalarioColaborador contaSalarioColaborador = UtilityArquivoCnab.getContaBancariaAtivaAndPreferencialByPessoa(itemRemessa.getColaborador().getPessoa().getContaSalarioColaborador());
        if (contaSalarioColaborador == null) {
            throw new IOException("Nenhuma conta banc\u00e1ria ativa e prefer\u00eancial foi encontrada para pessoa " + itemRemessa.getColaborador().getPessoa().toString().toUpperCase());
        }
        if (ToolMethods.isEquals((Object)contaSalarioColaborador.getTipoConta(), (Object)ConstantsTipoConta.CONTA_CORRENTE) || ToolMethods.isEquals((Object)contaSalarioColaborador.getTipoConta(), (Object)ConstantsTipoConta.CONTA_SALARIO)) {
            p.append("CC");
        } else if (ToolMethods.isEquals((Object)contaSalarioColaborador.getTipoConta(), (Object)ConstantsTipoConta.CONTA_POUPANCA)) {
            p.append("PP");
        } else {
            throw new IOException("No cadastro dos dados banc\u00e1rios do colaborador/a: " + itemRemessa.getColaborador().getPessoa().getNome() + " est\u00e1 sem Tipo de Conta (Razao da Conta). \nV\u00e1 ao recurso 47 - Cadastro de Pessoas e corriga o cadastro.");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private static void escreverTrailerLoteFolhaHSBC240(RemessaFolhaCnab remessaFolhaCnab, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(remessaFolhaCnab.getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append("0001");
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)valorTotalFolha, (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 199));
        p.println();
        p.flush();
        p.close();
    }

    private static void escreverTrailerFolhaHSBC240(RemessaFolhaCnab remessaFolhaCnab, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(remessaFolhaCnab.getLayoutFolhaPagamento().getCnabFolhaAtivos().getNrBanco());
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append("000001");
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 211));
        p.println();
        p.flush();
        p.close();
    }
}

