/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnab.hsbc;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.LayoutFolhaPagamento;
import com.touchcomp.basementor.model.vo.OcorrRetCnabFolha;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorspringcontext.Context;
import contatocore.util.ContatoFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutArquivoRetornoCnabHSBC {
    public static HashMap getRetornoFolhaCnab(File arquivo, LayoutFolhaPagamento layoutFolhaPagamento, Short tipoTitulosFolha, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws FileNotFoundException, IOException, ExceptionService, Exception {
        if (layoutFolhaPagamento.getPosicoes().equals("240")) {
            return LayoutArquivoRetornoCnabHSBC.getRetornoFolhaCnabHSBC240(arquivo, layoutFolhaPagamento, tipoTitulosFolha, empresaFinanceiro, empresa, opGer);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap getRetornoFolhaCnabHSBC240(File arquivo, LayoutFolhaPagamento layoutFolhaPagamento, Short tipoTitulosFolha, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws FileNotFoundException, IOException, ExceptionService, Exception {
        ArrayList<ItemRemessaFolhaCnab> movimentosAceitos = new ArrayList<ItemRemessaFolhaCnab>();
        ArrayList<ItemRemessaFolhaCnab> movimentosNaoAceitos = new ArrayList<ItemRemessaFolhaCnab>();
        ArrayList<BaixaTitulo> baixas = new ArrayList<BaixaTitulo>();
        ArrayList<String> semMovimentosErro = new ArrayList<String>();
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        while (buffer.ready()) {
            String linha = buffer.readLine();
            if (linha.substring(7, 8).equals("0")) {
                String tipoArquivo = linha.substring(142, 143);
                if (!tipoArquivo.equals("1")) continue;
                semMovimentosErro.add("O arquivo selecionado n\u00e3o \u00e9 de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00e7\u00e3o cancelada!");
                map.put("SEM_MOVIMENTOS_ERRO", semMovimentosErro);
                return map;
            }
            if (!linha.substring(7, 8).equals("3") || !linha.substring(13, 14).equals("A")) continue;
            String idItemRemessa = linha.substring(73, 89);
            ItemRemessaFolhaCnab item = UtilCnabFolha.findItensRemessaFolhaByIdItemRemessa(idItemRemessa);
            if (item == null) {
                throw new ExceptionService("Nenhum item de remessa " + idItemRemessa);
            }
            ArrayList<OcorrRetCnabFolha> ocorrencias = new ArrayList<OcorrRetCnabFolha>();
            String codOcorrencia1 = linha.substring(230, 232);
            if (codOcorrencia1.trim().length() > 0) {
                OcorrRetCnabFolha ocorrencia1 = UtilCnabFolha.getOcorrenciaRetornoFolhaCnabByCodigoAndCnabFolhaAtivos(codOcorrencia1, layoutFolhaPagamento.getCnabFolhaAtivos());
                ocorrencias.add(ocorrencia1);
            }
            if (!ocorrencias.isEmpty() && ocorrencias.size() > 0) {
                item.getOcorrRetCnabFolha().addAll(ocorrencias);
                if (LayoutArquivoRetornoCnabHSBC.verificaAceitacaoItems(codOcorrencia1)) {
                    movimentosAceitos.add(item);
                    if (tipoTitulosFolha != null && tipoTitulosFolha.equals((short)2)) {
                        Titulo titulo = item.getTitulo();
                        Double saldoTitulo = UtilityArquivoCnab.findSaldoTitulo(titulo);
                        Double valorTitulo = ContatoFormatUtil.arrredondarNumero((Double)titulo.getValor(), (int)2);
                        if (!valorTitulo.equals(saldoTitulo)) throw new ExceptionService("O T\u00edtulo: " + titulo.getIdentificador().toString() + " j\u00e1 foi baixado no sistema ou o seu valor \u00e9 superior ao seu saldo!\nValor T\u00edtulo : " + titulo.getValor().toString() + "\nSaldo T\u00edtulo : " + saldoTitulo.toString());
                        System.out.println("\n\n\nColaborador: " + item.getColaborador().getPessoa().getNome() + " Item: " + item.getIdentificador() + "\n\n\n");
                        BaixaTitulo baixa = new BaixaTitulo();
                        baixa.setTitulo(titulo);
                        baixa.setValor(titulo.getValor());
                        baixa.setSaldoBaixa(titulo.getValor());
                        helper.build(baixa).createAndSetContasBaixa(titulo, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO, empresa, opGer);
                        baixas.add(baixa);
                    }
                } else {
                    movimentosNaoAceitos.add(item);
                }
            } else {
                movimentosNaoAceitos.add(item);
            }
            CoreBdUtil.getInstance().getSession().evict((Object)item);
        }
        map.put("BAIXAS", baixas);
        map.put("MOVIMENTOS_ACEITOS", movimentosAceitos);
        map.put("MOVIMENTOS_NAO_ACEITOS", movimentosNaoAceitos);
        return map;
    }

    private static boolean verificaAceitacaoItems(String codOcorrencia) {
        return codOcorrencia.equals("00") || codOcorrencia.equals("BD");
    }
}

