/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnab.sicoob;

import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.RemessaFolhaCnab;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import mentorcore.service.impl.financeiro.cnabfolha.UtilCnabFolha;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutArquivoRemessaCnabSicoob {
    private static Double valorTotalFolha = 0.0;
    private static Integer numeroSequencial = 0;

    public static void gerarArquivoCnabFolhaSicoob(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException {
        if (remessaFolhaCnab.getLayoutFolhaPagamento().getPosicoes().equals("200")) {
            LayoutArquivoRemessaCnabSicoob.gerarArquivoCnabFolhaSicoob200(remessaFolhaCnab, file);
        }
    }

    private static void gerarArquivoCnabFolhaSicoob200(RemessaFolhaCnab remessaFolhaCnab, File file) throws IOException {
        File arquivo = new File(file, "Complemento.TXT");
        numeroSequencial = 0;
        valorTotalFolha = 0.0;
        try {
            if (!arquivo.exists()) {
                arquivo.createNewFile();
                LayoutArquivoRemessaCnabSicoob.escreverHeaderFolhaSicoob200(arquivo, remessaFolhaCnab);
                for (ItemRemessaFolhaCnab item : remessaFolhaCnab.getItemRemessaFolhaCnab()) {
                    if (item.getRetornoFolhaCnab() != null) continue;
                    LayoutArquivoRemessaCnabSicoob.escreverDetalheFolhaSicoob200(arquivo, item);
                }
            } else {
                throw new IOException("J\u00e1 existem um outro arquivo com mesmo nome na mesma pasta. Operacao cancelada.");
            }
            LayoutArquivoRemessaCnabSicoob.escreverTrailerFolhaBradesco200(arquivo);
        }
        catch (IOException ex) {
            arquivo.delete();
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private static void escreverHeaderFolhaSicoob200(File arquivo, RemessaFolhaCnab remessaFolhaCnab) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("0");
        p.append("1");
        p.append("756");
        if (remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getAgenciaValor().getNrAgencia(), 4));
        if (remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha() == null || remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().isEmpty() || remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha().length() > 7) {
            arquivo.delete();
            throw new IOException("No cadastro da Conta Banc\u00e1ria da Empresa est\u00e1 faltando o n\u00famero do conv\u00eanio. Tal n\u00famero \u00e9 obrigat\u00f3rio para gera\u00e7\u00e3o da Remessa da Folha de Pagamento. Esse n\u00famero \u00e9 o Banco que informa para o Cliente. V\u00e1 at\u00e9 o Recurso Ag\u00eancia de Valores e adicione este n\u00famero na Conta Banc\u00e1ria utilizada pela Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaFolhaCnab.getContaValor().getNumeroConvenioPagamentoFolha(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("99");
        p.append("03");
        p.append(UtilityArquivoCnab.formatarDatas8DigitosFormatyyyyMMdd(remessaFolhaCnab.getDataDebitoContaEmpresa()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 162));
        p.println();
        p.flush();
        p.close();
    }

    private static void escreverDetalheFolhaSicoob200(File arquivo, ItemRemessaFolhaCnab itemRemessaFolhaCnab) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        HashMap dadosColaborador = UtilCnabFolha.getDadosColaborador(itemRemessaFolhaCnab.getColaborador());
        if (dadosColaborador == null || dadosColaborador.isEmpty()) {
            arquivo.delete();
            throw new IOException("Existem Colaboradores sem Dados Bancarios. V\u00e1 at\u00e9 o Recurso Manuten\u00e7\u00e3o de Colaborador e atualize o cadastro dos colaboradores sem Dados Banc\u00e1rios. Opera\u00e7\u00e3o cancelada! Colaborador: " + itemRemessaFolhaCnab.getColaborador().getIdentificador() + " - " + itemRemessaFolhaCnab.getColaborador().getPessoa().getNome());
        }
        p.append("1");
        p.append("C");
        String contaColaborador = (String)dadosColaborador.get("CONTA_COL") + (String)dadosColaborador.get("DIG_CONTA_COL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaColaborador, 10));
        String nomeColaborador = itemRemessaFolhaCnab.getColaborador().getPessoa().getNome();
        if (nomeColaborador.length() <= 40) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeColaborador, 40));
        } else {
            p.append(nomeColaborador.substring(0, 40));
        }
        String cpfCgcColaborador = itemRemessaFolhaCnab.getColaborador().getPessoa().getComplemento().getCnpj();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(cpfCgcColaborador, 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append("000");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(itemRemessaFolhaCnab.getIdentificador().toString(), 10));
        valorTotalFolha = valorTotalFolha + itemRemessaFolhaCnab.getValorPgto();
        String valorSalarioLiquido = ContatoFormatUtil.formataNumero((Number)itemRemessaFolhaCnab.getValorPgto(), (int)2);
        valorSalarioLiquido = ToolString.refina((String)valorSalarioLiquido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorSalarioLiquido, 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 72));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private static void escreverTrailerFolhaBradesco200(File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("9");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        String valorTotalFolhaString = ContatoFormatUtil.formataNumero((Number)valorTotalFolha, (int)2);
        valorTotalFolhaString = ToolString.refina((String)valorTotalFolhaString);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalFolhaString, 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 155));
        p.println();
        p.flush();
        p.close();
    }
}

