/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabfolha;

import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import net.sf.jasperreports.engine.JasperPrint;

public class ImpressaoComprovantePgtoFolha {
    public static JasperPrint getImpressaoComprovantePgtoBradesco240(File arquivo) throws FileNotFoundException, IOException, ExceptionService {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList impressoes = new ArrayList();
        String empresaPagadora = "";
        Object cnpj = "";
        while (buffer.ready()) {
            String linha = buffer.readLine();
            if (linha.substring(7, 8).equals("1")) {
                cnpj = linha.substring(18, 20) + "." + linha.substring(20, 23) + "." + linha.substring(23, 26) + "/" + linha.substring(26, 30) + "-" + linha.substring(30, 32);
                empresaPagadora = linha.substring(72, 102);
                continue;
            }
            if (!linha.substring(7, 8).equals("3") || !linha.substring(13, 14).equals("A") || !ImpressaoComprovantePgtoFolha.verificaAceitacaoLote(linha.substring(230, 232))) continue;
            HashMap<String, Object> dadosImpressao = new HashMap<String, Object>();
            String dataEmissao = DateUtil.dateToStr(new Date());
            String nomeFavorecido = linha.substring(43, 73);
            String banco = linha.substring(20, 23);
            String valor = linha.substring(119, 134);
            String numComprovante = linha.substring(134, 154);
            String agencia = linha.substring(23, 28) + " - " + linha.substring(28, 29);
            String dataCredito = linha.substring(154, 156) + "/" + linha.substring(156, 158) + "/" + linha.substring(158, 162);
            Object conta = linha.substring(29, 41);
            conta = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda((String)conta);
            conta = (String)conta + "-" + linha.substring(41, 42);
            if (ToolString.stringIsANumber((String)valor).booleanValue()) {
                String valorInteiro = linha.substring(119, 132);
                String valorVirgula = linha.substring(132, 134);
                String valorCorreto = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda(valorInteiro) + "," + valorVirgula;
                dadosImpressao.put("valor", valorCorreto);
            }
            linha = buffer.readLine();
            String cpf = linha.substring(21, 24) + "." + linha.substring(24, 27) + "." + linha.substring(27, 30) + "-" + linha.substring(30, 32);
            dadosImpressao.put("cpf", cpf);
            dadosImpressao.put("dataEmissao", dataEmissao);
            dadosImpressao.put("nomeFavorecido", nomeFavorecido);
            dadosImpressao.put("banco", banco);
            dadosImpressao.put("numComprovante", numComprovante);
            dadosImpressao.put("agencia", agencia);
            dadosImpressao.put("dataCredito", dataCredito);
            dadosImpressao.put("conta", conta);
            dadosImpressao.put("empresaPagadora", empresaPagadora);
            dadosImpressao.put("cnpj", cnpj);
            impressoes.add(dadosImpressao);
        }
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "financas" + File.separator + "cnab" + File.separator + "folha" + File.separator + "COMPROVANTE_PAGTO_BRADESCO_240.jasper";
        return ImpressaoComprovantePgtoFolha.geracaoComprovante(impressoes, (String)path);
    }

    private static String getNumerosSemZerosAEsquerda(String numero) {
        int i = 0;
        char caractere = numero.charAt(i);
        while (caractere == '0') {
            caractere = numero.charAt(++i);
        }
        String numeroCorreta = numero.substring(i, numero.length());
        return numeroCorreta;
    }

    public static JasperPrint getImpressaoComprovantePgtoBB(File arquivo, HashMap parametros) throws FileNotFoundException, IOException, ExceptionService {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList impressoes = new ArrayList();
        String empresaPagadora = "";
        Object cnpj = "";
        String nomeBanco = "";
        while (buffer.ready()) {
            String linha = buffer.readLine();
            if (linha.substring(7, 8).equals("0")) {
                nomeBanco = linha.substring(102, 132);
                continue;
            }
            if (linha.substring(7, 8).equals("1")) {
                cnpj = linha.substring(18, 20) + "." + linha.substring(20, 23) + "." + linha.substring(23, 26) + "/" + linha.substring(26, 30) + "-" + linha.substring(30, 32);
                empresaPagadora = linha.substring(72, 102);
                continue;
            }
            if (!linha.substring(7, 8).equals("3") || !linha.substring(13, 14).equals("A") || !ImpressaoComprovantePgtoFolha.verificaAceitacaoLote(linha.substring(230, 232))) continue;
            HashMap<String, Object> dadosImpressao = new HashMap<String, Object>();
            String dataEmissao = DateUtil.dateToStr(new Date());
            String nomeFavorecido = linha.substring(43, 73);
            String banco = linha.substring(20, 23);
            String valor = linha.substring(119, 134);
            String numComprovante = linha.substring(134, 154);
            String agencia = linha.substring(23, 28) + " - " + linha.substring(28, 29);
            String dataCredito = linha.substring(154, 156) + "/" + linha.substring(156, 158) + "/" + linha.substring(158, 162);
            Object conta = linha.substring(29, 41);
            conta = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda((String)conta);
            conta = (String)conta + "-" + linha.substring(41, 42);
            if (ToolString.stringIsANumber((String)valor).booleanValue()) {
                String valorInteiro = linha.substring(119, 132);
                String valorVirgula = linha.substring(132, 134);
                String valorCorreto = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda(valorInteiro) + "," + valorVirgula;
                dadosImpressao.put("valor", valorCorreto);
            }
            linha = buffer.readLine();
            String cpf = linha.substring(21, 24) + "." + linha.substring(24, 27) + "." + linha.substring(27, 30) + "-" + linha.substring(30, 32);
            dadosImpressao.put("cpf", cpf);
            dadosImpressao.put("dataEmissao", dataEmissao);
            dadosImpressao.put("nomeFavorecido", nomeFavorecido);
            dadosImpressao.put("banco", banco);
            dadosImpressao.put("numComprovante", numComprovante);
            dadosImpressao.put("agencia", agencia);
            dadosImpressao.put("dataCredito", dataCredito);
            dadosImpressao.put("conta", conta);
            dadosImpressao.put("empresaPagadora", empresaPagadora);
            dadosImpressao.put("cnpj", cnpj);
            dadosImpressao.put("nomeBanco", nomeBanco);
            impressoes.add(dadosImpressao);
        }
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "financas" + File.separator + "cnab" + File.separator + "folha" + File.separator + "COMPROVANTE_PAGTO_BB_240.jasper";
        return ImpressaoComprovantePgtoFolha.geracaoComprovante(impressoes, (String)path);
    }

    private static boolean verificaAceitacaoLote(String codOcorrencia) {
        return codOcorrencia.equals("00") || codOcorrencia.equals("03") || codOcorrencia.equals("BD") || codOcorrencia.equals("BE") || codOcorrencia.equals("BF") || codOcorrencia.equals("ZA");
    }

    public static JasperPrint getImpressaoComprovantePgtoHSBC(File arquivo, HashMap parametros) throws FileNotFoundException, IOException, ExceptionService {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList impressoes = new ArrayList();
        String empresaPagadora = "";
        Object cnpj = "";
        String nomeBanco = "";
        while (buffer.ready()) {
            String linha = buffer.readLine();
            if (linha.substring(7, 8).equals("0")) {
                nomeBanco = linha.substring(102, 132);
                continue;
            }
            if (linha.substring(7, 8).equals("1")) {
                cnpj = linha.substring(18, 20) + "." + linha.substring(20, 23) + "." + linha.substring(23, 26) + "/" + linha.substring(26, 30) + "-" + linha.substring(30, 32);
                empresaPagadora = linha.substring(72, 102);
                continue;
            }
            if (!linha.substring(7, 8).equals("3") || !linha.substring(13, 14).equals("A") || !ImpressaoComprovantePgtoFolha.verificaAceitacaoLote(linha.substring(230, 232))) continue;
            HashMap<String, Object> dadosImpressao = new HashMap<String, Object>();
            String dataEmissao = DateUtil.dateToStr(new Date());
            String nomeFavorecido = linha.substring(43, 73);
            String banco = linha.substring(20, 23);
            String valor = linha.substring(121, 134);
            String numComprovante = linha.substring(73, 89);
            String agencia = linha.substring(23, 28) + " - " + linha.substring(28, 29);
            String dataCredito = linha.substring(93, 95) + "/" + linha.substring(95, 97) + "/" + linha.substring(97, 101);
            Object conta = linha.substring(29, 41);
            conta = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda((String)conta);
            conta = (String)conta + "-" + linha.substring(41, 42);
            if (ToolString.stringIsANumber((String)valor).booleanValue()) {
                String valorInteiro = linha.substring(121, 132);
                String valorVirgula = linha.substring(132, 134);
                String valorCorreto = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda(valorInteiro) + "," + valorVirgula;
                dadosImpressao.put("valor", valorCorreto);
            }
            linha = buffer.readLine();
            String cpf = linha.substring(21, 24) + "." + linha.substring(24, 27) + "." + linha.substring(27, 30) + "-" + linha.substring(30, 32);
            dadosImpressao.put("cpf", cpf);
            dadosImpressao.put("dataEmissao", dataEmissao);
            dadosImpressao.put("nomeFavorecido", nomeFavorecido);
            dadosImpressao.put("banco", banco);
            dadosImpressao.put("numComprovante", numComprovante);
            dadosImpressao.put("agencia", agencia);
            dadosImpressao.put("dataCredito", dataCredito);
            dadosImpressao.put("conta", conta);
            dadosImpressao.put("empresaPagadora", empresaPagadora);
            dadosImpressao.put("cnpj", cnpj);
            dadosImpressao.put("nomeBanco", nomeBanco);
            impressoes.add(dadosImpressao);
        }
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "financas" + File.separator + "cnab" + File.separator + "folha" + File.separator + "COMPROVANTE_PAGTO_HSBC_240.jasper";
        return ImpressaoComprovantePgtoFolha.geracaoComprovante(impressoes, (String)path);
    }

    public static JasperPrint getImpressaoComprovantePgtoCaixa(File arquivo, HashMap parametros) throws FileNotFoundException, IOException, ExceptionService {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList impressoes = new ArrayList();
        String empresaPagadora = "";
        Object cnpj = "";
        while (buffer.ready()) {
            String linha = buffer.readLine();
            if (linha.substring(7, 8).equals("1")) {
                cnpj = linha.substring(18, 20) + "." + linha.substring(20, 23) + "." + linha.substring(23, 26) + "/" + linha.substring(26, 30) + "-" + linha.substring(30, 32);
                empresaPagadora = linha.substring(72, 102);
                continue;
            }
            if (!linha.substring(7, 8).equals("3") || !linha.substring(13, 14).equals("A") || !ImpressaoComprovantePgtoFolha.verificaAceitacaoLote(linha.substring(230, 232))) continue;
            HashMap<String, Object> dadosImpressao = new HashMap<String, Object>();
            String dataEmissao = DateUtil.dateToStr(new Date());
            String nomeFavorecido = linha.substring(43, 73);
            String banco = linha.substring(20, 23);
            String valor = linha.substring(119, 134);
            String numComprovante = linha.substring(134, 143);
            String agencia = linha.substring(23, 28) + " - " + linha.substring(28, 29);
            String dataCredito = linha.substring(154, 156) + "/" + linha.substring(156, 158) + "/" + linha.substring(158, 162);
            Object conta = linha.substring(29, 41);
            conta = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda((String)conta);
            conta = (String)conta + "-" + linha.substring(41, 42);
            if (ToolString.stringIsANumber((String)valor).booleanValue()) {
                String valorInteiro = linha.substring(119, 132);
                String valorVirgula = linha.substring(132, 134);
                String valorCorreto = ImpressaoComprovantePgtoFolha.getNumerosSemZerosAEsquerda(valorInteiro) + "," + valorVirgula;
                dadosImpressao.put("valor", valorCorreto);
            }
            linha = buffer.readLine();
            String cpf = linha.substring(21, 24) + "." + linha.substring(24, 27) + "." + linha.substring(27, 30) + "-" + linha.substring(30, 32);
            dadosImpressao.put("cpf", cpf);
            dadosImpressao.put("dataEmissao", dataEmissao);
            dadosImpressao.put("nomeFavorecido", nomeFavorecido);
            dadosImpressao.put("banco", banco);
            dadosImpressao.put("numComprovante", numComprovante);
            dadosImpressao.put("agencia", agencia);
            dadosImpressao.put("dataCredito", dataCredito);
            dadosImpressao.put("conta", conta);
            dadosImpressao.put("empresaPagadora", empresaPagadora);
            dadosImpressao.put("cnpj", cnpj);
            impressoes.add(dadosImpressao);
        }
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "financas" + File.separator + "cnab" + File.separator + "folha" + File.separator + "COMPROVANTE_PAGTO_CAIXA_240.jasper";
        return ImpressaoComprovantePgtoFolha.geracaoComprovante(impressoes, (String)path);
    }

    private static JasperPrint geracaoComprovante(List impressoes, String path) throws ExceptionService {
        Object image = System.getProperty("user.dir");
        image = (String)image + File.separator + "reports" + File.separator + "financas" + File.separator + "cnab" + File.separator + "folha" + File.separator;
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("PATH_IMAGE", image);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", impressoes);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return (JasperPrint)jasperPrint;
    }
}

