/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabfolha;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstCnabPagamento;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CalculoInssAberturaPeriodo;
import com.touchcomp.basementor.model.vo.CnabFolhaAtivos;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OcorrRetCnabFolha;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RemessaFolhaFechamentoPeriodo;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilCnabFolha {
    public static HashMap getDadosColaborador(Colaborador colaborador) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                                   c.agencia                      as AGENCIA_COL,         c.dvAgencia                    as DIG_AGENCIA_COL,     c.operacao                     as TIPO_CONTA,          c.contaCorrente\t\t   as CONTA_COL,           c.dvContaCorrente\t\t   as DIG_CONTA_COL        from ContaSalarioColaborador c                         inner join c.instituicaoValor i where                                                      c.pessoa = :pessoa                                 and c.ativo        = :sim                               and c.preferencial = :sim and i.nrBanco <> '999'";
        Query q = s.createQuery(query);
        q.setEntity("pessoa", (Object)colaborador.getPessoa());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    public static ContaSalarioColaborador getDadosPessoa(Pessoa pessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select c                                          from ContaSalarioColaborador c                         where                                                      c.pessoa = :pessoa                                 and c.ativo  = :ativo                         ";
        Query q = s.createQuery(query);
        q.setEntity("pessoa", (Object)pessoa);
        q.setShort("ativo", (short)1);
        return (ContaSalarioColaborador)q.uniqueResult();
    }

    public static HashMap getDadosBancariosPessoa(Pessoa pessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                                  c.agencia                 as AGENCIA_COL,            c.dvAgencia               as DIG_AGENCIA_COL,        c.operacao                as TIPO_CONTA,             c.contaCorrente           as CONTA_COL,              c.dvContaCorrente         as DIG_CONTA_COL        from         Colaborador cc                          inner join cc.pessoa pes\n                           inner join pes.contaSalarioColaborador c             where                                                   pes = :pessoa                                        and c.ativo          = 1                             and (cc.tipoPagamento = :viaBanco)               ";
        Query q = s.createQuery(query);
        q.setEntity("pessoa", (Object)pessoa);
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        return (HashMap)q.uniqueResult();
    }

    public static List<ItemRemessaFolhaCnab> getItensRemessaFolhaCnab(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos, Short tipoTituloFolha, Short tipoRemessaFolha, Short buscarRejeitados, List<ItemRemessaFolhaCnab> listRemessaFolhaCnab, List<RemessaFolhaFechamentoPeriodo> fechamentos) {
        if (tipoTituloFolha != null && tipoTituloFolha.equals((short)3)) {
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensMovimentoFolha(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensFeriasColaborador(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItens13Salario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensRecisao(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensAdiantamentoSalario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensAdiantamento13Salario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
            if (buscarRejeitados.equals((short)1)) {
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensRejeitadosAnteriormente(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos, tipoTituloFolha, tipoRemessaFolha));
            }
        } else if (tipoTituloFolha != null && tipoTituloFolha.equals((short)2)) {
            if (tipoRemessaFolha != null && tipoRemessaFolha.equals((short)0)) {
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensMovimentoFolha(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItens13Salario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensAdiantamentoSalario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensAdiantamento13Salario(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                if (buscarRejeitados.equals((short)1)) {
                    listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensRejeitadosAnteriormente(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos, tipoTituloFolha, tipoRemessaFolha));
                }
                listRemessaFolhaCnab = UtilCnabFolha.validarFolhaPorFechamento(listRemessaFolhaCnab, fechamentos);
            } else if (tipoRemessaFolha != null && tipoRemessaFolha.equals((short)1)) {
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensRecisao(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensFeriasColaborador(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos));
                if (buscarRejeitados.equals((short)1)) {
                    listRemessaFolhaCnab.addAll(UtilCnabFolha.getItensRejeitadosAnteriormente(dataPgtoInicial, dataPgtoFinal, cnabFolhaAtivos, tipoTituloFolha, tipoRemessaFolha));
                }
            }
        }
        return listRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItensMovimentoFolha(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                           m                               as principal  ,  m.colaborador                   as colaborador,  m.aberturaPeriodo.dataPagamento as dataPgto   ,  m.vrSalarioLiquido              as valorPgto  ,  0                               as tipoEvento    from MovimentoFolha m  join m.colaborador c  join c.pessoa p  join p.contaSalarioColaborador conta  where (m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento or m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaComplementar) and m.aberturaPeriodo.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and conta.instituicaoValor.nrBanco = :nrBanco  and c.tipoPagamento = :viaBanco  and conta.ativo = :sim  and m.vrSalarioLiquido > 0  and not exists (select item.movimentoFolha                  from ItemRemessaFolhaCnab item                  where item.movimentoFolha = m  )  order by m.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("sim", (short)1);
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue());
        q.setShort("folhaComplementar", EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List movFolha = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(movFolha, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItensFeriasColaborador(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                               f                                   as principal  ,  f.periodoAqFeriasColab.colaborador  as colaborador,  f.dataPagamento                     as dataPgto   ,  f.vrLiquidoFerias+f.vlrLiquidoAddDec as valorPgto  ,  1                                   as tipoEvento    from FeriasColaborador f  join f.periodoAqFeriasColab periodo join periodo.colaborador colab join colab.pessoa ps join ps.contaSalarioColaborador conta where f.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and f.vrLiquidoFerias > 0  and conta.instituicaoValor.nrBanco = :nrBanco  and colab.tipoPagamento = :viaBanco  and conta.ativo = 1  and f not in (select item.feriasColaborador                from ItemRemessaFolhaCnab item)  order by periodo.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List feriasColaborador = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(feriasColaborador, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItens13Salario(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                           m                               as principal  ,  m.colaborador                   as colaborador,  m.aberturaPeriodo.dataPagamento as dataPgto   ,  m.vrSalarioLiquido              as valorPgto  ,  2                               as tipoEvento    from MovimentoFolha m  join m.colaborador colab  join colab.pessoa ps  join ps.contaSalarioColaborador conta  where m.aberturaPeriodo.tipoCalculo.tipoFolha = 2  and m.aberturaPeriodo.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and conta.instituicaoValor.nrBanco = :nrBanco  and colab.tipoPagamento = :viaBanco  and conta.ativo = :sim  and m.vrSalarioLiquido > 0  and not exists (select item.salario13oColaborador                from ItemRemessaFolhaCnab item                where item.salario13oColaborador = m)  order by m.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List decTercColaborador = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(decTercColaborador, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItensRecisao(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select  r               as principal  ,  r.colaborador   as colaborador,  r.dataPagamento as dataPgto   ,  r.vlrLiquido    as valorPgto  ,  3               as tipoEvento    from Recisao r                  join r.colaborador colab  join colab.pessoa ps  join ps.contaSalarioColaborador conta  where r.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and conta.instituicaoValor.nrBanco = :nrBanco  and colab.tipoPagamento = :viaBanco  and conta.ativo = 1  and r.vlrLiquido > 0  and r not in (select item.recisao                from ItemRemessaFolhaCnab item)  order by r.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List recisoes = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(recisoes, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItensAdiantamentoSalario(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                           m                               as principal  ,  m.colaborador                   as colaborador,  m.aberturaPeriodo.dataPagamento as dataPgto   ,  m.vrSalarioLiquido              as valorPgto  ,  4                               as tipoEvento    from MovimentoFolha m  join m.colaborador colab  join colab.pessoa ps  join ps.contaSalarioColaborador conta where m.aberturaPeriodo.tipoCalculo.tipoFolha = 4  and m.aberturaPeriodo.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and colab.tipoPagamento = :viaBanco  and conta.instituicaoValor.nrBanco = :nrBanco  and conta.ativo = :sim  and m.vrSalarioLiquido > 0  and not exists  (select item.adiantamentoSalario                   from ItemRemessaFolhaCnab item                   where item.adiantamentoSalario = m)  order by m.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("sim", (short)1);
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List movFolha = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(movFolha, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> getItensRejeitadosAnteriormente(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos, Short tipoTituloFolha, Short tipoRemessaFolha) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = " select itemFolha                                                      from ItemRemessaFolhaCnab itemFolha                                   join itemFolha.colaborador colab                                      join colab.pessoa ps                                                  join ps.contaSalarioColaborador conta                                 where itemFolha.dataPgto between :dataPgtoInicial and :dataPgtoFinal  and itemFolha.retornoFolhaCnab is null                                and conta.instituicaoValor.nrBanco = :nrBanco                         and colab.tipoPagamento = :viaBanco  and conta.ativo = :sim                                                  ";
        if (tipoTituloFolha != null && tipoTituloFolha.equals((short)2)) {
            if (tipoRemessaFolha != null && tipoRemessaFolha.equals((short)0)) {
                query = (String)query + " and (itemFolha.adiantamentoSalario   is not null or      itemFolha.movimentoFolha        is not null or      itemFolha.adiantamento13Salario is not null or      itemFolha.salario13oColaborador is not null)   ";
            } else if (tipoRemessaFolha != null && tipoRemessaFolha.equals((short)1)) {
                query = (String)query + " and (itemFolha.feriasColaborador     is not null or      itemFolha.recisao               is not null)   ";
            }
        }
        query = (String)query + " order by itemFolha.colaborador.pessoa.nome ";
        Query q = s.createQuery((String)query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("sim", (short)1);
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        return q.list();
    }

    private static List<ItemRemessaFolhaCnab> getItensAdiantamento13Salario(Date dataPgtoInicial, Date dataPgtoFinal, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select                                            m                               as principal  ,   m.colaborador                   as colaborador,   m.aberturaPeriodo.dataPagamento as dataPgto   ,   m.vrSalarioLiquido              as valorPgto  ,   5                               as tipoEvento     from MovimentoFolha m                             join m.colaborador colab  join colab.pessoa ps  join ps.contaSalarioColaborador conta  where m.aberturaPeriodo.tipoCalculo.tipoFolha = 5 and m.aberturaPeriodo.dataPagamento between :dataPgtoInicial and :dataPgtoFinal  and m.vrSalarioLiquido > 0  and colab.tipoPagamento = :viaBanco  and conta.instituicaoValor.nrBanco = :nrBanco  and conta.ativo = :sim  and not exists (select item.adiantamento13Salario                 from ItemRemessaFolhaCnab item                 where item.adiantamento13Salario = m)  order by m.colaborador.pessoa.nome ";
        Query q = s.createQuery(query);
        q.setDate("dataPgtoInicial", dataPgtoInicial);
        q.setDate("dataPgtoFinal", dataPgtoFinal);
        q.setString("nrBanco", cnabFolhaAtivos.getNrBanco());
        q.setShort("sim", (short)1);
        q.setShort("viaBanco", EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId().shortValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List decTercColaborador = q.list();
        List<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = UtilCnabFolha.createItensRemessaFolhaCnab(decTercColaborador, cnabFolhaAtivos);
        return itensRemessaFolhaCnab;
    }

    private static List<ItemRemessaFolhaCnab> createItensRemessaFolhaCnab(List objects, CnabFolhaAtivos CnabFolhaAtivos2) {
        ArrayList<ItemRemessaFolhaCnab> itensRemessaFolhaCnab = new ArrayList<ItemRemessaFolhaCnab>();
        for (Object o : objects) {
            HashMap map = (HashMap)o;
            if (map == null || map.get("colaborador") == null || map.get("dataPgto") == null || map.get("valorPgto") == null || map.get("principal") == null) continue;
            ItemRemessaFolhaCnab item = new ItemRemessaFolhaCnab();
            item.setColaborador((Colaborador)map.get("colaborador"));
            item.setDataPgto((Date)map.get("dataPgto"));
            item.setTipoEvento(Short.valueOf(((Integer)map.get("tipoEvento")).shortValue()));
            item.setValorPgto((Double)map.get("valorPgto"));
            if (map.get("principal") instanceof MovimentoFolha) {
                if (map.get("tipoEvento").equals(0)) {
                    item.setMovimentoFolha((MovimentoFolha)map.get("principal"));
                } else if (map.get("tipoEvento").equals(4)) {
                    item.setAdiantamentoSalario((MovimentoFolha)map.get("principal"));
                } else if (map.get("tipoEvento").equals(2)) {
                    item.setSalario13oColaborador((MovimentoFolha)map.get("principal"));
                } else if (map.get("tipoEvento").equals(5)) {
                    item.setAdiantamento13Salario((MovimentoFolha)map.get("principal"));
                }
            } else if (map.get("principal") instanceof FeriasColaborador) {
                item.setFeriasColaborador((FeriasColaborador)map.get("principal"));
            } else if (map.get("principal") instanceof Recisao) {
                item.setRecisao((Recisao)map.get("principal"));
            }
            ArrayList<OcorrRetCnabFolha> ocorrencias = new ArrayList<OcorrRetCnabFolha>();
            OcorrRetCnabFolha ocorrencia = UtilCnabFolha.getOcorrenciaRetornoFolhaCnabByCodigoAndCnabFolhaAtivos("S3", CnabFolhaAtivos2);
            ocorrencias.add(ocorrencia);
            item.getOcorrRetCnabFolha().addAll(ocorrencias);
            itensRemessaFolhaCnab.add(item);
        }
        return itensRemessaFolhaCnab;
    }

    public static OcorrRetCnabFolha getOcorrenciaRetornoFolhaCnabByCodigoAndCnabFolhaAtivos(String codOcorrencia, CnabFolhaAtivos cnabFolhaAtivos) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(OcorrRetCnabFolha.class);
        c.add((Criterion)Restrictions.eq((String)"codigo", (Object)codOcorrencia));
        c.add((Criterion)Restrictions.eq((String)"cnabFolhaAtivos", (Object)cnabFolhaAtivos));
        return c.list() != null && !c.list().isEmpty() ? (OcorrRetCnabFolha)c.list().get(0) : null;
    }

    public static ItemRemessaFolhaCnab findItensRemessaFolhaByIdItemRemessa(String idItemRemessa) throws ExceptionService {
        if (ToolString.stringIsANumber((String)(idItemRemessa = idItemRemessa.trim())).booleanValue()) {
            Long idItemRemessaFolhaCnab = Long.valueOf(idItemRemessa);
            return (ItemRemessaFolhaCnab)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOItemRemessaFolhaCnab(), idItemRemessaFolhaCnab);
        }
        return null;
    }

    public static void deleteTituloFromItemRemessaFolhaCnab(Long idTitulo) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery query_0 = s.createSQLQuery("UPDATE ITEM_REMESSA_FOLHA_CNAB I SET I.ID_TITULO = NULL WHERE I.ID_TITULO = :idTitulo ");
        query_0.setLong("idTitulo", idTitulo.longValue());
        query_0.executeUpdate();
        NativeQuery query_1 = s.createSQLQuery(" SELECT TLCG.ID_LANCAMENTO_CTB_GERENCIAL  FROM TITULO_LANC_CTB_GERENCIAL TLCG  WHERE TLCG.ID_TITULO = :idTitulo");
        query_1.setLong("idTitulo", idTitulo.longValue());
        Integer idLancCtbGerencial = (Integer)query_1.uniqueResult();
        NativeQuery query_2 = s.createSQLQuery("DELETE FROM TITULO_LANC_CTB_GERENCIAL TLCG WHERE TLCG.ID_TITULO = :idTitulo");
        query_2.setLong("idTitulo", idTitulo.longValue());
        query_2.executeUpdate();
        NativeQuery query_3 = s.createSQLQuery("DELETE FROM LANCAMENTO_CTB_GERENCIAL LCG WHERE LCG.ID_LANCAMENTO_CTB_GERENCIAL = :idLancCtbGerencial");
        query_3.setInteger("idLancCtbGerencial", idLancCtbGerencial.intValue());
        query_3.executeUpdate();
        NativeQuery query_4 = s.createSQLQuery("DELETE FROM TITULO T WHERE T.ID_TITULO = :idTitulo");
        query_4.setLong("idTitulo", idTitulo.longValue());
        query_4.executeUpdate();
    }

    public static void deleteItemRemessaFolhaCnab(Long idItemRemessaFolhaCnab) {
        Session s = CoreBdUtil.getInstance().getSession();
        NativeQuery query_0 = s.createSQLQuery("DELETE FROM ITEM_REMES_FOLHA_OCORR_RET O where O.ID_ITEM_REMESSA_FOLHA_CNAB = :idItemRemessaFolhaCnab ");
        query_0.setLong("idItemRemessaFolhaCnab", idItemRemessaFolhaCnab.longValue());
        query_0.executeUpdate();
        NativeQuery query_1 = s.createSQLQuery("DELETE FROM ITEM_REMESSA_FOLHA_CNAB ITEM WHERE ITEM.ID_ITEM_REMESSA_FOLHA_CNAB = :idItemRemessaFolhaCnab ");
        query_1.setLong("idItemRemessaFolhaCnab", idItemRemessaFolhaCnab.longValue());
        query_1.executeUpdate();
    }

    private static List<ItemRemessaFolhaCnab> validarFolhaPorFechamento(List<ItemRemessaFolhaCnab> listRemessaFolhaCnab, List<RemessaFolhaFechamentoPeriodo> fechamentos) {
        ArrayList<ItemRemessaFolhaCnab> aux = new ArrayList<ItemRemessaFolhaCnab>();
        for (ItemRemessaFolhaCnab item : listRemessaFolhaCnab) {
            for (RemessaFolhaFechamentoPeriodo fechamento : fechamentos) {
                for (Object o : fechamento.getFechamentoPeriodo().getCalculoInss().getAberturasPeriodo()) {
                    CalculoInssAberturaPeriodo ab = (CalculoInssAberturaPeriodo)o;
                    for (Object mov : ab.getAberturaPeriodo().getMovimentoFolha()) {
                        if (item.getMovimentoFolha() != null) {
                            if (!item.getMovimentoFolha().equals(mov)) continue;
                            aux.add(item);
                            continue;
                        }
                        if (item.getAdiantamento13Salario() != null) {
                            if (!item.getAdiantamento13Salario().equals(mov)) continue;
                            aux.add(item);
                            continue;
                        }
                        if (item.getAdiantamentoSalario() != null) {
                            if (!item.getAdiantamentoSalario().equals(mov)) continue;
                            aux.add(item);
                            continue;
                        }
                        if (item.getSalario13oColaborador() == null || !item.getSalario13oColaborador().equals(mov)) continue;
                        aux.add(item);
                    }
                }
            }
        }
        return aux;
    }
}

