/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bancoBrasil.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bancoBrasil.pagamento._240.ConstantsRetornoBancoBrasilPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoBancoBrasilPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoBancoBrasilPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoBancoBrasil;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoBancoBrasil = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoBancoBrasil = new RetornoPagamentoCnab();
            if (line.substring(7, 8).equals("1")) {
                retornoBancoBrasil.setTipoRegistro("1");
                this.setRetornoPagamentoBancoBrasilHeaderLote(retornoBancoBrasil, line);
                this.retornoCNAB240PagamentoBancoBrasil.add(retornoBancoBrasil);
                continue;
            }
            if (line.substring(7, 8).equals("3")) {
                if (line.substring(13, 14).equals("J")) {
                    retornoBancoBrasil.setTipoRegistro("3");
                    this.setRetornoBancoBrasilDatailSegJ(retornoBancoBrasil, line);
                    this.retornoCNAB240PagamentoBancoBrasil.add(retornoBancoBrasil);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoBancoBrasil.setTipoRegistro("3");
                    this.setRetornoBancoBrasilDatailSegA(retornoBancoBrasil, line);
                    this.retornoCNAB240PagamentoBancoBrasil.add(retornoBancoBrasil);
                    continue;
                }
                if (!line.substring(13, 14).equals("O")) continue;
                retornoBancoBrasil.setTipoRegistro("3");
                this.setRetornoBancoBrasilDatailSegO(retornoBancoBrasil, line);
                this.retornoCNAB240PagamentoBancoBrasil.add(retornoBancoBrasil);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoBancoBrasil.setTipoRegistro("5");
            this.setRetornoPagamentoBancoBrasilTrailerLote(retornoBancoBrasil, line);
            this.retornoCNAB240PagamentoBancoBrasil.add(retornoBancoBrasil);
        }
    }

    private void setRetornoBancoBrasilDatailSegJ(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setNrTitulo(line.substring(182, 202));
        retornoBancoBrasil.setNrNossoNumero(line.substring(202, 222));
        retornoBancoBrasil.setLoteServico(line.substring(3, 7));
        retornoBancoBrasil.setDataPagamento(line.substring(144, 152));
        retornoBancoBrasil.setNumeroProtocolo(line.substring(202, 222));
        retornoBancoBrasil.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoBancoBrasil.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoBancoBrasil;
    }

    private void setRetornoPagamentoBancoBrasilHeaderLote(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoBancoBrasilTrailerLote(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoBancoBrasilDatailSegA(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setNrTitulo(line.substring(73, 93));
        retornoBancoBrasil.setNrNossoNumero(line.substring(134, 154));
        retornoBancoBrasil.setLoteServico(line.substring(3, 7));
        retornoBancoBrasil.setDataPagamento(line.substring(154, 162));
        retornoBancoBrasil.setNumeroProtocolo(line.substring(134, 154));
        retornoBancoBrasil.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(162, 175);
        String valorPagoDecimal = line.substring(175, 177);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoBancoBrasil.setValorBaixa(valorBaixa);
    }

    private void setRetornoBancoBrasilDatailSegO(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setNrTitulo(line.substring(122, 142));
        retornoBancoBrasil.setNrNossoNumero(line.substring(142, 162));
        retornoBancoBrasil.setLoteServico(line.substring(3, 7));
        retornoBancoBrasil.setDataPagamento(line.substring(99, 107));
        retornoBancoBrasil.setNumeroProtocolo(line.substring(142, 162));
        retornoBancoBrasil.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasilPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(107, 120);
        String valorPagoDecimal = line.substring(120, 122);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoBancoBrasil.setValorBaixa(valorBaixa);
    }
}

