/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bancoBrasil.recebimento._400;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bancoBrasil.recebimento.UtilityBancoBrasil;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaBancoBrasilRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityBancoBrasil.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 8));
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("001BANCODOBRASIL", 18));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 22));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 258));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetail(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, codificacaoArquivo);
        }
    }

    private void buildDetail(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("7");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 8));
        p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 25));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 25));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 25));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 25));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 25));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 25));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 25));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 25));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 25));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 25));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 25));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getVariacaoCarteira(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_COBRANCA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_CARTEIRA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MOVIMENTO_REMESSA", configuracao));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 10));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 10));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 10));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 10));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 10));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 10));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 10));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 10));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 10));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 10));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 10));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append("001");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_CODIFICADA_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_CODIFICADA_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIOF = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIOF = ToolString.refina((String)valorIOF);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIOF, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String erroPessoaSacado = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoaSacado != null && !erroPessoaSacado.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoaSacado);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 37) {
            p.append(titulo.getPessoa().getNome().toUpperCase().substring(0, 37));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome().toUpperCase(), 37));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "")));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 12) {
            p.append(bairro.substring(0, 12).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 12).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoCliente.getCep(), 8));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        String imprimirNotaBoleto = UtilityArquivoCnab.getValueByKey("IMPRIMIR_NOTA_BOLETO", configuracao);
        if (imprimirNotaBoleto != null && imprimirNotaBoleto.equals("S") && titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Boleto referente a NF: N\u00ba " + titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        }
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 393));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

