/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.banrisul.pagamento._240;

import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.banrisul.recebimento.UtilityBanrisul;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaBanrisulPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotal;

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilityBanrisul.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotal = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO DO BRASIL", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getNumeroSequenciaArquivo().toString(), 6));
        p.append("080");
        p.append("01600");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            this.buildDetailSegmentoA(titulo, codificacaoArquivo);
            this.buildDetailSegmentoB(titulo, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoA(Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        ConfiguracaoCnab configuracao = titulo.getConfiguracaoCnab();
        p.append("001");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("Q");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MOVIMENTO_REMESSA", configuracao));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 15));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 40) {
            p.append(nomeSacado.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))).toUpperCase();
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        ConfiguracaoCnab configuracao = titulo.getConfiguracaoCnab();
        p.append("001");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("R");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MOVIMENTO_REMESSA", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente NF: " + titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString() + " da parcela " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("001");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 117));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("001");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

