/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.banrisul.pagamento._240;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bancoBrasil.recebimento._240.ConstantsRetornoBancoBrasil240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoBanrisulPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoBanrisulPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoBancoBrasilRecebimento240CNAB;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoBancoBrasilRecebimento240CNAB = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(7, 8).equals("3")) continue;
                RetornoPagamentoCnab retornoBancoBrasil = new RetornoPagamentoCnab();
                this.setRetornoBancoBrasilDatailSegT(retornoBancoBrasil, line);
                Titulo titulo = UtilityArquivoCnab.buscarTituloPagamento(retornoBancoBrasil.getNrTitulo());
                ConfiguracaoCnab configuracao = null;
                if (titulo != null) {
                    configuracao = titulo.getConfiguracaoCnab();
                }
                this.retornoBancoBrasilRecebimento240CNAB.add(retornoBancoBrasil);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoBancoBrasilDatailSegT(RetornoPagamentoCnab retornoBancoBrasil, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBancoBrasil.setNrTitulo(line.substring(58, 73));
        retornoBancoBrasil.setDataOcorrencia(line.substring(73, 81));
        String codMovRetorno = "";
        String codOcorrencia1 = line.substring(213, 215).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia1(codOcorrencia1);
            retornoBancoBrasil.setMsgOcorrencia1(ConstantsRetornoBancoBrasil240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(215, 217).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia2(codOcorrencia2);
            retornoBancoBrasil.setMsgOcorrencia2(ConstantsRetornoBancoBrasil240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(217, 219).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia3(codOcorrencia3);
            retornoBancoBrasil.setMsgOcorrencia3(ConstantsRetornoBancoBrasil240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(219, 221).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia4(codOcorrencia4);
            retornoBancoBrasil.setMsgOcorrencia4(ConstantsRetornoBancoBrasil240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(221, 223).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBancoBrasil.setCodOcorrencia5(codOcorrencia5);
            retornoBancoBrasil.setMsgOcorrencia5(ConstantsRetornoBancoBrasil240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia5));
        }
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoBancoBrasilRecebimento240CNAB;
    }
}

