/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.banrisul.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.banrisul.recebimento._400.ConstantsRetornoBanrisul400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoBanrisulRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoBanrisulRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoBanrisulRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL = "06";
    private final String LIQUIDACAO_PARCIAL = "07";
    private final String LIQUIDACAO_SALDO = "08";
    private final String PAGAMENTO_CARTORIO = "15";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoBanrisulRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        this.analyzeHeader(line);
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(17, 29));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (!line.substring(0, 19).equals("02RETORNO01COBRANCA")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoBanrisul = new RetornoRecebimentoCnab();
                this.setRetornoBanrisulDatail(retornoBanrisul, line, opcoesFinanceiras, this.convenio);
                this.retornoBanrisulRecebimento400CNAB.add(retornoBanrisul);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoBanrisulDatail(RetornoRecebimentoCnab retornoBanrisul, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        retornoBanrisul.setNrTitulo(line.substring(116, 126));
        retornoBanrisul.setNrNossoNumero(line.substring(126, 146));
        retornoBanrisul.setDataVencimentoString(line.substring(146, 152));
        retornoBanrisul.setDataOcorrencia(line.substring(110, 116));
        retornoBanrisul.setDataReferenciaRetorno(line.substring(110, 116));
        retornoBanrisul.setDataCredito(line.substring(295, 301));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoBanrisul.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoBanrisul.getNrNossoNumero(), "041", convenio)) != null) {
                titulo = b.getTitulo();
                retornoBanrisul.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoBanrisul.getNrTitulo());
            if (titulo == null && retornoBanrisul.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoBanrisul.getNrNossoNumero(), "041", convenio)) != null) {
                titulo = b.getTitulo();
                retornoBanrisul.setBoletoTitulo(b);
            }
        }
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoBanrisul.setTitulo(titulo);
        String codMovRetorno = line.substring(108, 110).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoBanrisul.setCodMovRetorno(codMovRetorno);
            retornoBanrisul.setDescMovRet(ConstantsRetornoBanrisul400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoBanrisul.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoBanrisul.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoBanrisul.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            retornoBanrisul.setValorTarifaCobranca(0.0);
        } else {
            retornoBanrisul.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(188, 199);
            String valorIofDecimal = line.substring(199, 201);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoBanrisul.setValorIof(valorIof);
        } else {
            retornoBanrisul.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(279, 290);
            String valorOutrosCreditosDecimal = line.substring(290, 292);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoBanrisul.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoBanrisul.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoBanrisul.setValorAbatimento(valorAbatimento);
        } else {
            retornoBanrisul.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            retornoBanrisul.setValorDespesasBancarias(0.0);
        } else {
            retornoBanrisul.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoBanrisul.setValorJuros(valorJuros);
        } else {
            retornoBanrisul.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoBanrisul.setValorDesconto(valorDesconto);
        } else {
            retornoBanrisul.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoBanrisul.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoBanrisul.setValorMulta(0.0);
        } else {
            retornoBanrisul.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoBanrisul.setValorTitulo(valorTitulo);
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoBanrisulRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "07": {
                return Boolean.TRUE;
            }
            case "08": {
                return Boolean.TRUE;
            }
            case "15": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

