/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bib.recebimento._240;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bib.recebimento.UtilityBIB;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaBIBRecebimento240
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Long quantidadeTitulos = 0L;
    private Double valorTotalTitulos = 0.0;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityBIB.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        this.quantidadeTitulos = 0L;
        this.valorTotalTitulos = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("604");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaCobranca.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String numeroConvenio = UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 14);
        p.append(UtilityArquivoCnab.completarComBrancoDireita(numeroConvenio, 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(numeroConvenio, 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("Banco Industrial do Brasil", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaCobranca.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 6));
        p.append("030");
        p.append("01600");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca i : remessa.getItemRemessaCobranca()) {
            this.buildDetailSegmentoP(i, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoQ(i, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoY(i, configuracao, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoP(ItemRemessaCnabCobranca i, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = i.getItemBordero().getTitulo();
        BorderoTitulos bordero = i.getItemBordero().getBorderoCobranca();
        BoletoTitulo boleto = i.getBoleto();
        p.append("604");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("3", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("P");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(i.getRemessaCobranca().getTipoRemessa().getCodigo(), 2));
        String numeroConvenio = UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 14);
        p.append(UtilityArquivoCnab.completarComBrancoDireita(numeroConvenio, 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("SERVICO_CLASSIFICACAO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("MODALIDADE_CORRESPONDENCIA", configuracao), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("MODALIDADE_CEDENTE", configuracao), 3));
        String mod10 = this.getModulo10("1210019" + boleto.getNumeroTituloInst().toString());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(mod10, 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getCodigoCarteira(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("FORMA_CAD_BANCO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("2", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("DISTRIBUICAO_BLOQUETO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(boleto.getTitulo().getDataVencimento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(boleto.getTitulo().getValor()), 15));
        p.append(UtilityArquivoCnab.completarComZeroDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao), 1));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(boleto.getTitulo().getDataEmissao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), 1));
        if (titulo.getDataInicioJuros() != null) {
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataInicioJuros()));
        } else {
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(ToolDate.nextDays((Date)titulo.getDataVencimento(), (int)1)));
        }
        String codJurosMora = UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), 1);
        if (codJurosMora.equals("1")) {
            Double valorJurosDia = titulo.getVrJurosDia() / titulo.getValor() * titulo.getValorSaldo();
            if (valorJurosDia == null) {
                valorJurosDia = 0.0;
            }
            String valorMoraMes = ContatoFormatUtil.formataNumero((Number)valorJurosDia, (int)2);
            valorMoraMes = ToolString.refina((String)valorMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMes, 15));
        } else if (codJurosMora.equals("2")) {
            String texaMoraMes = ContatoFormatUtil.formataNumero((Number)titulo.getPercJurosMes(), (int)2);
            texaMoraMes = ToolString.refina((String)texaMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaMoraMes, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao), 1));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(boleto.getTitulo().getDataLimiteDesconto()));
        String codDesconto = UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao);
        if (codDesconto.equals("1") || codDesconto.equals("3") || codDesconto.equals("4")) {
            String valorDescont = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
            valorDescont = ToolString.refina((String)valorDescont);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescont, 15));
        } else if (codDesconto.equals("2") || codDesconto.equals("5") || codDesconto.equals("6")) {
            String texaDesconto = ContatoFormatUtil.formataNumero((Number)titulo.getPercDescontoMes(), (int)2);
            texaDesconto = ToolString.refina((String)texaDesconto);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaDesconto, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(boleto.getTitulo().getVrIofPago()), 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(boleto.getTitulo().getVrAbatimento()), 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(boleto.getTitulo().getIdentificador().toString(), 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("COD_PROTESTO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("COD_BAIXA_DEVOLUCAO", configuracao), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getValueByKey("NUM_DIAS_BAIXA_DEVOLUCAO", configuracao), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("09", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        this.valorTotalTitulos = this.valorTotalTitulos + titulo.getValor();
        Number number = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        number = this.quantidadeTitulos;
        this.quantidadeTitulos = this.quantidadeTitulos + 1L;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoQ(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("604");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("3", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("Q", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getRemessaCobranca().getTipoRemessa().getCodigo(), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.getTipoInstricao(titulo.getPessoa().getComplemento().getCnpj()), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome(), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)(titulo.getPessoa().getEndereco().getLogradouro() + " " + titulo.getPessoa().getEndereco().getNumero() + " " + (ToolMethods.isStrWithData((String)titulo.getPessoa().getEndereco().getComplemento()) ? titulo.getPessoa().getEndereco().getComplemento() : ""))).toUpperCase(), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getEndereco().getBairro(), 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 1, titulo.getPessoa().getNome()), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 2, titulo.getPessoa().getNome()), 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getEndereco().getCidade().getDescricao(), 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        this.valorTotalTitulos = ToolFormatter.arrredondarNumero((Double)this.valorTotalTitulos, (int)2);
        p.append("604");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("5", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.quantidadeTitulos.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(this.valorTotalTitulos), 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.quantidadeTitulos.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(this.valorTotalTitulos), 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.quantidadeTitulos.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(this.valorTotalTitulos), 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.quantidadeTitulos.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(this.valorTotalTitulos), 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 117));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("604");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("604", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("R", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("30", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("2", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaCobranca.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj(), 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(" ", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(" ", 40));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 8));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 33));
        p.println();
        p.flush();
        p.close();
    }

    private String getTipoInstricao(String cnpj) {
        if (cnpj.length() == 14) {
            return "2";
        }
        return "1";
    }

    private String formatarValor(Double valor) {
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valor, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        return valorCobrado;
    }

    private void buildDetailSegmentoY(ItemRemessaCnabCobranca i, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = i.getItemBordero().getTitulo();
        p.append("604");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("Y");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append("52");
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        }
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.formatarValor(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getValoresNfPropria().getValorTotal()), 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getDataEmissaoNota()));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        }
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getChaveNFE(), 8));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 44));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 44));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 57));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private String getModulo10(String campo) {
        int multiplicador = 2;
        int multiplicacao = 0;
        int soma_campo = 0;
        for (int i = campo.length(); i > 0; --i) {
            multiplicacao = Integer.parseInt(campo.substring(i - 1, i)) * multiplicador;
            if (multiplicacao > 9) {
                multiplicacao -= 9;
            }
            soma_campo += multiplicacao;
            if (--multiplicador != 0) continue;
            multiplicador = 2;
        }
        int dac = 10 - soma_campo % 10;
        return Integer.valueOf(dac).toString();
    }
}

