/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.pagamento._240;

import com.touchcomp.basementor.constants.ConstantsTipoConta;
import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.recebimento.UtilityBradesco;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaBradescoPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotalPago;
    private static Integer numeroTotalLotes;
    private static Integer numeroRegistroArquivo;
    private static Integer qtdeRegistroLote;
    public static final String CONTA_CORRENTE = "CC";
    public static final String CONTA_POUPANCA = "PP";

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilityBradesco.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
        numeroTotalLotes = 0;
        numeroRegistroArquivo = 0;
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        qtdeRegistroLote = 0;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotalPago = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() != null) {
            if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        }
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BRADESCO", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getNumeroSequenciaArquivo().toString(), 6));
        p.append("089");
        p.append("01600");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildHeaderPackageSegmentoA(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildHeaderPackageSegmentoJ(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildHeaderPackageSegmentoO(remessaPagamento, item, codificacaoArquivo);
        }
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
                this.buildDetailSegmentoA(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoB(item, configuracao, titulo, codificacaoArquivo);
                continue;
            }
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
                this.buildDetailSegmentoJ(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoJ52(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (!EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) continue;
            this.buildDetailSegmentoO(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoJ(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(titulo.getCodigoDeBarras());
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorDescontoAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getVrAbatimento() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDescontoAbatimento = ToolString.refina((String)valorDescontoAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescontoAbatimento, 15));
        String valorMoraMulta = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorMoraMulta = ToolString.refina((String)valorMoraMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMulta, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ52(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append("01");
        p.append("52");
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomePagador = ToolString.substituiCaractereEspecial((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeBeneficiario = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeBeneficiario.length() > 40) {
            p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
        }
        if (titulo.getSacadorAvalista() != null) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getSacadorAvalista()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getSacadorAvalista().getComplemento().getCnpj()), 15));
            String sacadorAvalista = ToolString.substituiCaractereEspecial((String)titulo.getSacadorAvalista().getNome());
            if (sacadorAvalista.length() > 40) {
                p.append(sacadorAvalista.substring(0, 40).toUpperCase());
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(sacadorAvalista, 40).toUpperCase());
            }
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 53));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildTrailerPackageSegmentoA(codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildTrailerPackageSegmentoJ(codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"237")) {
            this.buildTrailerPackageSegmentoO(codificacaoArquivo);
        }
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.append("237");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildHeaderPackageSegmentoA(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("045");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() != null) {
            if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento Folha");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        String dvContaBancaria = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta();
        if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 2) {
            p.append(dvContaBancaria.substring(0, 1));
        } else if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 1) {
            p.append(dvContaBancaria);
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 2) {
            p.append(dvContaBancaria.substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeEmpresa = ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome());
        if (nomeEmpresa.length() > 30) {
            p.append(nomeEmpresa.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro());
        if (logradouro.length() > 30) {
            p.append(logradouro.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = "";
        if (enderecoEmpresa.getComplemento() != null) {
            complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        }
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoA(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            p.append("018");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03")) {
            p.append("700");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("01") && item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equalsIgnoreCase("20") || item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equalsIgnoreCase("30")) {
            p.append("000");
        } else {
            p.append("888");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getNrBanco(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getContaBancaria().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getContaCorrente(), 12));
        String digitoVerificadorConta = item.getItemBordero().getContaBancaria().getDvContaCorrente();
        if (digitoVerificadorConta != null && !digitoVerificadorConta.isEmpty() && digitoVerificadorConta.length() == 2) {
            p.append(digitoVerificadorConta.substring(0, 1));
        } else if (digitoVerificadorConta != null && !digitoVerificadorConta.isEmpty() && digitoVerificadorConta.length() == 1) {
            p.append(digitoVerificadorConta);
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (digitoVerificadorConta != null && !digitoVerificadorConta.isEmpty() && digitoVerificadorConta.length() == 2) {
            p.append(digitoVerificadorConta.substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append("BRL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        String valorPago = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPago = ToolString.refina((String)valorPago);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPago, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03")) {
            if (item.getItemBordero().getFinalidadeDoc() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade DOC. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeDoc().getCodigo(), 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            if (item.getItemBordero().getFinalidadeTed() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade TED. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeTed().getCodigo(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            if (ToolMethods.isEquals((Object)item.getItemBordero().getContaBancaria().getTipoConta(), (Object)ConstantsTipoConta.CONTA_CORRENTE)) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(CONTA_CORRENTE, 2));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(CONTA_POUPANCA, 2));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        if (item.getItemBordero().getContaBancaria() != null && item.getItemBordero().getContaBancaria().getCnpj() != null && !item.getItemBordero().getContaBancaria().getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getContaBancaria().getCnpj()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getCnpj(), 14));
        } else {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        }
        Endereco enderecoColaborador = titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoColaborador, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getLogradouro());
        if (logradouro.length() > 30) {
            p.append(logradouro.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoColaborador.getNumero(), 5));
        String complemento = "";
        if (enderecoColaborador.getComplemento() != null) {
            complemento = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getComplemento());
        }
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoColaborador.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoColaborador.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoColaborador.getCep(), 2, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoColaborador.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPago = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPago = ToolString.refina((String)valorPago);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPago, 15));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 15));
        String valorJurosEmbutido = ContatoFormatUtil.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        valorJurosEmbutido = ToolString.refina((String)valorJurosEmbutido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosEmbutido, 15));
        String valorMultaEmbutida = ContatoFormatUtil.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        valorMultaEmbutida = ToolString.refina((String)valorMultaEmbutida);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMultaEmbutida, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        if (!(ToolMethods.isEquals((Object)item.getItemBordero().getFormaLancamento().getCodigo(), (Object)"41") || ToolMethods.isEquals((Object)item.getItemBordero().getFormaLancamento().getCodigo(), (Object)"43") || ToolMethods.isEquals((Object)item.getItemBordero().getFormaLancamento().getCodigo(), (Object)"03"))) {
            if (item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb() == null || item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb().isEmpty()) {
                p.close();
                this.getFile().delete();
                throw new IOException("A institui\u00e7\u00e3o de Valores da Pessoa: " + titulo.getPessoa().toString() + " est\u00e1 sem o C\u00f3digo ISPB. Contate o Suporte Tecnico!");
            }
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb(), 8));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        }
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackageSegmentoA(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotal = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotal = ToolString.refina((String)valorTotal);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotal, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackageSegmentoJ(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoJ(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("040");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() != null) {
            if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta());
        }
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento == null && complemento.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento().toUpperCase()).substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento().toUpperCase()), 15).toUpperCase());
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoO(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("012");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() != null) {
            if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        String dvContaBancaria = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta();
        if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 2) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(dvContaBancaria.substring(0, 1), 1));
        } else if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 1) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(dvContaBancaria, 1));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (dvContaBancaria != null && !dvContaBancaria.isEmpty() && dvContaBancaria.length() == 2) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(dvContaBancaria.substring(1, 2), 1));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeEmpresa = ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome());
        if (nomeEmpresa.length() > 30) {
            p.append(nomeEmpresa.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getNumero()), 5));
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento == null || complemento.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)ToolString.substituiCaractereEspecial((String)complemento.toUpperCase()).toUpperCase().substring(0, 15)));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase()), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoO(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(tipoMovimento);
        if (titulo.getCodigoDeBarras() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("O Titulo: " + titulo.toString() + " esta sem Codigo de Barras. Favor Informar!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCodigoDeBarras(), 44));
        String nomeConcessionaria = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeConcessionaria.length() > 30) {
            p.append(nomeConcessionaria.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeConcessionaria, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 68));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackageSegmentoO(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("237");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotal = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotal = ToolString.refina((String)valorTotal);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotal, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

