/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.pagamento._240.ConstantsRetornoBradescoPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoBradescoPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoBradescoPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoBradesco;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoBradesco = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoBradesco = new RetornoPagamentoCnab();
            if (line.substring(5, 6).equals("1")) {
                retornoBradesco.setTipoRegistro("1");
                this.setRetornoPagamentoBradescoHeaderLote(retornoBradesco, line);
                this.retornoCNAB240PagamentoBradesco.add(retornoBradesco);
                continue;
            }
            if (line.substring(7, 8).equals("3") && !line.substring(17, 19).equals("52")) {
                retornoBradesco.setTipoRegistro("3");
                if (line.substring(13, 14).equals("J")) {
                    retornoBradesco.setTipoRegistro("3");
                    this.setRetornoPagamentoBradescoDatailSegJ(retornoBradesco, line);
                    this.retornoCNAB240PagamentoBradesco.add(retornoBradesco);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoBradesco.setTipoRegistro("3");
                    this.setRetornoPagamentoBradescoDatailSegA(retornoBradesco, line);
                    this.retornoCNAB240PagamentoBradesco.add(retornoBradesco);
                    continue;
                }
                if (!line.substring(13, 14).equals("O")) continue;
                retornoBradesco.setTipoRegistro("3");
                this.setRetornoPagamentoBradescoDatailSegO(retornoBradesco, line);
                this.retornoCNAB240PagamentoBradesco.add(retornoBradesco);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoBradesco.setTipoRegistro("5");
            this.setRetornoPagamentoBradescoTrailerLote(retornoBradesco, line);
            this.retornoCNAB240PagamentoBradesco.add(retornoBradesco);
        }
    }

    private void setRetornoPagamentoBradescoDatailSegJ(RetornoPagamentoCnab retornoPagamentoBradesco, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoBradesco.setNrTitulo(line.substring(182, 202));
        retornoPagamentoBradesco.setNrNossoNumero(line.substring(202, 222));
        retornoPagamentoBradesco.setLoteServico(line.substring(3, 7));
        retornoPagamentoBradesco.setDataPagamento(line.substring(144, 152));
        retornoPagamentoBradesco.setNumeroProtocolo(line.substring(202, 222));
        retornoPagamentoBradesco.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoBradesco.setMsgOcorrencia1(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoBradesco.setMsgOcorrencia2(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoBradesco.setMsgOcorrencia3(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoBradesco.setMsgOcorrencia4(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoBradesco.setMsgOcorrencia5(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoBradesco.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoBradesco;
    }

    private void setRetornoPagamentoBradescoTrailerLote(RetornoPagamentoCnab retornoBradesco, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBradesco.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoBradesco.setMsgOcorrencia1(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoBradesco.setMsgOcorrencia2(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoBradesco.setMsgOcorrencia3(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoBradesco.setMsgOcorrencia4(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoBradesco.setMsgOcorrencia5(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoBradescoHeaderLote(RetornoPagamentoCnab retornoBradesco, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBradesco.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoBradesco.setMsgOcorrencia1(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoBradesco.setMsgOcorrencia2(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoBradesco.setMsgOcorrencia3(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoBradesco.setMsgOcorrencia4(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoBradesco.setMsgOcorrencia5(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoBradescoDatailSegA(RetornoPagamentoCnab retornoPagamentoBradesco, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoBradesco.setNrTitulo(line.substring(73, 93));
        retornoPagamentoBradesco.setNrNossoNumero(line.substring(134, 154));
        retornoPagamentoBradesco.setLoteServico(line.substring(3, 7));
        retornoPagamentoBradesco.setDataPagamento(line.substring(93, 101));
        retornoPagamentoBradesco.setNumeroProtocolo(line.substring(134, 154));
        retornoPagamentoBradesco.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoBradesco.setMsgOcorrencia1(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoBradesco.setMsgOcorrencia2(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoBradesco.setMsgOcorrencia3(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoBradesco.setMsgOcorrencia4(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoBradesco.setMsgOcorrencia5(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(119, 132);
        String valorPagoDecimal = line.substring(132, 134);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoBradesco.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoBradescoDatailSegO(RetornoPagamentoCnab retornoPagamentoBradesco, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoBradesco.setNrTitulo(line.substring(122, 142));
        retornoPagamentoBradesco.setNrNossoNumero(line.substring(142, 162));
        retornoPagamentoBradesco.setLoteServico(line.substring(3, 7));
        retornoPagamentoBradesco.setDataPagamento(line.substring(99, 107));
        retornoPagamentoBradesco.setNumeroProtocolo(line.substring(142, 162));
        retornoPagamentoBradesco.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoBradesco.setMsgOcorrencia1(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoBradesco.setMsgOcorrencia2(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoBradesco.setMsgOcorrencia3(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoBradesco.setMsgOcorrencia4(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoBradesco.setMsgOcorrencia5(ConstantsRetornoBradescoPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(107, 120);
        String valorPagoDecimal = line.substring(120, 122);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoBradesco.setValorBaixa(valorBaixa);
    }
}

