/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.recebimento._400;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.recebimento.UtilityBradesco;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaBradescoRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityBradesco.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        Pessoa pessoaEmpresa = ToolMethods.isEquals((Object)bordero.getCarteiraCobranca().getUsarAgenciaValorBeneficiario(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getPessoa() : remessaCobranca.getEmpresa().getPessoa();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 20));
        if (pessoaEmpresa.getNome().length() > 30) {
            p.append(pessoaEmpresa.getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(pessoaEmpresa.getNome(), 30));
        }
        p.append("237");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BRADESCO", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append("MX");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 277));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetail(item, item.getItemBordero().getBorderoCobranca(), tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetail(ItemRemessaCnabCobranca item, BorderoTitulos borderoTitulos, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityBradesco.identificacaoCedenteNoBradesco(boleto));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao));
        String codMulta = UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao);
        if (codMulta.equals("0")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        } else {
            Double taxaDouble = titulo.getPercMulta();
            String taxaMulta = ContatoFormatUtil.formataNumero((Number)taxaDouble, (int)2);
            taxaMulta = ToolString.refina((String)taxaMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(taxaMulta, 4));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 11));
        p.append(UtilityBradesco.calculoDigitoVerificadorBradescoMod11(boleto));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.getValueByKey("EMISSAO_BOLETO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(tipoMovimento);
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getFaturaCte().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getRps() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getRps().getNumero(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getOrdemCompra().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getInfPagamentoPedido().getPedido().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getPedidoComercio().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getAdiantamentoViagem().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getNotaContratoLocacao().getNumero(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getContratoLocacao().getNumeroContrato(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getApuracaoLocacaoContrato().getIdentificador(), titulo.getNumParcTituloEstnota()));
            } else if (titulo.getCte() != null) {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getCte().getNumero(), titulo.getNumParcTituloEstnota()));
            } else {
                p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getIdentificador(), titulo.getNumParcTituloEstnota()));
            }
        } else {
            p.append(UtilityBradesco.formatarNumeroDocumento(titulo.getIdentificador(), titulo.getNumParcTituloEstnota()));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append("N");
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = null;
        valorDesconto = boleto != null && boleto.getValorDesconto() > 0.0 ? ContatoFormatUtil.formataNumero((Number)boleto.getValorDesconto(), (int)2) : ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIOF = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIOF = ToolString.refina((String)valorIOF);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIOF, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 40) {
            p.append(titulo.getPessoa().getNome().toUpperCase().substring(0, 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome().toUpperCase(), 40));
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + enderecoCliente.getBairro() + " " + enderecoCliente.getCidade().getDescricao() + " " + enderecoCliente.getCidade().getUf().getSigla()));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        p.append(UtilityBradesco.segundaMensagem(borderoTitulos.getCarteiraCobranca(), configuracao, titulo));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("CHAVE_NOTA", configuracao), (Object)"1") && titulo.getInfPagamentoNfPropria() != null) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getChaveNFE(), 44));
        }
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 393));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

