/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.bradesco.recebimento._400.ConstantsRetornoBradesco400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoBradescoRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoBradescoRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoBradescoRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL = "06";
    private final String LIQUIDACAO_CARTORIO = "15";
    private final String LIQUIDACAO_APOS_BAIXA_OU_LIQUIDACAO_TITULO_NAO_REGISTRADO = "17";
    private final String ENTRADA_REJEITADA = "03";
    private final String ENTRADA_REJEITADA_CEP = "24";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoBradescoRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(26, 46));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoBradesco = new RetornoRecebimentoCnab();
                this.setRetornoBradescoDatail(retornoBradesco, line, opcoesFinanceiras, this.convenio);
                this.retornoBradescoRecebimento400CNAB.add(retornoBradesco);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoBradescoDatail(RetornoRecebimentoCnab retornoBradesco, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoBradesco.setNrTitulo(line.substring(116, 126));
        retornoBradesco.setNrNossoNumero(line.substring(70, 81));
        retornoBradesco.setDataVencimentoString(line.substring(146, 152));
        retornoBradesco.setDataCredito(line.substring(295, 301));
        retornoBradesco.setDataOcorrencia(line.substring(110, 116));
        retornoBradesco.setDataReferenciaRetorno(line.substring(110, 116));
        retornoBradesco.setNumeroCartorio(line.substring(368, 370));
        retornoBradesco.setNumeroProtocolo(line.substring(370, 380));
        retornoBradesco.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoBradesco.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoBradesco.getNrNossoNumero(), "237", convenio)) != null) {
                titulo = b.getTitulo();
                retornoBradesco.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoBradesco.getNrTitulo());
            if (titulo == null && retornoBradesco.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoBradesco.getNrNossoNumero(), "237", convenio)) != null) {
                titulo = b.getTitulo();
                retornoBradesco.setBoletoTitulo(b);
            }
        }
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoBradesco.setTitulo(titulo);
        String codMovRetorno = line.substring(108, 110).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoBradesco.setCodMovRetorno(codMovRetorno);
            retornoBradesco.setDescMovRet(ConstantsRetornoBradesco400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoBradesco.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoBradesco.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoBradesco.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(318, 320).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoBradesco.setCodOcorrencia1(codOcorrencia1);
            retornoBradesco.setMsgOcorrencia1(ConstantsRetornoBradesco400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(320, 322).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoBradesco.setCodOcorrencia2(codOcorrencia2);
            retornoBradesco.setMsgOcorrencia2(ConstantsRetornoBradesco400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(322, 324).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoBradesco.setCodOcorrencia3(codOcorrencia3);
            retornoBradesco.setMsgOcorrencia3(ConstantsRetornoBradesco400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(324, 326).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoBradesco.setCodOcorrencia4(codOcorrencia4);
            retornoBradesco.setMsgOcorrencia4(ConstantsRetornoBradesco400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(326, 328).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoBradesco.setCodOcorrencia5(codOcorrencia5);
            retornoBradesco.setMsgOcorrencia5(ConstantsRetornoBradesco400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia5));
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(175, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoBradesco.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoBradesco.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(214, 225);
            String valorIofDecimal = line.substring(225, 227);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoBradesco.setValorIof(valorIof);
        } else {
            retornoBradesco.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(279, 290);
            String valorOutrosCreditosDecimal = line.substring(290, 292);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoBradesco.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoBradesco.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoBradesco.setValorAbatimento(valorAbatimento);
        } else {
            retornoBradesco.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(188, 199);
            String valorOutrasDespesasDecimal = line.substring(199, 201);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retornoBradesco.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retornoBradesco.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoBradesco.setValorJuros(valorJuros);
        } else {
            retornoBradesco.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoBradesco.setValorDesconto(valorDesconto);
        } else {
            retornoBradesco.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoBradesco.setValorBaixa(valorBaixa);
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoBradesco.setValorTitulo(valorTitulo);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoBradesco.setValorMulta(0.0);
        } else {
            retornoBradesco.setValorMulta(0.0);
        }
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoBradescoRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "15": {
                return Boolean.TRUE;
            }
            case "17": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
            case "24": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

