/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.pagamento._240;

import com.touchcomp.basementor.constants.ConstantsTipoConta;
import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.recebimento.UtilityCaixa;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaCaixaPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotalPago;
    private static Integer numeroTotalLotes;
    private static Integer numeroRegistroArquivo;
    private static Integer qtdeRegistroLote;
    private static Integer regSeqRegistroCompl;

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilityCaixa.getFileName(numSequencialRemessa) + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
        numeroTotalLotes = 0;
        numeroRegistroArquivo = 0;
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        qtdeRegistroLote = 0;
        regSeqRegistroCompl = 1;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotalPago = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() <= 6) {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 6));
            } else {
                p.append(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().substring(0, 6));
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o n\u00famero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.getValueByKey("PARAMETRO_TRANSMISSAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("AMBIENTE_CLIENTE", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Ag\u00eancia utilizada pela Empresa est\u00e1 sem o d\u00edgito verificador ou o d\u00edgito cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        String operacao = bordero.getCarteiraCobranca().getContaValor().getOperacao() == null ? "" : bordero.getCarteiraCobranca().getContaValor().getOperacao();
        String nrConta = bordero.getCarteiraCobranca().getContaValor().getNrConta();
        if (bordero.getCarteiraCobranca().getContaValor().getNrConta() != null) {
            if (!operacao.isEmpty()) {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(operacao, 4));
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(nrConta, 8));
            } else {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(nrConta, 12));
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta() == null || bordero.getCarteiraCobranca().getContaValor().getDvConta().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("CAIXA", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getNumeroSequenciaArquivo().toString(), 6));
        p.append("080");
        p.append("01600");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
            this.buildHeaderPackageSegmentoA(remessaPagamento, item, configuracao, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
            this.buildHeaderPackageSegmentoJ(remessaPagamento, item, configuracao, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
            this.buildHeaderPackageSegmentoO(remessaPagamento, item, configuracao, codificacaoArquivo);
        }
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
                this.buildDetailSegmentoA(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoB(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
                this.buildDetailSegmentoJ(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoJ52(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (!EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) continue;
            this.buildDetailSegmentoO(item, configuracao, tipoMovimento, titulo, codificacaoArquivo);
            if (!(titulo.getCodigoReceitaFederal() != null && !titulo.getCodigoReceitaFederal().isEmpty() || titulo.getIdentificadorFGTS() != null && !titulo.getIdentificadorFGTS().isEmpty()) && (titulo.getLacreConectividadeSocial() == null || titulo.getLacreConectividadeSocial().isEmpty())) continue;
            this.buildDetailSegmentoW(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoJ(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(titulo.getCodigoDeBarras().substring(0, 3));
        p.append(titulo.getCodigoDeBarras().substring(3, 4));
        p.append(titulo.getCodigoDeBarras().substring(4, 5));
        p.append(titulo.getCodigoDeBarras().substring(5, 9));
        p.append(titulo.getCodigoDeBarras().substring(9, 19));
        p.append(titulo.getCodigoDeBarras().substring(19, 44));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorDescontoAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getValorDescontosEmbutido() + titulo.getVrAbatimento() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDescontoAbatimento = ToolString.refina((String)valorDescontoAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescontoAbatimento, 15));
        String valorMoraMulta = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorMoraMulta = ToolString.refina((String)valorMoraMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMulta, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getCodigoDeBarras().substring(3, 4), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ52(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append("52");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomePagador = ToolString.substituiCaractereEspecial((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeBeneficiario = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeBeneficiario.length() > 40) {
            p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
        }
        if (titulo.getSacadorAvalista() != null) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getSacadorAvalista()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getSacadorAvalista().getComplemento().getCnpj()), 15));
            String nomeSacadorAvalista = ToolString.substituiCaractereEspecial((String)titulo.getSacadorAvalista().getNome());
            if (nomeSacadorAvalista.length() > 40) {
                p.append(nomeSacadorAvalista.substring(0, 40).toUpperCase());
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacadorAvalista, 40).toUpperCase());
            }
        } else {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
            if (nomeBeneficiario.length() > 40) {
                p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
            }
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 53));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
            this.buildTrailerPackageSegmentoA(codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"104")) {
            this.buildTrailerPackageSegmentoJ(codificacaoArquivo);
        }
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.append("104");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    public void buildHeaderPackageSegmentoA(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String operacao;
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        BorderoPagamento bordero = item.getItemBordero().getBorderoPagamento();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("041");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 6));
        if (item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("30")) {
            p.append("02");
        } else {
            p.append("01");
        }
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_COMPROMISSO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("PARAMETRO_TRANSMISSAO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Ag\u00eancia utilizada pela Empresa est\u00e1 sem o d\u00edgito verificador ou o d\u00edgito cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        Object conta = bordero.getCarteiraCobranca().getContaValor().getNrConta();
        String string = operacao = bordero.getCarteiraCobranca().getContaValor().getOperacao() == null || bordero.getCarteiraCobranca().getContaValor().getOperacao().isEmpty() ? "" : bordero.getCarteiraCobranca().getContaValor().getOperacao();
        if (!operacao.isEmpty()) {
            operacao = UtilityArquivoCnab.completarComZeroEsquerda(operacao, 4);
            conta = operacao + UtilityArquivoCnab.completarComZeroEsquerda((String)conta, 8);
        }
        if (conta == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)conta, 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta() == null || bordero.getCarteiraCobranca().getContaValor().getDvConta().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String nomeEmpresa = remessaPagamento.getEmpresa().getPessoa().getNome();
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa.toUpperCase(), 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_AVISO", configuracao));
        String logradouro = remessaPagamento.getEmpresa().getPessoa().getEndereco().getLogradouro();
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro.toUpperCase(), 30));
        } else {
            p.append(logradouro.substring(0, 30).toUpperCase());
        }
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = "";
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento() != null) {
            complemento = remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento();
        }
        if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        } else {
            p.append(complemento.substring(0, 15).toUpperCase());
        }
        String cidade = remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao();
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        } else {
            p.append(cidade.substring(0, 20).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoA(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        String operacao;
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(tipoMovimento, 3));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equals("03")) {
            p.append("700");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equals("10")) {
            p.append("700");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equals("41") || item.getItemBordero().getFormaLancamento().getCodigo().equals("43")) {
            p.append("018");
        } else {
            p.append("000");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getNrBanco(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getAgencia()), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvAgencia()), 1));
        String conta = ToolString.refina((String)item.getItemBordero().getContaBancaria().getContaCorrente());
        String string = operacao = ToolString.refina((String)item.getItemBordero().getContaBancaria().getOperacao()) == null || ToolString.refina((String)item.getItemBordero().getContaBancaria().getOperacao()).isEmpty() ? "0" : ToolString.refina((String)item.getItemBordero().getContaBancaria().getOperacao());
        if (!operacao.isEmpty()) {
            conta = UtilityArquivoCnab.completarComZeroEsquerda(conta, 12);
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(conta, 12));
        String digitoConta = ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvContaCorrente());
        if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 2) {
            p.append(digitoConta.substring(0, 1));
        } else if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 1) {
            p.append(digitoConta);
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (digitoConta != null && !digitoConta.isEmpty() && digitoConta.length() == 2) {
            p.append(digitoConta.substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        String nomeColaborador = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeColaborador.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeColaborador, 30));
        } else {
            p.append(nomeColaborador.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 13));
        if (item.getItemBordero().getContaBancaria().getTipoConta() == null) {
            throw new IOException("A Conta banc\u00e1ria da pessoa " + titulo.getPessoa().toString() + " esta sem o Tipo de Conta");
        }
        if (ToolMethods.isEquals((Object)item.getItemBordero().getContaBancaria().getTipoConta(), (Object)ConstantsTipoConta.CONTA_SALARIO) || ToolMethods.isEquals((Object)item.getItemBordero().getContaBancaria().getTipoConta(), (Object)ConstantsTipoConta.CONTA_CORRENTE)) {
            p.append("1");
        } else if (ToolMethods.isEquals((Object)item.getItemBordero().getContaBancaria().getTipoConta(), (Object)ConstantsTipoConta.CONTA_POUPANCA)) {
            p.append("2");
        } else {
            p.append("0");
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append("BRL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 15));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        String valorPago = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPago = ToolString.refina((String)valorPago);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPago, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append("01");
        p.append("N");
        p.append("1");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolDate.dayFromDate((Date)item.getItemBordero().getDataPagamento()).toString(), 2));
        p.append("00");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equals("03")) {
            p.append(item.getItemBordero().getFinalidadeDoc().getCodigo());
        } else {
            p.append("00");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoJ(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        BorderoPagamento bordero = item.getItemBordero().getBorderoPagamento();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("041");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 6));
        p.append("01");
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_COMPROMISSO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("PARAMETRO_TRANSMISSAO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Ag\u00eancia utilizada pela Empresa est\u00e1 sem o d\u00edgito verificador ou o d\u00edgito cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        Object nrConta = bordero.getCarteiraCobranca().getContaValor().getOperacao() == null ? "" : bordero.getCarteiraCobranca().getContaValor().getOperacao();
        nrConta = (String)nrConta + bordero.getCarteiraCobranca().getContaValor().getNrConta();
        if (bordero.getCarteiraCobranca().getContaValor().getNrConta() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)nrConta, 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta() == null || bordero.getCarteiraCobranca().getContaValor().getDvConta().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String nomeEmpresa = remessaPagamento.getEmpresa().getPessoa().getNome();
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa.toUpperCase(), 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_AVISO", configuracao));
        String logradouro = remessaPagamento.getEmpresa().getPessoa().getEndereco().getLogradouro();
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro.toUpperCase(), 30));
        } else {
            p.append(logradouro.substring(0, 30).toUpperCase());
        }
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = "";
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento() != null) {
            complemento = remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento();
        }
        if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        } else {
            p.append(complemento.substring(0, 15).toUpperCase());
        }
        String cidade = remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao();
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        } else {
            p.append(cidade.substring(0, 20).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackageSegmentoJ(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalGeral = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalGeral = ToolString.refina((String)valorTotalGeral);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalGeral, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackageSegmentoA(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        String valorTotalGeral = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalGeral = ToolString.refina((String)valorTotalGeral);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalGeral, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("0", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        ContaSalarioColaborador contaBancaria = item.getItemBordero().getContaBancaria();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        if (contaBancaria != null && contaBancaria.getCnpj() != null && !contaBancaria.getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(contaBancaria.getCnpj()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaBancaria.getCnpj(), 14));
        } else {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getLogradouro());
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (titulo.getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(titulo.getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = titulo.getPessoa().getEndereco().getComplemento();
        if (complemento == null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)complemento), 15));
        } else {
            p.append(ToolString.substituiCaractereEspecial((String)complemento.substring(0, 15)));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getBairro());
        if (bairro.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15));
        } else {
            p.append(bairro.substring(0, 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getCidade().getDescricao());
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 2, titulo.getPessoa().getNome()));
        p.append(titulo.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 15));
        String valorJurosEmbutido = ContatoFormatUtil.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        valorJurosEmbutido = ToolString.refina((String)valorJurosEmbutido);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosEmbutido, 15));
        String valorMultaEmbutida = ContatoFormatUtil.formataNumero((Number)titulo.getValorMultaEmbutida(), (int)2);
        valorMultaEmbutida = ToolString.refina((String)valorMultaEmbutida);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMultaEmbutida, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoO(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        BorderoPagamento bordero = item.getItemBordero().getBorderoPagamento();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("041");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 6));
        p.append("01");
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_COMPROMISSO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("PARAMETRO_TRANSMISSAO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Ag\u00eancia utilizada pela Empresa est\u00e1 sem o d\u00edgito verificador ou o d\u00edgito cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        if (bordero.getCarteiraCobranca().getContaValor().getNrConta() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta() == null || bordero.getCarteiraCobranca().getContaValor().getDvConta().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String nomeEmpresa = remessaPagamento.getEmpresa().getPessoa().getNome();
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa.toUpperCase(), 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_AVISO", configuracao));
        String logradouro = remessaPagamento.getEmpresa().getPessoa().getEndereco().getLogradouro();
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro.toUpperCase(), 30));
        } else {
            p.append(logradouro.substring(0, 30).toUpperCase());
        }
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento();
        if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        } else {
            p.append(complemento.substring(0, 15).toUpperCase());
        }
        String cidade = remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao();
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        } else {
            p.append(cidade.substring(0, 20).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoO(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(tipoMovimento);
        if (titulo.getCodigoDeBarras() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("O Titulo: " + titulo.toString() + " esta sem Codigo de Barras. Favor Informar!");
        }
        p.append(titulo.getCodigoDeBarras());
        String nomeConcessionaria = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeConcessionaria.length() > 30) {
            p.append(nomeConcessionaria.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeConcessionaria, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 68));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoW(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("W");
        p.append("1");
        p.append("1");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 80));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 80));
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCodigoReceitaFederal(), 6));
        if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId())) {
            p.append("02");
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            p.append("01");
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            p.append("04");
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Pessoa da empresa n\u00e3o tratado. Contate o Suporte Tecnico!");
        }
        if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId()) || item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getCodCei(), 14));
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Pessoa da empresa n\u00e3o tratado. Contate o Suporte Tecnico!");
        }
        String identificadorFGTS = ToolString.refina((String)titulo.getIdentificadorFGTS());
        p.append(UtilityArquivoCnab.completarComBrancoDireita(identificadorFGTS, 16));
        String lacreConectividadeSocial = ToolString.refina((String)titulo.getLacreConectividadeSocial());
        if (lacreConectividadeSocial == null || lacreConectividadeSocial.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 11));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(lacreConectividadeSocial, 11));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        n = regSeqRegistroCompl;
        regSeqRegistroCompl = regSeqRegistroCompl + 1;
        p.println();
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

