/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.pagamento._240.ConstantsRetornoCaixaPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoCaixaPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoCaixaPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoCaixa;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoCaixa = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoCaixa = new RetornoPagamentoCnab();
            if (line.substring(7, 8).equals("1")) {
                retornoCaixa.setTipoRegistro("1");
                this.setRetornoPagamentoCaixaHeaderLoteSegJ(retornoCaixa, line);
                this.retornoCNAB240PagamentoCaixa.add(retornoCaixa);
                continue;
            }
            if (line.substring(7, 8).equals("3") && !line.substring(17, 19).equals("52")) {
                if (line.substring(13, 14).equals("J")) {
                    retornoCaixa.setTipoRegistro("3");
                    this.setRetornoPagamentoCaixaDatailSegJ(retornoCaixa, line);
                    this.retornoCNAB240PagamentoCaixa.add(retornoCaixa);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoCaixa.setTipoRegistro("3");
                    this.setRetornoPagamentoCaixaDatailSegA(retornoCaixa, line);
                    this.retornoCNAB240PagamentoCaixa.add(retornoCaixa);
                    continue;
                }
                if (!line.substring(13, 14).equals("O")) continue;
                retornoCaixa.setTipoRegistro("3");
                this.setRetornoPagamentoCaixaDatailSegO(retornoCaixa, line);
                this.retornoCNAB240PagamentoCaixa.add(retornoCaixa);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoCaixa.setTipoRegistro("5");
            this.setRetornoPagamentoCaixaTrailerLoteSegJ(retornoCaixa, line);
            this.retornoCNAB240PagamentoCaixa.add(retornoCaixa);
        }
    }

    private void setRetornoPagamentoCaixaDatailSegJ(RetornoPagamentoCnab retornoPagamentoCaixa, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoCaixa.setNrTitulo(line.substring(182, 188));
        retornoPagamentoCaixa.setNrNossoNumero(line.substring(202, 211));
        retornoPagamentoCaixa.setLoteServico(line.substring(3, 7));
        retornoPagamentoCaixa.setNumeroProtocolo(line.substring(202, 211));
        retornoPagamentoCaixa.setDataOcorrencia(line.substring(144, 152));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoCaixa.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoCaixaHeaderLoteSegJ(RetornoPagamentoCnab retornoPagamentoCaixa, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoCaixa.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoCaixaTrailerLoteSegJ(RetornoPagamentoCnab retornoPagamentoCaixa, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoCaixa.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoCaixa;
    }

    private void setRetornoPagamentoCaixaDatailSegA(RetornoPagamentoCnab retornoCaixa, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoCaixa.setNrTitulo(line.substring(73, 79));
        retornoCaixa.setNrNossoNumero(line.substring(134, 143));
        retornoCaixa.setLoteServico(line.substring(3, 7));
        retornoCaixa.setNumeroProtocolo(line.substring(134, 143));
        retornoCaixa.setDataOcorrencia(line.substring(154, 162));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(162, 175);
        String valorPagoDecimal = line.substring(175, 177);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoCaixa.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoCaixaDatailSegO(RetornoPagamentoCnab retornoPagamentoCaixa, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoCaixa.setNrTitulo(line.substring(122, 142));
        retornoPagamentoCaixa.setNrNossoNumero(line.substring(142, 162));
        retornoPagamentoCaixa.setLoteServico(line.substring(3, 7));
        retornoPagamentoCaixa.setNumeroProtocolo(line.substring(142, 162));
        retornoPagamentoCaixa.setDataOcorrencia(line.substring(99, 107));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixaPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(107, 120);
        String valorPagoDecimal = line.substring(120, 122);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoCaixa.setValorBaixa(valorBaixa);
    }
}

