/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.recebimento._240;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.recebimento.UtilityCaixa;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaCaixaRecebimento240V2
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityCaixa.getFileName(numSequencialRemessa) + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        this.numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("CAIXA ECONOMICA FEDERAL", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaCobranca.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 6));
        p.append("107");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("REMESSA-PRODUCAO", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("1");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_OPERACAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_SERVICO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append("067");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj(), 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_2", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 8));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 33));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessaCobranca, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (!ToolMethods.isStrWithData((String)ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo()))) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessaCobranca.getItemRemessaCobranca()) {
            this.buildDetailSegmentoP(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo()), codificacaoArquivo);
            this.buildDetailSegmentoQ(item, configuracao, ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo()), codificacaoArquivo);
            this.buildDetailSegmentoR(item, configuracao, ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo()), codificacaoArquivo);
            if (!ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("SEGMENTO_S", configuracao), (Object)"1")) continue;
            this.buildDetailSegmentoS(item, configuracao, ToolString.refina((String)remessaCobranca.getTipoRemessa().getCodigo()), codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoP(BorderoTitulos borderoCobranca, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        p.append("P");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoCobranca.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(borderoCobranca.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoCobranca.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(borderoCobranca.getCarteiraCobranca().getCodigoCarteira());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numeroBoleto(p, tipoMovimento, boleto, titulo, UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao)), 15));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_CARTEIRA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("FORMA_CAD_BANCO", configuracao));
        p.append("2");
        p.append(UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("DISTRIBUICAO_BLOQUETO", configuracao));
        p.append(this.numeroDocumento(titulo, tipoNumero, 11));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao));
        if (UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao) != null && ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), (Object)"1") || ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), (Object)"2")) {
            if (titulo.getDataInicioJuros() != null) {
                p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataInicioJuros()));
            } else {
                p.append(UtilityArquivoCnab.formatarDatas8Digitos(ToolDate.nextDays((Date)titulo.getDataVencimento(), (int)1)));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        }
        if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), (Object)"1")) {
            Double valorJurosDia = titulo.getVrJurosDia() / titulo.getValor() * titulo.getValorSaldo();
            if (ToolMethods.isEquals((Object)valorJurosDia, null)) {
                valorJurosDia = 0.0;
            }
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)valorJurosDia, (int)2)), 15));
        } else if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao), (Object)"2")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)titulo.getPercJurosMes(), (int)2)), 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        if (tipoMovimento.equalsIgnoreCase("07") || tipoMovimento.equalsIgnoreCase("08")) {
            p.append("1");
            Date dataDesconto = titulo.getDataLimiteDesconto();
            if (ToolMethods.isEquals((Object)dataDesconto, null)) {
                dataDesconto = titulo.getDataVencimento();
            }
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(dataDesconto));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2)), 15));
        } else {
            p.append(UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao));
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataLimiteDesconto()));
            if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao), (Object)"1")) {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2)), 15));
            } else if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao), (Object)"2")) {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)titulo.getPercDescontoMes(), (int)2)), 15));
            } else {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
            }
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2)), 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2)), 15));
        p.append(this.numeroDocumento(titulo, tipoNumero, 25));
        p.append(UtilityArquivoCnab.getValueByKey("COD_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_BAIXA_DEVOLUCAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_BAIXA_DEVOLUCAO", configuracao));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoQ(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        p.append("Q");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 15));
        if (ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome()).length() > 40) {
            p.append(ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome()).substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome()), 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        if (ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))).length() > 40) {
            p.append(ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))).substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))), 40).toUpperCase());
        }
        if (ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro()).length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro()).substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro()), 15).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        if (ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao()).length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao()).toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao()).toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoR(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        p.append("R");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao));
        if (UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao) != null && ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao), (Object)"1") || ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao), (Object)"2")) {
            if (titulo.getDataAplicacaoMulta() != null) {
                p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataAplicacaoMulta()));
            } else {
                p.append(UtilityArquivoCnab.formatarDatas8Digitos(DateUtil.nextDays(titulo.getDataVencimento(), 1)));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        }
        if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao), (Object)"1")) {
            Double valorMultaFixa = 0.0;
            Double percMulta = titulo.getPercMulta();
            if (percMulta != null && percMulta > 0.0) {
                valorMultaFixa = ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (percMulta / 100.0)), (int)2);
            }
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)valorMultaFixa, (int)2)), 15));
        } else if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao), (Object)"2")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)ContatoFormatUtil.formataNumero((Number)titulo.getPercMulta(), (int)2)), 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_3", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_4", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 50));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoS(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        p.append("S");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO", configuracao));
        if (ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO", configuracao), (Object)"1") || ToolMethods.isEquals((Object)UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO", configuracao), (Object)"2")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 140));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 78));
        } else {
            p.append(this.mensagem5(titulo, 40));
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_6", configuracao), 40));
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_7", configuracao), 40));
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_8", configuracao), 40));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 22));
        }
    }

    private String numeroBoleto(PrintWriter p, String tipoMovimento, BoletoTitulo boleto, Titulo titulo, String emissaoBoleto) throws IOException {
        String numeroBoleto;
        if (ToolMethods.isEquals((Object)tipoMovimento, (Object)"01")) {
            numeroBoleto = boleto.getNumeroTituloInst().toString();
        } else if (!ToolMethods.isEquals((Object)emissaoBoleto, (Object)"1")) {
            numeroBoleto = boleto.getNumeroTituloInst().toString();
        } else {
            numeroBoleto = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
            if (ToolMethods.isStrWithData((String)numeroBoleto)) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
            }
        }
        return numeroBoleto;
    }

    private String numeroDocumento(Titulo titulo, Short tipoNumero, int tamanho) {
        if (ToolMethods.isEquals((Object)tipoNumero, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), tamanho);
            }
            if (titulo.getFaturaCte() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), tamanho);
            }
            if (titulo.getRps() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), tamanho);
            }
            if (titulo.getOrdemCompra() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), tamanho);
            }
            if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), tamanho);
            }
            if (titulo.getPedidoComercio() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), tamanho);
            }
            if (titulo.getAdiantamentoViagem() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), tamanho);
            }
            if (titulo.getNotaContratoLocacao() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), tamanho);
            }
            if (titulo.getContratoLocacao() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), tamanho);
            }
            if (titulo.getApuracaoLocacaoContrato() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), tamanho);
            }
            if (titulo.getCte() != null) {
                return UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), tamanho);
            }
            return UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), tamanho);
        }
        return UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), tamanho);
    }

    private String mensagem5(Titulo titulo, int tamanho) {
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente NF: " + titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString() + " Parc.: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getFaturaCte() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente CTE: " + titulo.getFaturaCte().getIdentificador().toString() + " Parc.: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getRps() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente RPS: " + titulo.getRps().getNumero().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getOrdemCompra() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente OC: " + titulo.getOrdemCompra().getIdentificador().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente PEDIDO: " + titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getPedidoComercio() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente PED.COMER.: " + titulo.getPedidoComercio().getIdentificador().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getAdiantamentoViagem() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente AD.VIAGEM: " + titulo.getAdiantamentoViagem().getIdentificador().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getNotaContratoLocacao() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente NT.CONT.LOCA.: " + titulo.getNotaContratoLocacao().getNumero().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getContratoLocacao() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente CONT.LOCA.: " + titulo.getContratoLocacao().getNumeroContrato().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getApuracaoLocacaoContrato() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente AP.CONT.LOC.: " + titulo.getApuracaoLocacaoContrato().getIdentificador().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        if (titulo.getCte() != null) {
            return UtilityArquivoCnab.completarComBrancoDireita("Referente CTE: " + titulo.getCte().getNumero().toString() + " Parc: " + titulo.getNumParcTituloEstnota().toString() + "/" + titulo.getNumeroParcelas().toString(), tamanho);
        }
        return UtilityArquivoCnab.completarComBrancoDireita("", tamanho);
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = this.numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 31));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 117));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("104");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = this.numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

