/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.recebimento._240;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.caixa.recebimento._240.ConstantsRetornoCaixa240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoCaixaRecebimento240
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoCaixaRecebimento240.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoCaixaRecebimento240CNAB;
    private File arquivo;
    private final String LIQUIDACAO = "06";
    private final String LIQUIDACAO_APOS_BAIXA_OU_TITULO_NAO_REGISTRADO = "17";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCaixaRecebimento240CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(7, 8).equals("3")) continue;
                RetornoRecebimentoCnab retornoCaixa = new RetornoRecebimentoCnab();
                this.setRetornoCaixaDatailSegT(retornoCaixa, line, opcoesFinanceiras);
                ConfiguracaoCnab configuracao = null;
                if (retornoCaixa.getTitulo() != null) {
                    configuracao = retornoCaixa.getTitulo().getConfiguracaoCnab();
                }
                this.setRetornoCaixaDatailSegU(retornoCaixa, this.buffer.readLine(), configuracao);
                this.retornoCaixaRecebimento240CNAB.add(retornoCaixa);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoCaixaDatailSegT(RetornoRecebimentoCnab retornoCaixa, String line, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoCaixa.setNrTitulo(line.substring(58, 69));
        retornoCaixa.setNrNossoNumero(line.substring(41, 56));
        retornoCaixa.setDataVencimentoString(line.substring(73, 81));
        String convenio = ToolString.removerZerosAEsquerda((String)line.substring(23, 29));
        Titulo titulo = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoCaixa.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoCaixa.getNrNossoNumero(), "104", convenio)) != null) {
                titulo = b.getTitulo();
                retornoCaixa.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoCaixa.getNrTitulo());
            if (titulo == null && retornoCaixa.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoCaixa.getNrNossoNumero(), "104", convenio)) != null) {
                titulo = b.getTitulo();
                retornoCaixa.setBoletoTitulo(b);
            }
        }
        ConfiguracaoCnab configuracao = null;
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoCaixa.setTitulo(titulo);
        String codMovRetorno = line.substring(15, 17).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoCaixa.setCodMovRetorno(codMovRetorno);
            retornoCaixa.setDescMovRet(ConstantsRetornoCaixa240.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoCaixa.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoCaixa.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoCaixa.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(213, 215).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoCaixa.setCodOcorrencia1(codOcorrencia1);
            retornoCaixa.setMsgOcorrencia1(ConstantsRetornoCaixa240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(215, 217).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoCaixa.setCodOcorrencia2(codOcorrencia2);
            retornoCaixa.setMsgOcorrencia2(ConstantsRetornoCaixa240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(217, 219).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoCaixa.setCodOcorrencia3(codOcorrencia3);
            retornoCaixa.setMsgOcorrencia3(ConstantsRetornoCaixa240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(219, 221).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoCaixa.setCodOcorrencia4(codOcorrencia4);
            retornoCaixa.setMsgOcorrencia4(ConstantsRetornoCaixa240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(221, 223).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoCaixa.setCodOcorrencia5(codOcorrencia5);
            retornoCaixa.setMsgOcorrencia5(ConstantsRetornoCaixa240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia5));
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteira = line.substring(198, 211);
            String valorTarifaDecimal = line.substring(211, 213);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteira, valorTarifaDecimal);
            retornoCaixa.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoCaixa.setValorTarifaCobranca(0.0);
        }
        String valorTituloInteiro = line.substring(81, 94);
        String valorTituloDecimal = line.substring(94, 96);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoCaixa.setValorTitulo(valorTitulo);
    }

    private void setRetornoCaixaDatailSegU(RetornoRecebimentoCnab retornoCaixa, String line, ConfiguracaoCnab configuracao) {
        retornoCaixa.setDataCredito(line.substring(145, 153));
        retornoCaixa.setDataOcorrencia(line.substring(137, 145));
        retornoCaixa.setDataReferenciaRetorno(line.substring(137, 145));
        retornoCaixa.setDataDebitoTarifa(line.substring(157, 165));
        retornoCaixa.setNrSequencialRegistro(line.substring(8, 13));
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(62, 75);
            String valorIofDecimal = line.substring(75, 77);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoCaixa.setValorIof(valorIof);
        } else {
            retornoCaixa.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(122, 135);
            String valorOutrosCreditosDecimal = line.substring(135, 137);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoCaixa.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoCaixa.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(47, 60);
            String valorAbatimentoDecimal = line.substring(60, 62);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoCaixa.setValorAbatimento(valorAbatimento);
        } else {
            retornoCaixa.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(107, 120);
            String valorOutrasDespesasDecimal = line.substring(120, 122);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retornoCaixa.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retornoCaixa.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(17, 30);
            String valorJurosDecimal = line.substring(30, 32);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoCaixa.setValorJuros(valorJuros);
        } else {
            retornoCaixa.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(32, 45);
            String valorDescontoDecimal = line.substring(45, 47);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoCaixa.setValorDesconto(valorDesconto);
        } else {
            retornoCaixa.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(77, 90);
        String valorBaixaDecimal = line.substring(90, 92);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoCaixa.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoCaixa.setValorMulta(0.0);
        } else {
            retornoCaixa.setValorMulta(0.0);
        }
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoCaixaRecebimento240CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "17": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

