/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.daycovalitau.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.daycovalitau.recebimento._400.ConstantsRetornoDaycoval400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoDaycovalRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoDaycovalRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoDaycovalRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL = "06";
    private final String LIQUIDACAO_CARTORIO = "08";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoDaycovalRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(26, 38));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoDaycoval = new RetornoRecebimentoCnab();
                this.setRetornoDaycovalDetail(retornoDaycoval, line, opcoesFinanceiras, this.convenio);
                this.retornoDaycovalRecebimento400CNAB.add(retornoDaycoval);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoDaycovalDetail(RetornoRecebimentoCnab retornoDaycoval, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        String codMovRetorno;
        retornoDaycoval.setNrTitulo(line.substring(116, 126));
        retornoDaycoval.setNrNossoNumero(line.substring(94, 107));
        retornoDaycoval.setDataVencimentoString(line.substring(146, 152));
        retornoDaycoval.setDataCredito(line.substring(110, 116));
        retornoDaycoval.setDataOcorrencia(line.substring(110, 116));
        retornoDaycoval.setDataReferenciaRetorno(line.substring(110, 116));
        retornoDaycoval.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoDaycoval.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoDaycoval.getNrNossoNumero(), "341", convenio)) != null) {
                titulo = b.getTitulo();
                retornoDaycoval.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoDaycoval.getNrTitulo());
            if (titulo == null && retornoDaycoval.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoDaycoval.getNrNossoNumero(), "341", convenio)) != null) {
                titulo = b.getTitulo();
                retornoDaycoval.setBoletoTitulo(b);
            }
        }
        retornoDaycoval.setTitulo(titulo);
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        if ((codMovRetorno = line.substring(108, 110).trim()) != null && !codMovRetorno.isEmpty()) {
            retornoDaycoval.setCodMovRetorno(codMovRetorno);
            retornoDaycoval.setDescMovRet(ConstantsRetornoDaycoval400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoDaycoval.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoDaycoval.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoDaycoval.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(377, 379).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoDaycoval.setCodOcorrencia1(codOcorrencia1);
            retornoDaycoval.setMsgOcorrencia1(ConstantsRetornoDaycoval400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(379, 381).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoDaycoval.setCodOcorrencia2(codOcorrencia2);
            retornoDaycoval.setMsgOcorrencia2(ConstantsRetornoDaycoval400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(381, 383).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoDaycoval.setCodOcorrencia3(codOcorrencia3);
            retornoDaycoval.setMsgOcorrencia3(ConstantsRetornoDaycoval400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(383, 385).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoDaycoval.setCodOcorrencia4(codOcorrencia4);
            retornoDaycoval.setMsgOcorrencia4(ConstantsRetornoDaycoval400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(175, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoDaycoval.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoDaycoval.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(214, 225);
            String valorIofDecimal = line.substring(225, 227);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoDaycoval.setValorIof(valorIof);
        } else {
            retornoDaycoval.setValorIof(0.0);
        }
        retornoDaycoval.setValorOutrosCreditos(0.0);
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoDaycoval.setValorAbatimento(valorAbatimento);
        } else {
            retornoDaycoval.setValorAbatimento(0.0);
        }
        retornoDaycoval.setValorDespesasBancarias(0.0);
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoDaycoval.setValorJuros(valorJuros);
        } else {
            retornoDaycoval.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoDaycoval.setValorDesconto(valorDesconto);
        } else {
            retornoDaycoval.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoDaycoval.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoDaycoval.setValorMulta(0.0);
        } else {
            retornoDaycoval.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoDaycoval.setValorTitulo(valorTitulo);
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoDaycovalRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "08": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

