/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento._240;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento.UtilityHsbc;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaHsbcRecebimento240
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityHsbc.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append("COB" + UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4) + UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        }
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("HSBC BANK BRASIL SA", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaCobranca.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 6));
        p.append("010");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("ENVIO_CART_COBRANCA_SIMPLES", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        p.append(UtilityArquivoCnab.getValueByKey("LIBERACAO_AUT_PER_DESC", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("1");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_OPERACAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_SERVICO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append("010");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj(), 15));
        p.append("COB" + UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4) + UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        }
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_2", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 8));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 22));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetailSegmentoP(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, codificacaoArquivo);
            this.buildDetailSegmentoQ(item, configuracao, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoP(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("P");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MOVIMENTO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1));
        } else {
            p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta());
        }
        if (borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 20));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_CARTEIRA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("FORMA_CAD_BANCO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_DOCUMENTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("DISTRIBUICAO_BLOQUETO", configuracao));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 15));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 15));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 15));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 15));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 15));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 15));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 15));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 15));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 15));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 15));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 15));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 15));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 15));
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataInicioJuros()));
        String codJurosMora = UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao);
        if (codJurosMora.equals("1")) {
            String valorMoraMes = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
            valorMoraMes = ToolString.refina((String)valorMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMes, 15));
        } else if (codJurosMora.equals("2")) {
            String texaMoraMes = ContatoFormatUtil.formataNumero((Number)titulo.getPercJurosMes(), (int)2);
            texaMoraMes = ToolString.refina((String)texaMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaMoraMes, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        p.append(UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataLimiteDesconto()));
        String codDesconto = UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao);
        if (codDesconto.equals("1") || codDesconto.equals("3")) {
            String valorDescont = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
            valorDescont = ToolString.refina((String)valorDescont);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescont, 15));
        } else if (codDesconto.equals("2")) {
            String texaDesconto = ContatoFormatUtil.formataNumero((Number)titulo.getPercDescontoMes(), (int)2);
            texaDesconto = ToolString.refina((String)texaDesconto);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaDesconto, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIof, 15));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 25));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 25));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 25));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 25));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 25));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 25));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 25));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 25));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 25));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 25));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 25));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
        }
        p.append(UtilityArquivoCnab.getValueByKey("COD_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_BAIXA_DEVOLUCAO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoQ(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("Q");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MOVIMENTO", configuracao));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 15));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 40) {
            p.append(nomeSacado.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))).toUpperCase();
        if (endereco.length() > 38) {
            p.append(endereco.substring(0, 38).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 38).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("399");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(registros.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

