/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento._400;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento.UtilityHsbc;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.boleto.UtilityBoleto;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaHsbcRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityHsbc.getFileName() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append("55");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4) + UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta() + bordero.getCarteiraCobranca().getContaValor().getDvConta(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("399");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("HSBC", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append("01600");
        p.append("BPI");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append("LANCV08");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 277));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetail(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, codificacaoArquivo);
        }
    }

    private void buildDetail(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = new UtilityBoleto().verificarBoletoTituloAtivo(titulo);
        p.append("1");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append("55");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4) + UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta() + borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta(), 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 25));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 25));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 25));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 25));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 25));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 25));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 25));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 25));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 25));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 25));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 25));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 11));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 11));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 11));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_COBRANCA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_OCORRENCIA", configuracao));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 10));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 10));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 10));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 10));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 10));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 10));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 10));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 10));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 10));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 10));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 10));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append("399");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIOF = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIOF = ToolString.refina((String)valorIOF);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIOF, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String erroPagador = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPagador != null && !erroPagador.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPagador);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 40) {
            p.append(titulo.getPessoa().getNome().toUpperCase().substring(0, 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome().toUpperCase(), 40));
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "")));
        if (endereco.length() > 38) {
            p.append(endereco.substring(0, 38).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 38).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_REC_BOLETO", configuracao));
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 12) {
            p.append(bairro.substring(0, 12).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 12).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 39));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_BOLETO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 393));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

