/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.hsbc.recebimento._400.ConstantsRetornoHsbc400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoHsbcRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoHsbcRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoHsbcRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL_DINHEIRO = "06";
    private final String LIQUIDACAO_POR_CONTA_DINHEIRO = "07";
    private final String LIQUIDACAO_POR_CONTA_CHEQUE = "33";
    private final String LIQUIDACAO_CARTORIO_DINHEIRO = "15";
    private final String LIQUIDACAO_CARTORIO_CHEQUE = "32";
    private final String LIQUIDACAO_NORMAL_CHEQUE = "31";
    private final String LIQUIDACAO_TITULO_NAO_REGISTRADO_DINHEIRO = "38";
    private final String LIQUIDACAO_TITULO_NAO_REGISTRADO_CHEQUE = "39";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoHsbcRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(33, 44));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoHsbc = new RetornoRecebimentoCnab();
                this.setRetornoHsbcDatail(retornoHsbc, line, opcoesFinanceiras, this.convenio);
                this.retornoHsbcRecebimento400CNAB.add(retornoHsbc);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoHsbcDatail(RetornoRecebimentoCnab retornoHsbc, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        retornoHsbc.setNrTitulo(line.substring(116, 126));
        retornoHsbc.setNrNossoNumero(line.substring(126, 137));
        retornoHsbc.setDataVencimentoString(line.substring(146, 152));
        retornoHsbc.setDataCredito(line.substring(119, 125));
        retornoHsbc.setDataOcorrencia(line.substring(119, 125));
        retornoHsbc.setDataReferenciaRetorno(line.substring(119, 125));
        retornoHsbc.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoHsbc.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoHsbc.getNrNossoNumero(), "399", convenio)) != null) {
                titulo = b.getTitulo();
                retornoHsbc.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoHsbc.getNrTitulo());
            if (titulo == null && retornoHsbc.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoHsbc.getNrNossoNumero(), "399", convenio)) != null) {
                titulo = b.getTitulo();
                retornoHsbc.setBoletoTitulo(b);
            }
        }
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoHsbc.setTitulo(titulo);
        String codMovRetorno = line.substring(108, 110).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoHsbc.setCodMovRetorno(codMovRetorno);
            retornoHsbc.setDescMovRet(ConstantsRetornoHsbc400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoHsbc.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoHsbc.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoHsbc.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(175, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoHsbc.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoHsbc.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            retornoHsbc.setValorIof(0.0);
        } else {
            retornoHsbc.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            retornoHsbc.setValorOutrosCreditos(0.0);
        } else {
            retornoHsbc.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoHsbc.setValorAbatimento(valorAbatimento);
        } else {
            retornoHsbc.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            retornoHsbc.setValorDespesasBancarias(0.0);
        } else {
            retornoHsbc.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoHsbc.setValorJuros(valorJuros);
        } else {
            retornoHsbc.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoHsbc.setValorDesconto(valorDesconto);
        } else {
            retornoHsbc.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoHsbc.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoHsbc.setValorMulta(0.0);
        } else {
            retornoHsbc.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoHsbc.setValorTitulo(valorTitulo);
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoHsbcRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "31": {
                return Boolean.TRUE;
            }
            case "15": {
                return Boolean.TRUE;
            }
            case "32": {
                return Boolean.TRUE;
            }
            case "07": {
                return Boolean.TRUE;
            }
            case "33": {
                return Boolean.TRUE;
            }
            case "38": {
                return Boolean.TRUE;
            }
            case "39": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

