/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.pagamento._240;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.recebimento.UtilityItau;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaItauPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotal;
    private static Integer numeroTotalLotes;
    private static Integer numeroRegistroArquivo;
    private static Integer qtdeRegistroLote;
    public static final String PAGTO_SALARIO = "HP01";
    public static final String FGTS_GFIP = "11";

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilityItau.getFileName() + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
        numeroTotalLotes = 0;
        numeroRegistroArquivo = 0;
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        qtdeRegistroLote = 0;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotal = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append("080");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO ITAU SA", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 69));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildHeaderPackageSegmentoA(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildHeaderPackageSegmentoJ(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildHeaderPackageSegmentoO(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoN((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildHeaderPackageSegmentoN(remessaPagamento, item, codificacaoArquivo);
        }
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracaoCnab, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessaPagamento.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessaPagamento.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
                if (tipoMovimento.equalsIgnoreCase("000") || tipoMovimento.equalsIgnoreCase("001") || tipoMovimento.equalsIgnoreCase("002")) {
                    this.buildDetailSegmentoA(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                    this.buildDetailSegmentoB(item, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("517")) {
                    this.buildDetailSegmentoATipoMovimento517(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("519")) {
                    this.buildDetailSegmentoATipoMovimento519(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("999")) {
                    this.buildDetailSegmentoATipoMovimento999(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                throw new IOException("Tipo de Movimento n\u00e3o Permitido para este layout. Contate o suporte tecnico!");
            }
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
                if (tipoMovimento.equalsIgnoreCase("000") || tipoMovimento.equalsIgnoreCase("001") || tipoMovimento.equalsIgnoreCase("002")) {
                    this.buildDetailSegmentoJ(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                    this.buildDetailSegmentoJ52(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                    this.buildDetailSegmentoB(item, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("517")) {
                    this.buildDetailSegmentoJTipoMovimento517(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("519")) {
                    this.buildDetailSegmentoJTipoMovimento519(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("999")) {
                    this.buildDetailSegmentoJTipoMovimento999(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                throw new IOException("Tipo de Movimento n\u00e3o Permitido para este layout. Contate o suporte tecnico!");
            }
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
                if (tipoMovimento.equalsIgnoreCase("000") || tipoMovimento.equalsIgnoreCase("001") || tipoMovimento.equalsIgnoreCase("002")) {
                    this.buildDetailSegmentoO(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("517")) {
                    this.buildDetailSegmentoOTipoMovimento517(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("519")) {
                    this.buildDetailSegmentoOTipoMovimento519(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                if (tipoMovimento.equalsIgnoreCase("999")) {
                    this.buildDetailSegmentoOTipoMovimento999(item, tipoMovimento, titulo, codificacaoArquivo);
                    continue;
                }
                throw new IOException("Tipo de Movimento n\u00e3o Permitido para este layout. Contate o suporte tecnico!");
            }
            if (!EnumConstFormaLancamentoCnabPagamento.isSegmentoN((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) continue;
            if (tipoMovimento.equalsIgnoreCase("000") || tipoMovimento.equalsIgnoreCase("001") || tipoMovimento.equalsIgnoreCase("002")) {
                this.buildDetailSegmentoN(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (tipoMovimento.equalsIgnoreCase("517")) {
                this.buildDetailSegmentoNTipoMovimento517(item, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (tipoMovimento.equalsIgnoreCase("519")) {
                this.buildDetailSegmentoNTipoMovimento519(item, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (tipoMovimento.equalsIgnoreCase("999")) {
                this.buildDetailSegmentoNTipoMovimento999(item, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            throw new IOException("Tipo de Movimento n\u00e3o Permitido para este layout. Contate o suporte tecnico!");
        }
    }

    private void buildHeaderPackageSegmentoJ(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        String cidade;
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("030");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        if (ToolMethods.validarFormadoDeIDsInformado((String)enderecoEmpresa.getNumero()).booleanValue()) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        }
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento != null) {
            if (complemento.length() > 15) {
                p.append(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase().substring(0, 15)));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase()), 15));
            }
        }
        if ((cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao())).length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoA(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("030");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        if ((item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("30") || item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("31")) && (item.getItemBordero().getFormaLancamento().getCodigo().equals("01") || item.getItemBordero().getFormaLancamento().getCodigo().equals("60"))) {
            p.append("1707");
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 16));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(titulo.getCodigoDeBarras().substring(0, 3));
        p.append(titulo.getCodigoDeBarras().substring(3, 4));
        p.append(titulo.getCodigoDeBarras().substring(4, 5));
        p.append(titulo.getCodigoDeBarras().substring(5, 9));
        p.append(titulo.getCodigoDeBarras().substring(9, 19));
        p.append(titulo.getCodigoDeBarras().substring(19, 44));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorDescontoAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getVrAbatimento() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDescontoAbatimento = ToolString.refina((String)valorDescontoAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescontoAbatimento, 15));
        String valorMoraMulta = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorMoraMulta = ToolString.refina((String)valorMoraMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMulta, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 13));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ52(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append("52");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomePagador = ToolString.substituiCaractereEspecial((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeBeneficiario = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeBeneficiario.length() > 40) {
            p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 53));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildTrailerPackgeSegmentoO(codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoN((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"341")) {
            this.buildTrailerPackgeSegmentoN(codificacaoArquivo);
        } else {
            this.buildTrailerPackgePadrao(codificacaoArquivo);
        }
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.append("341");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 211));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailSegmentoA(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            p.append("888");
        } else {
            p.append("000");
        }
        String nrBancoFavorecido = item.getItemBordero().getContaBancaria().getInstituicaoValor().getNrBanco();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(nrBancoFavorecido, 3));
        if (nrBancoFavorecido.equalsIgnoreCase("341") || nrBancoFavorecido.equalsIgnoreCase("409")) {
            contaFavorecido = UtilityArquivoCnab.completarComZeroEsquerda("", 1);
            contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getAgencia(), 4);
            contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComBrancoDireita("", 1);
            contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda("", 6);
            if (item.getItemBordero().getContaBancaria().getDac() != null && !item.getItemBordero().getContaBancaria().getDac().isEmpty() && ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).length() == 2) {
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getContaCorrente()), 6);
                contaFavorecido = (String)contaFavorecido + ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).substring(0, 1);
                contaFavorecido = (String)contaFavorecido + ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).substring(1, 2);
                p.append(UtilityArquivoCnab.completarComBrancoDireita((String)contaFavorecido, 20));
            } else {
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getContaCorrente()), 6);
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComBrancoDireita("", 1);
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvContaCorrente()), 1);
                p.append(UtilityArquivoCnab.completarComBrancoDireita((String)contaFavorecido, 20));
            }
        } else {
            contaFavorecido = UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getAgencia(), 5);
            contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComBrancoDireita("", 1);
            contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getContaBancaria().getContaCorrente()), 12);
            if (item.getItemBordero().getContaBancaria().getDac() != null && !item.getItemBordero().getContaBancaria().getDac().isEmpty() && ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).length() == 2) {
                contaFavorecido = (String)contaFavorecido + ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).substring(0, 1);
                contaFavorecido = (String)contaFavorecido + ToolString.refina((String)item.getItemBordero().getContaBancaria().getDac()).substring(1, 2);
                p.append(UtilityArquivoCnab.completarComBrancoDireita((String)contaFavorecido, 20));
            } else {
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComBrancoDireita(ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvAgencia()), 1);
                contaFavorecido = (String)contaFavorecido + UtilityArquivoCnab.completarComBrancoDireita(ToolString.refina((String)item.getItemBordero().getContaBancaria().getDvContaCorrente()), 1);
                p.append(UtilityArquivoCnab.completarComBrancoDireita((String)contaFavorecido, 20));
            }
        }
        String nomeFavorecido = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeFavorecido.length() > 30) {
            p.append(nomeFavorecido.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeFavorecido, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append("009");
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            if (item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb() == null || item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb().isEmpty()) {
                p.close();
                this.getFile().delete();
                throw new IOException("A Institui\u00e7\u00e3o de Valor: " + item.getItemBordero().getContaBancaria().getInstituicaoValor().toString() + " esta sem o C\u00f3digo ISPB. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb(), 8));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        String valorPrevistoPag = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPrevistoPag = ToolString.refina((String)valorPrevistoPag);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPrevistoPag, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        if ((item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("30") || item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("31")) && (item.getItemBordero().getFormaLancamento().getCodigo().equals("01") || item.getItemBordero().getFormaLancamento().getCodigo().equals("60"))) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(PAGTO_SALARIO, 18));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        if (item.getItemBordero().getContaBancaria() != null && item.getItemBordero().getContaBancaria().getCnpj() != null && !item.getItemBordero().getContaBancaria().getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getCnpj(), 14));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03")) {
            if (item.getItemBordero().getFinalidadeDoc() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade DOC. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeDoc().getCodigo(), 2));
        } else if (item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equalsIgnoreCase("30") && item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("01")) {
            p.append("21");
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("41") || item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("43")) {
            if (item.getItemBordero().getFinalidadeTed() == null) {
                p.close();
                this.getFile().delete();
                throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " esta sem a Finalidade TED. Favor informar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeTed().getCodigo(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(ItemRemessaCnabPagamento item, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        if (item.getItemBordero().getContaBancaria() != null && item.getItemBordero().getContaBancaria().getCnpj() != null && !item.getItemBordero().getContaBancaria().getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getContaBancaria().getCnpj()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getCnpj(), 14));
        } else {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getLogradouro());
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (titulo.getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(titulo.getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getComplemento());
        if (complemento == null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento, 15));
        } else {
            p.append(complemento.substring(0, 15));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getBairro());
        if (bairro.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15));
        } else {
            p.append(bairro.substring(0, 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getCidade().getDescricao());
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 2, titulo.getPessoa().getNome()));
        p.append(titulo.getPessoa().getEndereco().getCidade().getUf().getSigla());
        String emailPessoa = titulo.getPessoa().getComplemento().getEmailPrincipal();
        if (emailPessoa == null) {
            emailPessoa = "";
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(emailPessoa, 100));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoO(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("030");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase()));
        } else {
            p.append(ToolString.substituiCaractereEspecial((String)UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase()));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getNumero()), 5));
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento == null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase().substring(0, 15)));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase()), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoO(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(ToolString.refina((String)tipoMovimento));
        if (titulo.getLinhaDigitavel() == null || titulo.getLinhaDigitavel().isEmpty() || titulo.getLinhaDigitavel().length() != 48) {
            p.close();
            this.getFile().delete();
            throw new IOException("O Titulo: " + titulo.toString() + " esta sem a Linha Digitavel ou a mesma esta incorreta. Favor Informar!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getLinhaDigitavel(), 48));
        String nomeConcessionaria = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeConcessionaria.length() > 30) {
            p.append(nomeConcessionaria.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeConcessionaria, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        p.append("REA");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoN(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("030");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase()));
        } else {
            p.append(ToolString.substituiCaractereEspecial((String)UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase()));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getNumero()), 5));
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento == null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase().substring(0, 15)));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)complemento.toUpperCase()), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoN(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("N");
        p.append(tipoMovimento);
        if (!item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("35")) {
            p.close();
            this.getFile().delete();
            throw new IOException("O Tipo de Tributo do T\u00edtulo " + titulo.toString() + " n\u00e3o esta dispon\u00edvel para pagamento");
        }
        this.buildDetailSegmentoNFGTSGRRFComCodigoBarras(p, item, configuracao, titulo);
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgePadrao(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotal, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 171));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgeSegmentoO(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotal, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 174));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoATipoMovimento517(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        String valorPrevistoPag = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPrevistoPag = ToolString.refina((String)valorPrevistoPag);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPrevistoPag, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoATipoMovimento519(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoATipoMovimento999(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJTipoMovimento517(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        String valorPrevistoPag = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPrevistoPag = ToolString.refina((String)valorPrevistoPag);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPrevistoPag, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJTipoMovimento519(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJTipoMovimento999(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoOTipoMovimento517(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(ToolString.refina((String)tipoMovimento));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 48));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoOTipoMovimento519(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(ToolString.refina((String)tipoMovimento));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 48));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoOTipoMovimento999(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(ToolString.refina((String)tipoMovimento));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 48));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + 0.0;
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoNTipoMovimento517(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("N");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 134));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoNTipoMovimento519(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("N");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 126));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoNTipoMovimento999(ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        String nossoNumero = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (nossoNumero == null || nossoNumero.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("N");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 126));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(nossoNumero, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotal = this.valorTotal + item.getItemBordero().getValorPago();
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoNFGTSGRRFComCodigoBarras(PrintWriter p, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, Titulo titulo) throws IOException {
        p.append(FGTS_GFIP);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getCodigoReceitaFederal()), 4));
        String tipoInscricao = UtilityArquivoCnab.getTipoInscricaoCNPJCEIUmDigito(titulo.getEmpresa().getPessoa());
        if (tipoInscricao == null || tipoInscricao.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Incri\u00e7\u00e3o da Empresa emissora " + titulo.toString() + " deve ser CNPJ ou CEI. Favor verificar!");
        }
        p.append(tipoInscricao);
        String ceiCnpj = ToolString.refina((String)UtilityArquivoCnab.getInscricaoCNPJCEIUmDigito(titulo.getEmpresa().getPessoa()));
        if (ceiCnpj == null || ceiCnpj.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("CEI ou CNPJ da Empresa emissora " + titulo.toString() + " n\u00e3o informado. Favor verificar!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ceiCnpj, 14));
        p.append(ToolString.refina((String)titulo.getLinhaDigitavel()));
        String identificadorFGTS = ToolString.refina((String)titulo.getIdentificadorFGTS());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(identificadorFGTS, 16));
        String lacreConectividadeSocial = ToolString.refina((String)titulo.getLacreConectividadeSocial());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(lacreConectividadeSocial, 11));
        String nomeContribuinte = ToolString.substituiCaractereEspecial((String)titulo.getEmpresa().getPessoa().getNome());
        if (nomeContribuinte.length() > 30) {
            p.append(nomeContribuinte.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeContribuinte, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 30));
    }

    private void buildTrailerPackgeSegmentoN(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotal, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 151));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

