/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.pagamento._240.ConstantsRetornoItauPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoItauPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoItauPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoItau;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoItau = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoItau = new RetornoPagamentoCnab();
            if (line.substring(7, 8).equals("1")) {
                retornoItau.setTipoRegistro("1");
                this.setRetornoPagamentoItauHeaderLote(retornoItau, line);
                this.retornoCNAB240PagamentoItau.add(retornoItau);
                continue;
            }
            if (line.substring(7, 8).equals("3")) {
                if (line.substring(13, 14).equals("J") && !line.substring(17, 19).equals("52")) {
                    retornoItau.setTipoRegistro("3");
                    this.setRetornoPagamentoItauDatailSegJ(retornoItau, line);
                    this.retornoCNAB240PagamentoItau.add(retornoItau);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoItau.setTipoRegistro("3");
                    this.setRetornoPagamentoItauDatailSegA(retornoItau, line);
                    this.retornoCNAB240PagamentoItau.add(retornoItau);
                    continue;
                }
                if (line.substring(13, 14).equals("O")) {
                    retornoItau.setTipoRegistro("3");
                    this.setRetornoPagamentoItauDatailSegO(retornoItau, line);
                    this.retornoCNAB240PagamentoItau.add(retornoItau);
                    continue;
                }
                if (!line.substring(13, 14).equals("N")) continue;
                retornoItau.setTipoRegistro("3");
                this.setRetornoPagamentoItauDatailSegN(retornoItau, line);
                this.retornoCNAB240PagamentoItau.add(retornoItau);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoItau.setTipoRegistro("5");
            this.setRetornoPagamentoItauTrailerLote(retornoItau, line);
            this.retornoCNAB240PagamentoItau.add(retornoItau);
        }
    }

    private void setRetornoPagamentoItauDatailSegJ(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setNrTitulo(line.substring(182, 202));
        retornoPagamentoItau.setNrNossoNumero(line.substring(215, 230));
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        retornoPagamentoItau.setNrSequencialRegistro(line.substring(8, 13));
        retornoPagamentoItau.setDataPagamento(line.substring(144, 152));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoItau.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoItau;
    }

    private void setRetornoPagamentoItauHeaderLote(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoItauTrailerLote(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoItauDatailSegA(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setNrTitulo(line.substring(73, 93));
        retornoPagamentoItau.setNrNossoNumero(line.substring(134, 149));
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        retornoPagamentoItau.setNumeroProtocolo(line.substring(134, 149));
        retornoPagamentoItau.setDataPagamento(line.substring(154, 162));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(162, 175);
        String valorPagoDecimal = line.substring(175, 177);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoItau.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoItauDatailSegO(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setNrTitulo(line.substring(174, 194));
        retornoPagamentoItau.setNrNossoNumero(line.substring(215, 230));
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        retornoPagamentoItau.setNumeroProtocolo(line.substring(215, 230));
        retornoPagamentoItau.setDataPagamento(line.substring(136, 144));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(144, 157);
        String valorPagoDecimal = line.substring(157, 159);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoItau.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoItauDatailSegN(RetornoPagamentoCnab retornoPagamentoItau, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoItau.setNrTitulo(line.substring(195, 215));
        retornoPagamentoItau.setNrNossoNumero(line.substring(215, 230));
        retornoPagamentoItau.setLoteServico(line.substring(3, 7));
        retornoPagamentoItau.setNumeroProtocolo(line.substring(215, 230));
        retornoPagamentoItau.setDataPagamento(line.substring(143, 151));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoItau.setMsgOcorrencia1(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoItau.setMsgOcorrencia2(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoItau.setMsgOcorrencia3(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoItau.setMsgOcorrencia4(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoItau.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoItau.setMsgOcorrencia5(ConstantsRetornoItauPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(151, 163);
        String valorPagoDecimal = line.substring(163, 165);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoItau.setValorBaixa(valorBaixa);
    }
}

