/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.recebimento._400;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.recebimento.UtilityItau;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaItauRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilityItau.getFileName() + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        if (bordero.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("341");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO ITAU SA", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 294));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            if (tipoMovimento.equalsIgnoreCase("01")) {
                this.buildDetailTipoRegistro1TipoMovimento01(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
                this.buildDetailTipoRegistro2TipoMovimento01(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, codificacaoArquivo);
                continue;
            }
            if (tipoMovimento.equalsIgnoreCase("02")) {
                this.buildDetailTipoRegistro1TipoMovimento02(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
                continue;
            }
            if (tipoMovimento.equalsIgnoreCase("06")) {
                this.buildDetailTipoRegistroTipoMovimento06(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
                continue;
            }
            throw new IOException("Codigo de Movimento n\u00e3o Permitido para este Banco!");
        }
    }

    private void buildDetailTipoRegistro1TipoMovimento01(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 25));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 25));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 25));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 25));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 25));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 25));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 25));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 25));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 25));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 25));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 25));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 25));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getCodigoCarteira(), 3));
        Object infoAdicionaisBoleto = "";
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            infoAdicionaisBoleto = "NF: " + titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString() + "/" + (titulo.getNumParcTituloEstnota() != null ? titulo.getNumParcTituloEstnota().toString() : "1");
            if (((String)infoAdicionaisBoleto).length() > 21) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(((String)infoAdicionaisBoleto).substring(0, 20), 21));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita((String)infoAdicionaisBoleto, 21));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(borderoTitulos.getCarteiraCobranca().getVariacaoCarteira(), 1));
        p.append(tipoMovimento);
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 10));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 10));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 10));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 10));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 10));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 10));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 10));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 10));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 10));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 10));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 10));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append("341");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)(titulo.getVrJurosDia() / titulo.getValor() * titulo.getValorSaldo()), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIof, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String erroSacado = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroSacado != null && !erroSacado.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroSacado);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 30) {
            p.append(titulo.getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "")));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 12) {
            p.append(bairro.substring(0, 12).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 12).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoCliente.getCep(), 8));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        Date dataMora = null;
        dataMora = titulo.getDataInicioJuros() != null ? titulo.getDataInicioJuros() : DateUtil.nextDays(titulo.getDataVencimento(), 0);
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(dataMora));
        p.append(UtilityArquivoCnab.getValueByKey("PRAZO_P_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 393));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailTipoRegistro2TipoMovimento01(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("2");
        String codMulta = UtilityArquivoCnab.getValueByKey("CODIGO_MULTA", configuracao);
        p.append(codMulta);
        if (codMulta != null && codMulta.equals("1") || codMulta.equals("2")) {
            Date dataAplicacaoMulta = titulo.getDataAplicacaoMulta();
            if (dataAplicacaoMulta == null) {
                dataAplicacaoMulta = DateUtil.nextDays(titulo.getDataVencimento(), 1);
            }
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(dataAplicacaoMulta));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        }
        if (codMulta.equals("1")) {
            Double valorMultaFixa = 0.0;
            Double percMulta = titulo.getPercMulta();
            if (percMulta != null && percMulta > 0.0) {
                valorMultaFixa = ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (percMulta / 100.0)), (int)2);
            }
            String valorMulta = ContatoFormatUtil.formataNumero((Number)valorMultaFixa, (int)2);
            valorMulta = ToolString.refina((String)valorMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMulta, 13));
        } else if (codMulta.equals("2")) {
            String percMulta = ContatoFormatUtil.formataNumero((Number)titulo.getPercMulta(), (int)2);
            percMulta = ToolString.refina((String)percMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(percMulta, 13));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 371));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailTipoRegistro1TipoMovimento02(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        String numeroBoleto = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (numeroBoleto == null || numeroBoleto.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroBoleto, 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getCodigoCarteira(), 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(borderoTitulos.getCarteiraCobranca().getVariacaoCarteira());
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailTipoRegistroTipoMovimento06(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        String numeroBoleto = UtilityArquivoCnab.getNossoNumeroItemRetornoCnab(titulo);
        if (numeroBoleto == null || numeroBoleto.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("O T\u00edtulo " + titulo.toString().toUpperCase() + " n\u00e3o possui Nosso Numero. Certifique se o mesmo j\u00e1 havia sido inserido anteriormente no banco!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroBoleto, 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getCodigoCarteira(), 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 21));
        p.append(borderoTitulos.getCarteiraCobranca().getVariacaoCarteira());
        p.append(ToolString.refina((String)item.getRemessaCobranca().getTipoRemessa().getCodigo()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }
}

