/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.itau.recebimento._400.ConstantsRetornoItau400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoItauRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoItauRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoItauRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO_NORMAL = "06";
    private final String LIQUIDACAO_PARCIAL_COBRANCA_INTELIGENTE = "07";
    private final String LIQUIDACAO_CARTORIO = "08";
    private final String INSTRUCAO_PROTESTO_REIJEITADA = "24";
    private final String ALEGACOES_SACADO = "25";
    private final String INSTRUCOES_CANCELADAS = "57";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoItauRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(23, 28));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoItau = new RetornoRecebimentoCnab();
                this.setRetornoItauDatail(retornoItau, line, opcoesFinanceiras, this.convenio);
                this.retornoItauRecebimento400CNAB.add(retornoItau);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoItauDatail(RetornoRecebimentoCnab retornoItau, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        String codMovRetorno;
        retornoItau.setNrTitulo(line.substring(116, 126));
        retornoItau.setNrNossoNumero(line.substring(126, 134));
        retornoItau.setDataVencimentoString(line.substring(146, 152));
        retornoItau.setDataCredito(line.substring(295, 301));
        retornoItau.setDataOcorrencia(line.substring(110, 116));
        retornoItau.setDataReferenciaRetorno(line.substring(110, 116));
        retornoItau.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoItau.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoItau.getNrNossoNumero(), "341", convenio)) != null) {
                titulo = b.getTitulo();
                retornoItau.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoItau.getNrTitulo());
            if (titulo == null && retornoItau.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoItau.getNrNossoNumero(), "341", convenio)) != null) {
                titulo = b.getTitulo();
                retornoItau.setBoletoTitulo(b);
            }
        }
        retornoItau.setTitulo(titulo);
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        if ((codMovRetorno = line.substring(108, 110).trim()) != null && !codMovRetorno.isEmpty()) {
            retornoItau.setCodMovRetorno(codMovRetorno);
            retornoItau.setDescMovRet(ConstantsRetornoItau400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoItau.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoItau.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoItau.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        if (codMovRetorno.equals("06") || codMovRetorno.equals("07") || codMovRetorno.equals("08")) {
            codOcorrencia1 = line.substring(392, 394).trim();
            if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
                retornoItau.setCodOcorrencia1(codOcorrencia1);
                retornoItau.setMsgOcorrencia1(ConstantsRetornoItau400.getInfoMovRetornoByCodigoLiquidacao(codOcorrencia1));
            }
        } else if (codMovRetorno.equals("24") || codMovRetorno.equals("25") || codMovRetorno.equals("57")) {
            codOcorrencia1 = line.substring(301, 305).trim();
            if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
                String dataAlegacao = line.substring(305, 311);
                String valorInteiro = line.substring(311, 322);
                String valorDecimal = line.substring(322, 324);
                Double valorAlegacao = UtilityArquivoCnab.formatarNumero(valorInteiro, valorDecimal);
                retornoItau.setCodOcorrencia1(codOcorrencia1);
                retornoItau.setMsgOcorrencia1(ConstantsRetornoItau400.getInfoMovRetornoByCodigoComValores(codMovRetorno, codOcorrencia1, dataAlegacao, valorAlegacao.toString()));
            }
        } else {
            String codOcorrencia4;
            String codOcorrencia3;
            String codOcorrencia2;
            codOcorrencia1 = line.substring(377, 379).trim();
            if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
                retornoItau.setCodOcorrencia1(codOcorrencia1);
                retornoItau.setMsgOcorrencia1(ConstantsRetornoItau400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
            }
            if ((codOcorrencia2 = line.substring(379, 381).trim()) != null && !codOcorrencia2.isEmpty()) {
                retornoItau.setCodOcorrencia2(codOcorrencia2);
                retornoItau.setMsgOcorrencia2(ConstantsRetornoItau400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
            }
            if ((codOcorrencia3 = line.substring(381, 383).trim()) != null && !codOcorrencia3.isEmpty()) {
                retornoItau.setCodOcorrencia3(codOcorrencia3);
                retornoItau.setMsgOcorrencia3(ConstantsRetornoItau400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
            }
            if ((codOcorrencia4 = line.substring(383, 385).trim()) != null && !codOcorrencia4.isEmpty()) {
                retornoItau.setCodOcorrencia4(codOcorrencia4);
                retornoItau.setMsgOcorrencia4(ConstantsRetornoItau400.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
            }
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(175, 186);
            String valorTarifaDecimal = line.substring(186, 188);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoItau.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoItau.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(214, 225);
            String valorIofDecimal = line.substring(225, 227);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoItau.setValorIof(valorIof);
        } else {
            retornoItau.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(279, 290);
            String valorOutrosCreditosDecimal = line.substring(290, 292);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoItau.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoItau.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoItau.setValorAbatimento(valorAbatimento);
        } else {
            retornoItau.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(227, 238);
            String valorOutrasDespesasDecimal = line.substring(238, 240);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retornoItau.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retornoItau.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoItau.setValorJuros(valorJuros);
        } else {
            retornoItau.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoItau.setValorDesconto(valorDesconto);
        } else {
            retornoItau.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoItau.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoItau.setValorMulta(0.0);
        } else {
            retornoItau.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoItau.setValorTitulo(valorTitulo);
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoItauRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "08": {
                return Boolean.TRUE;
            }
            case "07": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

