/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.pagamento._400;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.recebimento.UtilitySafra;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSafraPagamento400
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotalPagamento;
    private Double valorTotalCompromisso;
    private Double valorTotalAbatimento;
    private Double valorTotalJurosMulta;

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessa.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("11");
        p.append("PAGTOS FORNECED");
        Object contaEmpresa = ToolString.refina((String)bordero.getCarteiraCobranca().getContaValor().getNrConta());
        contaEmpresa = (String)contaEmpresa + ToolString.refina((String)bordero.getCarteiraCobranca().getContaValor().getDvConta());
        if (contaEmpresa == null || ((String)contaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar o Numero da Conta para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)contaEmpresa, 8));
        p.append("S");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        Object agenciaEmpresa = ToolString.refina((String)bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia());
        agenciaEmpresa = (String)agenciaEmpresa + ToolString.refina((String)bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        if (agenciaEmpresa == null || ((String)agenciaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar \u00e0 Agencia da Conta Banc\u00e1ria para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)agenciaEmpresa, 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        if (bordero.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessa.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessa.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("422");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO SAFRA S/A", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessa.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 284));
        p.append("S");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessa.getNumeroSequenciaArquivo().toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailPagamentoBoleto(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento borderoPagamento = item.getItemBordero().getBorderoPagamento();
        p.append("1");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        Object contaEmpresa = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getNrConta());
        contaEmpresa = (String)contaEmpresa + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getDvConta());
        if (contaEmpresa == null || ((String)contaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar o Numero da Conta para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)contaEmpresa, 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        Object agenciaEmpresa = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia());
        agenciaEmpresa = (String)agenciaEmpresa + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        if (agenciaEmpresa == null || ((String)agenciaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar \u00e0 Agencia da Conta Banc\u00e1ria para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)agenciaEmpresa, 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getNumParcTituloEstnota().toString(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 17));
        p.append("C");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 13));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFormaLancamento().getCodigo(), 3));
        p.append(titulo.getCodigoDeBarras().substring(0, 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        Object agencia = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia());
        agencia = (String)agencia + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)agencia, 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 16));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 39));
        p.append(titulo.getCodigoDeBarras().substring(0, 3));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getVrAbatimento() + titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String nomeFornecedor = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeFornecedor.length() > 30) {
            p.append(nomeFornecedor.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeFornecedor, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(titulo.getCodigoDeBarras());
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 13));
        p.append("Real");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        this.valorTotalPagamento = this.valorTotalPagamento + item.getItemBordero().getValorPago();
        this.valorTotalCompromisso = this.valorTotalCompromisso + titulo.getValor();
        this.valorTotalAbatimento = this.valorTotalAbatimento + titulo.getVrAbatimento();
        this.valorTotalJurosMulta = this.valorTotalJurosMulta + (titulo.getValorMultaEmbutida() + titulo.getValorJurosEmbutido());
        this.valorTotalJurosMulta = 0.0;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailPagamentoTransferencia(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento borderoPagamento = item.getItemBordero().getBorderoPagamento();
        p.append("1");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        Object contaEmpresa = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getNrConta());
        contaEmpresa = (String)contaEmpresa + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getDvConta());
        if (contaEmpresa == null || ((String)contaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar o Numero da Conta para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)contaEmpresa, 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        Object agenciaEmpresa = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia());
        agenciaEmpresa = (String)agenciaEmpresa + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        if (agenciaEmpresa == null || ((String)agenciaEmpresa).isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar \u00e0 Agencia da Conta Banc\u00e1ria para a Empresa!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)agenciaEmpresa, 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getNumParcTituloEstnota().toString(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 16));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append("C");
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 13));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFormaLancamento().getCodigo(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getNrBanco(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getAgencia(), 7));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getContaCorrente(), 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        Object agencia = ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia());
        agencia = (String)agencia + ToolString.refina((String)borderoPagamento.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda((String)agencia, 7));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 16));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getInstituicaoValor().getCodigoIspb(), 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 31));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 16));
        String nomeFornecedor = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeFornecedor.length() > 30) {
            p.append(nomeFornecedor.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeFornecedor, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 54));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(item.getItemBordero().getDataPagamento()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 13));
        p.append("Real");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        this.valorTotalPagamento = this.valorTotalPagamento + item.getItemBordero().getValorPago();
        this.valorTotalCompromisso = this.valorTotalCompromisso + titulo.getValor();
        this.valorTotalAbatimento = this.valorTotalAbatimento + titulo.getVrAbatimento();
        this.valorTotalJurosMulta = this.valorTotalJurosMulta + (titulo.getValorMultaEmbutida() + titulo.getValorJurosEmbutido());
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilitySafra.getFileName() + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetValorTotal() {
        this.valorTotalPagamento = 0.0;
        this.valorTotalCompromisso = 0.0;
        this.valorTotalAbatimento = 0.0;
        this.valorTotalJurosMulta = 0.0;
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracaoCnab, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracaoCnab, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoPagTransferencia((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"422")) {
                this.buildDetailPagamentoTransferencia(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            this.buildDetailPagamentoBoleto(item, configuracaoCnab, tipoMovimento, titulo, codificacaoArquivo);
        }
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 123));
        String valorCompromissos = ContatoFormatUtil.formataNumero((Number)this.valorTotalCompromisso, (int)2);
        valorCompromissos = ToolString.refina((String)valorCompromissos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCompromissos, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 109));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)this.valorTotalAbatimento, (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 82));
        String valorTotalJuros = ContatoFormatUtil.formataNumero((Number)this.valorTotalJurosMulta, (int)2);
        valorTotalJuros = ToolString.refina((String)valorTotalJuros);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalJuros, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        String vlrTotalPagamento = ContatoFormatUtil.formataNumero((Number)this.valorTotalPagamento, (int)2);
        vlrTotalPagamento = ToolString.refina((String)vlrTotalPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(vlrTotalPagamento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

