/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.pagamento._400;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.pagamento._400.ConstantsRetornoPagamentoSafra400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSafraPagamento400
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSafraPagamento400.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoSafraPagamento400;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoSafraPagamento400 = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoItau = new RetornoPagamentoCnab();
            if (!line.substring(0, 1).equals("1")) continue;
            retornoItau.setTipoRegistro("1");
            this.setRetornoPagamentoDatail(retornoItau, line);
            this.retornoSafraPagamento400.add(retornoItau);
        }
    }

    private void setRetornoPagamentoDatail(RetornoPagamentoCnab retornoPagamentoSafra, String line) {
        retornoPagamentoSafra.setNrTitulo(line.substring(80, 90));
        retornoPagamentoSafra.setNrNossoNumero(line.substring(117, 127));
        retornoPagamentoSafra.setNrSequencialRegistro(line.substring(395, 400));
        retornoPagamentoSafra.setDataPagamento(line.substring(91, 99));
        String codOperacao = line.substring(108, 109).trim();
        String codOcorrencia1 = line.substring(109, 111).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoSafra.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoSafra.setMsgOcorrencia1(ConstantsRetornoPagamentoSafra400.getInfoMovConfirmacaoOrRejeicao(codOcorrencia1));
        }
        if (!codOperacao.equalsIgnoreCase("L")) {
            String codOcorrencia5;
            String codOcorrencia4;
            String codOcorrencia3;
            String codOcorrencia2 = line.substring(168, 171).trim();
            if (codOcorrencia2 != null && !codOcorrencia2.isEmpty()) {
                retornoPagamentoSafra.setCodOcorrencia2(codOcorrencia2);
                retornoPagamentoSafra.setMsgOcorrencia2(ConstantsRetornoPagamentoSafra400.getInfoMotivoRejeicaoByCodigo(codOcorrencia2));
            }
            if ((codOcorrencia3 = line.substring(171, 174).trim()) != null && !codOcorrencia3.isEmpty()) {
                retornoPagamentoSafra.setCodOcorrencia3(codOcorrencia3);
                retornoPagamentoSafra.setMsgOcorrencia3(ConstantsRetornoPagamentoSafra400.getInfoMotivoRejeicaoByCodigo(codOcorrencia3));
            }
            if ((codOcorrencia4 = line.substring(174, 177).trim()) != null && !codOcorrencia4.isEmpty()) {
                retornoPagamentoSafra.setCodOcorrencia4(codOcorrencia4);
                retornoPagamentoSafra.setMsgOcorrencia4(ConstantsRetornoPagamentoSafra400.getInfoMotivoRejeicaoByCodigo(codOcorrencia4));
            }
            if ((codOcorrencia5 = line.substring(177, 200).trim()) != null && !codOcorrencia5.isEmpty()) {
                retornoPagamentoSafra.setCodOcorrencia5(codOcorrencia5);
                retornoPagamentoSafra.setMsgOcorrencia5(ConstantsRetornoPagamentoSafra400.getInfoMotivoRejeicaoByCodigo(codOcorrencia5));
            }
        }
        String valorPagoInteiro = line.substring(218, 229);
        String valorPagoDecimal = line.substring(229, 231);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoSafra.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoSafraPagamento400;
    }
}

