/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.recebimento._400;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.safra.recebimento.UtilitySafra;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSafraRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Long numSequencialRemessa;
    private Long qtdTotalTitulos;
    private Double valorTotalTitulos;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilitySafra.getFileName() + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.numSequencialRemessa = numSequencialRemessa;
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        this.qtdTotalTitulos = 0L;
        this.valorTotalTitulos = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRANCA", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 7));
        String agenciaEmpresa = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia();
        String dvAgenciaEmpresa = bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        String contaEmpresa = bordero.getCarteiraCobranca().getContaValor().getNrConta();
        String dvContaEmpresa = bordero.getCarteiraCobranca().getContaValor().getDvConta();
        if (agenciaEmpresa == null || agenciaEmpresa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar \u00e0 Agencia da Conta Banc\u00e1ria para a Empresa!");
        }
        if (agenciaEmpresa.length() > 4) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Agencia da Conta Banc\u00e1ria da Empresa possui mais de 4 d\u00edgitos. Favor verificar!");
        }
        if (dvAgenciaEmpresa == null || dvAgenciaEmpresa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar o DV da Agencia da Conta Banc\u00e1ria para a Empresa!");
        }
        if (dvAgenciaEmpresa.length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("O DV da Agencia da Conta Banc\u00e1ria da Empresa possui mais de 1 d\u00edgitos. Favor verificar!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(agenciaEmpresa + dvAgenciaEmpresa, 5));
        if (contaEmpresa == null || contaEmpresa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar a Conta Corrente para a Empresa!");
        }
        if (contaEmpresa.length() > 8) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta Corrente da Empresa possui mais de 8 digitos. Favor verificar!");
        }
        if (dvContaEmpresa == null || dvContaEmpresa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro deve se cadastrar o DV da Conta Corrente para a Empresa!");
        }
        if (dvContaEmpresa.length() > 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("O DV da Conta Corrente da Empresa possui mais de 1 digito. Favor verificar!");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaEmpresa + dvContaEmpresa, 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        if (bordero.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("422");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("BANCO SAFRA", 11));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 291));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getNumeroSequenciaArquivo().toString(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetailTipoRegistro1(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
            if (!UtilityArquivoCnab.getValueByKey("ENVIO_EMAIL", configuracao).equals("1")) continue;
            this.buildDetailTipoRegistro2(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetailTipoRegistro1(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String agenciaEmpresa = borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia();
        String dvAgenciaEmpresa = borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia();
        String contaEmpresa = borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta();
        String dvContaEmpresa = borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(agenciaEmpresa + dvAgenciaEmpresa, 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaEmpresa + dvContaEmpresa, 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 25));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 9));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_IOF_OP_SEGURO", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("PRAZO_P_PROTESTO", configuracao));
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira() == null || borderoTitulos.getCarteiraCobranca().getCodigoCarteira().isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro informe o C\u00f3digo da Carteira de Cobran\u00e7a!");
        }
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("O C\u00f3digo da Carteira de Cobran\u00e7a deve possuir somente 1 caracter!");
        }
        p.append(borderoTitulos.getCarteiraCobranca().getCodigoCarteira());
        p.append(tipoMovimento);
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 10));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 10));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 10));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 10));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 10));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 10));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 10));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 10));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 10));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 10));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 10));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        p.append("422");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIof, 13));
        if (UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao).equals("16")) {
            Date dataMulta = null;
            dataMulta = titulo.getDataAplicacaoMulta() != null ? titulo.getDataAplicacaoMulta() : DateUtil.nextDays(titulo.getDataVencimento(), 1);
            p.append(UtilityArquivoCnab.formatarDatas6Digitos(dataMulta));
            String percMulta = ContatoFormatUtil.formataNumero((Number)titulo.getPercMulta(), (int)2);
            percMulta = ToolString.refina((String)percMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(percMulta, 4));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        } else {
            String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
            valorAbatimento = ToolString.refina((String)valorAbatimento);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        }
        String erroPessoaPagador = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getEmpresa().getPessoa());
        if (erroPessoaPagador != null && !erroPessoaPagador.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoaPagador);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 40) {
            p.append(titulo.getPessoa().getNome().substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome(), 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "")));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 10) {
            p.append(bairro.substring(0, 10).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 10).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoCliente.getCep(), 8));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 7));
        p.append("422");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numSequencialRemessa.toString(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Number number = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        this.valorTotalTitulos = valorBoleto + this.valorTotalTitulos;
        number = this.qtdTotalTitulos;
        this.qtdTotalTitulos = this.qtdTotalTitulos + 1L;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 367));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.qtdTotalTitulos.toString(), 8));
        String vlrTotalTitulos = ContatoFormatUtil.formataNumero((Number)this.valorTotalTitulos, (int)2);
        vlrTotalTitulos = ToolString.refina((String)vlrTotalTitulos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(vlrTotalTitulos, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numSequencialRemessa.toString(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailTipoRegistro2(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("2");
        String emailPagador = titulo.getPessoa().getComplemento().getEmailPrincipal();
        if (emailPagador != null && !emailPagador.isEmpty()) {
            if (emailPagador.length() > 50) {
                p.close();
                this.getFile().delete();
                throw new IOException("A pessoa " + titulo.getPessoa().toString() + " possui um email com mais de 50 caracteres, sobrepondo o m\u00e1ximo permitido. Verifique esta situa\u00e7\u00e3o!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("A pessoa " + titulo.getIdentificador().toString() + " - " + titulo.getPessoa().getNome() + " do T\u00edtulo " + titulo.getIdentificador().toString() + " n\u00e3o possui email. Verifique esta situa\u00e7\u00e3o!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(emailPagador, 50));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 100));
        String nomeBeneficiario = titulo.getEmpresa().getPessoa().getNome();
        if (nomeBeneficiario != null && !nomeBeneficiario.isEmpty()) {
            if (nomeBeneficiario.length() > 40) {
                p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40));
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Empresa esta sem Nome. Favor Verificar!");
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        Endereco enderecoEmpresa = titulo.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String enderecoBeneficiario = ToolString.substituiCaractereEspecial((String)(enderecoEmpresa.getLogradouro() + " " + enderecoEmpresa.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoEmpresa.getComplemento()) ? enderecoEmpresa.getComplemento() : "")));
        if (enderecoBeneficiario.length() > 40) {
            p.append(enderecoBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoBeneficiario, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15).toUpperCase());
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getCep(), 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 100));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.numSequencialRemessa.toString(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }
}

