/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.pagamento._240;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstFormaLancamentoCnabPagamento;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.BorderoPagamento;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemBorderoPagamento;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.RemessaCnabPagamento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.exceptions.ExceptionValidation;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento.UtilitySantander;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSantanderPagamento240
implements RemessaPagamentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotalPago;
    private static Integer numeroTotalLotes;
    private static Integer numeroRegistroArquivo;
    private static Integer qtdeRegistroLote;

    @Override
    public void dataValidationBeforeGetStarted(RemessaCnabPagamento remessaPagamento) throws ExceptionValidation {
    }

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa) throws IOException {
        this.arquivo = new File(file, UtilitySantander.getFileNameCnabPagamento() + ".REM");
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
        numeroRegistroArquivo = 0;
        numeroTotalLotes = 0;
        qtdeRegistroLote = 0;
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
        qtdeRegistroLote = 0;
    }

    @Override
    public void resetValorTotal() {
        this.valorTotalPago = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabPagamento remessaPagamento, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoPagamento bordero = ((ItemRemessaCnabPagamento)remessaPagamento.getItemRemessaPagamento().get(0)).getItemBordero().getBorderoPagamento();
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o n\u00famero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        if (bordero.getCarteiraCobranca().getContaValor().getNrConta() == null) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (bordero.getCarteiraCobranca().getContaValor().getDvConta() == null || bordero.getCarteiraCobranca().getContaValor().getDvConta().length() != 1) {
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("SANTANDER", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaPagamento.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaPagamento.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getNumeroSequenciaArquivo().toString(), 6));
        p.append("060");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 19));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildHeaderPackageSegmentoA(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildHeaderPackageSegmentoJ(remessaPagamento, item, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildHeaderPackageSegmentoO(remessaPagamento, item, codificacaoArquivo);
        }
    }

    @Override
    public void buildDetail(RemessaCnabPagamento remessa, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabPagamento item : remessa.getItemRemessaPagamento()) {
            Titulo titulo = this.getTituloItemBordero(item.getItemBordero());
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
                this.buildDetailSegmentoA(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoB(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
                this.buildDetailSegmentoJ(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
                this.buildDetailSegmentoJ52(item, configuracao, titulo, codificacaoArquivo);
                continue;
            }
            if (!EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) continue;
            this.buildDetailSegmentoO(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
            if (!item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo().equals("22")) {
                this.buildDetailSegmentoB(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
                continue;
            }
            if (!titulo.getCodigoDeBarras().isEmpty() && titulo.getCodigoDeBarras().length() > 3 && titulo.getCodigoDeBarras().substring(0, 3).equals("858")) {
                this.buildDetailSegmentoW(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
            }
            this.buildDetailSegmentoB(configuracao, item, tipoMovimento, titulo, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoA(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoRemessa, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("A");
        p.append(tipoRemessa);
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("01")) {
            p.append("000");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03") && item.getItemBordero().getFormaLancamento().getDescricao().contains("DOC")) {
            p.append("700");
        } else if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03") && item.getItemBordero().getFormaLancamento().getDescricao().contains("CIP")) {
            p.append("018");
        } else {
            p.append("810");
        }
        ContaSalarioColaborador contaBancaria = item.getItemBordero().getContaBancaria();
        if (contaBancaria == null || contaBancaria.getInstituicaoValor() == null) {
            throw new IOException("Informe a conta banc\u00e1ria ou verifique a forma de pagamento para o t\u00edtulo: " + titulo.getIdentificador());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaBancaria.getInstituicaoValor().getNrBanco(), 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getAgencia()), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getDvAgencia()), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getContaCorrente()), 12));
        if (contaBancaria.getDvContaCorrente().length() <= 1) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getDvContaCorrente()), 1));
        } else if (contaBancaria.getDvContaCorrente().length() > 1) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getDvContaCorrente().substring(0, 1)), 1));
        }
        if (contaBancaria.getDvContaCorrente().length() == 2) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getDvContaCorrente().substring(1, 2)), 1));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.substituirLetrasPorZero(contaBancaria.getDac()), 1));
        }
        String nomePessoa = titulo.getPessoa().getNome();
        if (nomePessoa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePessoa, 30));
        } else {
            p.append(nomePessoa.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        p.append("BRL");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        String informarDataPagamento = UtilityArquivoCnab.getValueByKey("INFORMAR_DATA_PAGAMENTO", configuracao);
        if (ToolMethods.isStrWithData((String)informarDataPagamento)) {
            Short informarDtPagamento = Short.valueOf(informarDataPagamento);
            if (ToolMethods.isEquals((Object)informarDtPagamento, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
            } else {
                p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03") && item.getItemBordero().getFormaLancamento().getDescricao().contains("DOC")) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeDoc().getCodigo(), 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03") && item.getItemBordero().getFormaLancamento().getDescricao().contains("TED")) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getFinalidadeTed().getCodigo(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 5));
        }
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("03") && item.getItemBordero().getFormaLancamento().getDescricao().contains("TED")) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("CC", 2));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoB(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoRemessa, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        ContaSalarioColaborador contaBancaria = item.getItemBordero().getContaBancaria();
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("B");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 3));
        if (item.getItemBordero().getContaBancaria() != null && item.getItemBordero().getContaBancaria().getCnpj() != null && !item.getItemBordero().getContaBancaria().getCnpj().isEmpty()) {
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getContaBancaria().getCnpj()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getContaBancaria().getCnpj(), 14));
        } else {
            if (titulo.getPessoa().getComplemento().getCnpj() == null && titulo.getPessoa().getComplemento().getCnpj().isEmpty()) {
                throw new IOException("CPF ou CNPJ \u00e9 obrigatorio para a Pessoa do Titulo para esta Opera\u00e7\u00e3o.");
            }
            p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        }
        String logradouro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getLogradouro());
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (titulo.getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(titulo.getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = titulo.getPessoa().getEndereco().getComplemento();
        if (complemento == null || complemento.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getComplemento()), 15));
        } else {
            p.append(ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getComplemento()).substring(0, 15));
        }
        String bairro = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getBairro());
        if (bairro.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15));
        } else {
            p.append(bairro.substring(0, 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getEndereco().getCidade().getDescricao());
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(titulo.getPessoa().getEndereco().getCep(), 2, titulo.getPessoa().getNome()));
        p.append(titulo.getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorNominal = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorNominal = ToolString.refina((String)valorNominal);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorNominal, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)titulo.getDescontoFinanceiro(), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 11));
        if (item.getItemBordero().getFormaLancamento().getCodigo().equalsIgnoreCase("01")) {
            p.append("02007");
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        } else {
            p.append("0200");
            p.append(UtilityArquivoCnab.getValueByKey("AVISO_FAVORECIDO", configuracao));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
            if (titulo.getTipoPessoa() == EnumConstPessoa.AGENCIA_VALOR.getEnumId()) {
                if (contaBancaria.getInstituicaoValor().getCodigoIspb() == null || contaBancaria.getInstituicaoValor().getCodigoIspb().isEmpty()) {
                    throw new IOException("Nenhum codigo ISBP foi encontrado para a Institui\u00e7\u00e3o de Valor de Destino. Contate o suporte tecnico!");
                }
                p.append("S");
                p.append(UtilityArquivoCnab.completarComBrancoDireita(contaBancaria.getInstituicaoValor().getCodigoIspb(), 10));
            } else {
                p.append("N");
                p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
            }
        }
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackge(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        if (EnumConstFormaLancamentoCnabPagamento.isSegmentoA((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildTrailerPackgeSegmentoA(remessaPagamento, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoJ((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildTrailerPackgeSegmentoJ(remessaPagamento, codificacaoArquivo);
        } else if (EnumConstFormaLancamentoCnabPagamento.isSegmentoO((EnumConstFormaLancamentoCnabPagamento)EnumConstFormaLancamentoCnabPagamento.valueOfFormaLancamento((String)item.getItemBordero().getFormaLancamento().getCodigo()), (String)"033")) {
            this.buildTrailerPackgeSegmentoO(codificacaoArquivo);
        }
    }

    @Override
    public void buildTrailerFile(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.append("033");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroRegistroArquivo.toString(), 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 211));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildHeaderPackageSegmentoA(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("031");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento() != null) {
            if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o numero do Conv\u00eanio de Pagamento");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o n\u00famero da Ag\u00eancia. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem o N\u00famero da Conta. ");
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        String dvContaCorrente = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta();
        if (dvContaCorrente != null && !dvContaCorrente.isEmpty() && dvContaCorrente.length() == 2) {
            p.append(dvContaCorrente.substring(0, 1));
        } else if (dvContaCorrente != null && !dvContaCorrente.isEmpty() && dvContaCorrente.length() == 1) {
            p.append(dvContaCorrente);
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("A Conta utilizada pela Empresa est\u00e1 sem d\u00edgito ou o d\u00edgito informado cont\u00e9m mais de um caractere. ");
        }
        if (dvContaCorrente != null && !dvContaCorrente.isEmpty() && dvContaCorrente.length() == 2) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(dvContaCorrente.substring(1, 2), 1));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        }
        String nomeEmpresa = ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome());
        if (nomeEmpresa.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeEmpresa, 30));
        } else {
            p.append(nomeEmpresa.substring(0, 30));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        String logradouro = ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getEndereco().getLogradouro());
        if (logradouro.length() <= 30) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(logradouro, 30));
        } else {
            p.append(logradouro.substring(0, 30));
        }
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().length() <= 5) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero(), 5));
        } else {
            p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getNumero().substring(0, 5));
        }
        String complemento = "";
        if (remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento() != null) {
            complemento = remessaPagamento.getEmpresa().getPessoa().getEndereco().getComplemento();
        }
        if (complemento.length() <= 15) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento, 15));
        } else {
            p.append(complemento.substring(0, 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        if (cidade.length() <= 20) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade, 20));
        } else {
            p.append(cidade.substring(0, 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(remessaPagamento.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoJ(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("030");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o n\u00famero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(enderecoEmpresa.getNumero(), 5));
        String complemento = enderecoEmpresa.getComplemento();
        if (complemento == null || complemento.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 15));
        } else if (complemento.length() > 15) {
            p.append(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento()).toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento()).toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgeSegmentoA(RemessaCnabPagamento remessaPagamento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(tipoMovimento);
        p.append(titulo.getCodigoDeBarras());
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 30) {
            p.append(nomeSacado.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)titulo.getValor(), (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 15));
        String valorDescontoAbatimento = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getVrAbatimento()), (int)2);
        valorDescontoAbatimento = ToolString.refina((String)valorDescontoAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescontoAbatimento, 15));
        String valorMoraMulta = ContatoFormatUtil.formataNumero((Number)(titulo.getValorJurosEmbutido() + titulo.getValorMultaEmbutida()), (int)2);
        valorMoraMulta = ToolString.refina((String)valorMoraMulta);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMulta, 15));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append("09");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoJ52(ItemRemessaCnabPagamento item, ConfiguracaoCnab configuracao, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("J");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append("52");
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomePagador = ToolString.substituiCaractereEspecial((String)item.getItemBordero().getBorderoPagamento().getEmpresa().getPessoa().getNome());
        if (nomePagador.length() > 40) {
            p.append(nomePagador.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomePagador, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeBeneficiario = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeBeneficiario.length() > 40) {
            p.append(nomeBeneficiario.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeBeneficiario, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 15));
        String nomeSacadorAvalista = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacadorAvalista.length() > 40) {
            p.append(nomeSacadorAvalista.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacadorAvalista, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 53));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildHeaderPackageSegmentoO(RemessaCnabPagamento remessaPagamento, ItemRemessaCnabPagamento item, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = numeroTotalLotes;
        numeroTotalLotes = numeroTotalLotes + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("1");
        p.append("C");
        p.append(item.getItemBordero().getFormaLancamento().getTipoServico().getCodigo());
        p.append(item.getItemBordero().getFormaLancamento().getCodigo());
        p.append("010");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(remessaPagamento.getEmpresa().getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaPagamento.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaPagamento.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        String convenioPagamento = item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento();
        if (convenioPagamento != null && !convenioPagamento.isEmpty()) {
            if (convenioPagamento.length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException("O Codigo de Conv\u00eanio de Pagamento excede a quantidade permitida no layout de 20 caracteres!");
            }
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("No cadastro da Agencia Valores est\u00e1 faltando informar o n\u00famero do Conv\u00eanio de Pagamento!");
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNumeroConvenioPagamento(), 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia(), 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getNrConta(), 12));
        if (item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta() != null && !item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().isEmpty() && item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().length() == 2) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().substring(0, 1), 1));
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta().substring(1, 2), 1));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getDvConta(), 1));
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getItemBordero().getBorderoPagamento().getCarteiraCobranca().getContaValor().getCodigoDac(), 1));
        }
        if (remessaPagamento.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(ToolString.substituiCaractereEspecial((String)remessaPagamento.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase()));
        } else {
            p.append(ToolString.substituiCaractereEspecial((String)UtilityArquivoCnab.completarComBrancoDireita(remessaPagamento.getEmpresa().getPessoa().getNome(), 30).toUpperCase()));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        Endereco enderecoEmpresa = remessaPagamento.getEmpresa().getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoEmpresa, remessaPagamento.getEmpresa().getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getLogradouro().toUpperCase());
        if (endereco.length() > 30) {
            p.append(endereco.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getNumero()), 5));
        String complemento = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getComplemento());
        if (complemento.length() > 15) {
            p.append(complemento.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(complemento.toUpperCase(), 15));
        }
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoEmpresa.getCidade().getDescricao());
        if (cidade.length() > 20) {
            p.append(cidade.toUpperCase().substring(0, 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 20));
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 1, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoEmpresa.getCep(), 2, remessaPagamento.getEmpresa().getPessoa().getNome()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoEmpresa.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n2 = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgeSegmentoJ(RemessaCnabPagamento remessaPagamento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 18));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 165));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoO(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("O");
        p.append(tipoMovimento);
        if (titulo.getCodigoDeBarras() == null) {
            p.close();
            this.getFile().delete();
            throw new IOException("O Titulo: " + titulo.toString() + " esta sem Codigo de Barras. Favor Informar!");
        }
        p.append(titulo.getCodigoDeBarras());
        String nomeConcessionaria = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeConcessionaria.length() > 30) {
            p.append(nomeConcessionaria.substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeConcessionaria, 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(item.getItemBordero().getDataPagamento()));
        String valorPagamento = ContatoFormatUtil.formataNumero((Number)item.getItemBordero().getValorPago(), (int)2);
        valorPagamento = ToolString.refina((String)valorPagamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorPagamento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 68));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildTrailerPackgeSegmentoO(String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Integer n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(qtdeRegistroLote.toString(), 6));
        String valorTotalPagtos = ContatoFormatUtil.formataNumero((Number)this.valorTotalPago, (int)2);
        valorTotalPagtos = ToolString.refina((String)valorTotalPagtos);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalPagtos, 18));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 189));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        Integer n2 = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoW(ConfiguracaoCnab configuracao, ItemRemessaCnabPagamento item, String tipoMovimento, Titulo titulo, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("033");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroTotalLotes.toString(), 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 5));
        p.append("W");
        p.append("1");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 80));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 80));
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCodigoReceitaFederal(), 6));
        if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId())) {
            p.append("02");
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            p.append("01");
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            p.append("04");
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Pessoa da empresa n\u00e3o tratado. Contate o Suporte Tecnico!");
        }
        if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.FISICA.getEnumId()) || item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.JURIDICA.getEnumId())) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getCnpj(), 14));
        } else if (item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getTipoPessoa().equals(EnumConstTipoPessoaComplementar.CEI.getEnumId())) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getRemessaPagamento().getEmpresa().getPessoa().getComplemento().getCodCei(), 14));
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Pessoa da empresa n\u00e3o tratado. Contate o Suporte Tecnico!");
        }
        String identificadorFGTS = ToolString.refina((String)titulo.getIdentificadorFGTS());
        p.append(UtilityArquivoCnab.completarComBrancoDireita(identificadorFGTS, 16));
        String lacreConectividadeSocial = ToolString.refina((String)titulo.getLacreConectividadeSocial());
        if (lacreConectividadeSocial == null || lacreConectividadeSocial.isEmpty()) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 11));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(lacreConectividadeSocial, 11));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        this.valorTotalPago = this.valorTotalPago + item.getItemBordero().getValorPago();
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        n = numeroRegistroArquivo;
        numeroRegistroArquivo = numeroRegistroArquivo + 1;
        n = qtdeRegistroLote;
        qtdeRegistroLote = qtdeRegistroLote + 1;
        p.println();
        p.flush();
        p.close();
    }

    private Titulo getTituloItemBordero(ItemBorderoPagamento itemBordero) {
        if (itemBordero.getItemLiberacao() != null) {
            return itemBordero.getItemLiberacao().getTitulo();
        }
        return itemBordero.getTitulo();
    }
}

