/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.pagamento._240.ConstantsRetornoSantanderPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSantanderPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSantanderPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoBancoSantander;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoBancoSantander = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoBancoSantander = new RetornoPagamentoCnab();
            if (line.substring(7, 8).equals("1")) {
                retornoBancoSantander.setTipoRegistro("1");
                this.setRetornoPagamentoBancoSantanderHeaderLote(retornoBancoSantander, line);
                this.retornoCNAB240PagamentoBancoSantander.add(retornoBancoSantander);
                continue;
            }
            if (line.substring(7, 8).equals("3")) {
                if (line.substring(13, 14).equals("J") && !line.substring(17, 19).equals("52")) {
                    retornoBancoSantander.setTipoRegistro("3");
                    this.setRetornoBancoSantanderDatailSegJ(retornoBancoSantander, line);
                    this.retornoCNAB240PagamentoBancoSantander.add(retornoBancoSantander);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoBancoSantander.setTipoRegistro("3");
                    this.setRetornoBancoSantanderDatailSegA(retornoBancoSantander, line);
                    this.retornoCNAB240PagamentoBancoSantander.add(retornoBancoSantander);
                    continue;
                }
                if (!line.substring(13, 14).equals("O")) continue;
                retornoBancoSantander.setTipoRegistro("3");
                this.setRetornoBancoSantanderDatailSegO(retornoBancoSantander, line);
                this.retornoCNAB240PagamentoBancoSantander.add(retornoBancoSantander);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoBancoSantander.setTipoRegistro("5");
            this.setRetornoPagamentoBancoSantanderTrailerLote(retornoBancoSantander, line);
            this.retornoCNAB240PagamentoBancoSantander.add(retornoBancoSantander);
        }
    }

    private void setRetornoBancoSantanderDatailSegJ(RetornoPagamentoCnab retornoSantander, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setNrTitulo(line.substring(182, 202));
        retornoSantander.setNrNossoNumero(line.substring(202, 222));
        retornoSantander.setLoteServico(line.substring(3, 7));
        retornoSantander.setDataPagamento(line.substring(144, 152));
        retornoSantander.setNumeroProtocolo(line.substring(202, 222));
        retornoSantander.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoSantander.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoBancoSantander;
    }

    private void setRetornoPagamentoBancoSantanderHeaderLote(RetornoPagamentoCnab retornoSantander, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoBancoSantanderTrailerLote(RetornoPagamentoCnab retornoSantander, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoBancoSantanderDatailSegA(RetornoPagamentoCnab retornoSantander, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setNrTitulo(line.substring(73, 93));
        retornoSantander.setNrNossoNumero(line.substring(134, 154));
        retornoSantander.setLoteServico(line.substring(3, 7));
        retornoSantander.setDataPagamento(line.substring(154, 162));
        retornoSantander.setNumeroProtocolo(line.substring(134, 154));
        retornoSantander.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(162, 175);
        String valorPagoDecimal = line.substring(175, 177);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoSantander.setValorBaixa(valorBaixa);
    }

    private void setRetornoBancoSantanderDatailSegO(RetornoPagamentoCnab retornoSantander, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setNrTitulo(line.substring(122, 142));
        retornoSantander.setNrNossoNumero(line.substring(142, 162));
        retornoSantander.setLoteServico(line.substring(3, 7));
        retornoSantander.setDataPagamento(line.substring(99, 107));
        retornoSantander.setNumeroProtocolo(line.substring(142, 162));
        retornoSantander.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantanderPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(107, 120);
        String valorPagoDecimal = line.substring(120, 122);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoSantander.setValorBaixa(valorBaixa);
    }
}

