/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento._240;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento._240.ConstantsRetornoSantander240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSantanderRecebimento240
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSantanderRecebimento240.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoSantanderRecebimento240CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO = "06";
    private final String LIQUIDACAO_APOS_BAIXA_OU_TITULO_NAO_REGISTRADO = "17";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoSantanderRecebimento240CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(52, 61));
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(7, 8).equals("3")) continue;
                RetornoRecebimentoCnab retornoSantander = new RetornoRecebimentoCnab();
                this.setRetornoSantanderDatailSegT(retornoSantander, line, opcoesFinanceiras, this.convenio);
                ConfiguracaoCnab configuracao = null;
                if (retornoSantander.getTitulo() != null) {
                    configuracao = retornoSantander.getTitulo().getConfiguracaoCnab();
                }
                this.setRetornoSantanderDatailSegU(retornoSantander, this.buffer.readLine(), configuracao);
                this.retornoSantanderRecebimento240CNAB.add(retornoSantander);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoSantanderDatailSegT(RetornoRecebimentoCnab retornoSantander, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSantander.setNrTitulo(line.substring(54, 69));
        retornoSantander.setNrNossoNumero(line.substring(40, 52));
        retornoSantander.setDvNossoNumero(line.substring(52, 53));
        retornoSantander.setDataVencimentoString(line.substring(69, 77));
        Titulo titulo = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoSantander.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSantander.getNrNossoNumero(), "033", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSantander.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoSantander.getNrTitulo());
            if (titulo == null && retornoSantander.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSantander.getNrNossoNumero(), "033", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSantander.setBoletoTitulo(b);
            }
        }
        ConfiguracaoCnab configuracao = null;
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoSantander.setTitulo(titulo);
        String codMovRetorno = line.substring(15, 17).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoSantander.setCodMovRetorno(codMovRetorno);
            retornoSantander.setDescMovRet(ConstantsRetornoSantander240.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoSantander.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoSantander.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoSantander.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        String codOcorrencia1 = line.substring(208, 210).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSantander.setCodOcorrencia1(codOcorrencia1);
            retornoSantander.setMsgOcorrencia1(ConstantsRetornoSantander240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(210, 212).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSantander.setCodOcorrencia2(codOcorrencia2);
            retornoSantander.setMsgOcorrencia2(ConstantsRetornoSantander240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(212, 214).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSantander.setCodOcorrencia3(codOcorrencia3);
            retornoSantander.setMsgOcorrencia3(ConstantsRetornoSantander240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(214, 216).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSantander.setCodOcorrencia4(codOcorrencia4);
            retornoSantander.setMsgOcorrencia4(ConstantsRetornoSantander240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(216, 218).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSantander.setCodOcorrencia5(codOcorrencia5);
            retornoSantander.setMsgOcorrencia5(ConstantsRetornoSantander240.getInfoMotivoOcorrenciaByCodigo(codMovRetorno, codOcorrencia5));
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(193, 206);
            String valorTarifaDecimal = line.substring(206, 208);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoSantander.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoSantander.setValorTarifaCobranca(0.0);
        }
        String valorTituloInteiro = line.substring(77, 90);
        String valorTituloDecimal = line.substring(90, 92);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoSantander.setValorTitulo(valorTitulo);
    }

    private void setRetornoSantanderDatailSegU(RetornoRecebimentoCnab retornoSantander, String line, ConfiguracaoCnab configuracao) {
        retornoSantander.setDataCredito(line.substring(145, 153));
        retornoSantander.setDataOcorrencia(line.substring(137, 145));
        retornoSantander.setDataReferenciaRetorno(line.substring(137, 145));
        retornoSantander.setNrSequencialRegistro(line.substring(8, 13));
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(62, 75);
            String valorIofDecimal = line.substring(75, 77);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoSantander.setValorIof(valorIof);
        } else {
            retornoSantander.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(122, 135);
            String valorOutrosCreditosDecimal = line.substring(135, 137);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoSantander.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoSantander.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(47, 60);
            String valorAbatimentoDecimal = line.substring(60, 62);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoSantander.setValorAbatimento(valorAbatimento);
        } else {
            retornoSantander.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(107, 120);
            String valorOutrasDespesasDecimal = line.substring(120, 122);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retornoSantander.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retornoSantander.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(17, 30);
            String valorJurosDecimal = line.substring(30, 32);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoSantander.setValorJuros(valorJuros);
        } else {
            retornoSantander.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(32, 45);
            String valorDescontoDecimal = line.substring(45, 47);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoSantander.setValorDesconto(valorDesconto);
        } else {
            retornoSantander.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(77, 90);
        String valorBaixaDecimal = line.substring(90, 92);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoSantander.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoSantander.setValorMulta(0.0);
        } else {
            retornoSantander.setValorMulta(0.0);
        }
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoSantanderRecebimento240CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "17": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

