/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento._400;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento.UtilitySantander;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSantanderRecebimento400
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;
    private Double valorTotalTitulo = 0.0;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilitySantander.getFileName() + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append("1");
        p.append("REMESSA");
        p.append("01");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("COBRAN\u00c7A", 15));
        p.append(UtilityArquivoCnab.getValueByKey("COD_TRANSMISSAO", configuracao));
        if (bordero.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30));
        }
        p.append("033");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("SANTANDER", 15));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 16));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 275));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            this.buildDetail(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, codificacaoArquivo);
        }
    }

    private void buildDetail(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("1");
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        p.append(UtilityArquivoCnab.getValueByKey("COD_TRANSMISSAO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getIdentificador().toString(), 25));
        String nossoNumero = UtilityArquivoCnab.completarComZeroEsquerda(boleto.getNumeroTituloInst().toString(), 7);
        String dvNossoNumero = UtilitySantander.getDvNossoNumero(nossoNumero);
        p.append(nossoNumero + dvNossoNumero);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao));
        String codMulta = UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao);
        if (codMulta.equals("0")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        } else {
            Double taxaDouble = titulo.getPercMulta();
            String taxaMulta = ContatoFormatUtil.formataNumero((Number)taxaDouble, (int)2);
            taxaMulta = ToolString.refina((String)taxaMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(taxaMulta, 4));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 13));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 4));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataAplicacaoMulta()));
        if (ToolMethods.isStrWithData((String)UtilityArquivoCnab.getValueByKey("COD_CARTEIRA", configuracao))) {
            p.append(UtilityArquivoCnab.getValueByKey("COD_CARTEIRA", configuracao));
        } else {
            p.append(borderoTitulos.getCarteiraCobranca().getCodigoCarteira());
        }
        p.append(UtilityArquivoCnab.getValueByKey("COD_OCORRENCIA", configuracao));
        if (tipoNumero == 1) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota().toString(), 10));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getFaturaCte().getIdentificador().toString(), 10));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getRps().getNumero().toString(), 10));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getOrdemCompra().getIdentificador().toString(), 10));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getInfPagamentoPedido().getPedido().getIdentificador().toString(), 10));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPedidoComercio().getIdentificador().toString(), 10));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getAdiantamentoViagem().getIdentificador().toString(), 10));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getNotaContratoLocacao().getNumero().toString(), 10));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getContratoLocacao().getNumeroContrato().toString(), 10));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getApuracaoLocacaoContrato().getIdentificador().toString(), 10));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getCte().getNumero().toString(), 10));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 13));
        this.valorTotalTitulo = this.valorTotalTitulo + titulo.getValor();
        p.append("033");
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira().equals("5")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        }
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao));
        String valorJurosDia = ContatoFormatUtil.formataNumero((Number)titulo.getVrJurosDia(), (int)2);
        valorJurosDia = ToolString.refina((String)valorJurosDia);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorJurosDia, 13));
        p.append(UtilityArquivoCnab.formatarDatas6Digitos(titulo.getDataLimiteDesconto()));
        String valorDesconto = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
        valorDesconto = ToolString.refina((String)valorDesconto);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDesconto, 13));
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIof, 13));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 13));
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoDoisDigitos(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getPessoa().getComplemento().getCnpj()), 14));
        if (titulo.getPessoa().getNome().length() > 40) {
            p.append(titulo.getPessoa().getNome().substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getPessoa().getNome(), 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro() + " " + enderecoCliente.getNumero() + " " + (ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : ""))).toUpperCase();
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 12) {
            p.append(bairro.substring(0, 12).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 12).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append("I");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 6));
        String primeiraInstrucao = UtilityArquivoCnab.getValueByKey("INSTRUCAO_1", configuracao);
        String segundaInstrucao = UtilityArquivoCnab.getValueByKey("INSTRUCAO_2", configuracao);
        if (primeiraInstrucao.equals("6") || segundaInstrucao.equals("6")) {
            p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 2));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("9");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        String valorTitulo = ContatoFormatUtil.formataNumero((Number)this.valorTotalTitulo, (int)2);
        valorTitulo = ToolString.refina((String)valorTitulo);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTitulo, 13));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 374));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(numeroSequencial.toString(), 6));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 400);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

