/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento._400;

import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.santander.recebimento._400.ConstantsRetornoSantander400;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoRecebimentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSantanderRecebimento400
implements RetornoRecebimentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSantanderRecebimento400.class);
    private BufferedReader buffer;
    private List<RetornoRecebimentoCnab> retornoSantanderRecebimento400CNAB;
    private File arquivo;
    private String convenio = "";
    private final String LIQUIDACAO = "06";
    private final String LIQUIDACAO_APOS_BAIXA_OU_TITULO_NAO_REGISTRADO = "17";
    private final String ENTRADA_REJEITADA = "03";

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoSantanderRecebimento400CNAB = new ArrayList<RetornoRecebimentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(0, 1).equals("0")) {
            this.analyzeHeader(line);
        }
        this.convenio = ToolString.removerZerosAEsquerda((String)line.substring(110, 117));
        String nrBanco = line.substring(76, 79);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(1, 2).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(OpcoesFinanceiras opcoesFinanceiras) throws IOException, ExceptionCnab {
        try {
            while (this.buffer.ready()) {
                String line = this.buffer.readLine();
                if (!line.substring(0, 1).equals("1")) continue;
                RetornoRecebimentoCnab retornoSantander = new RetornoRecebimentoCnab();
                this.setRetornoSantanderDatail(retornoSantander, line, opcoesFinanceiras, this.convenio);
                this.retornoSantanderRecebimento400CNAB.add(retornoSantander);
            }
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
        }
    }

    private void setRetornoSantanderDatail(RetornoRecebimentoCnab retornoSantander, String line, OpcoesFinanceiras opcoesFinanceiras, String convenio) throws ExceptionService {
        retornoSantander.setNrTitulo(line.substring(116, 126));
        retornoSantander.setNrNossoNumero(line.substring(126, 134));
        retornoSantander.setDataVencimentoString(line.substring(146, 152));
        retornoSantander.setDataCredito(line.substring(295, 301));
        retornoSantander.setDataOcorrencia(line.substring(110, 116));
        retornoSantander.setDataReferenciaRetorno(line.substring(110, 116));
        retornoSantander.setNrSequencialRegistro(line.substring(394, 400));
        Titulo titulo = null;
        ConfiguracaoCnab configuracao = null;
        if (opcoesFinanceiras.getTipoNumeroTitulo().equals((short)1)) {
            if (retornoSantander.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSantander.getNrNossoNumero(), "033", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSantander.setBoletoTitulo(b);
            }
        } else {
            titulo = UtilityArquivoCnab.buscarTituloCobranca(retornoSantander.getNrTitulo());
            if (titulo == null && retornoSantander.getNrNossoNumero() != null && (b = UtilityArquivoCnab.buscarTituloNossoNumero(retornoSantander.getNrNossoNumero(), "033", convenio)) != null) {
                titulo = b.getTitulo();
                retornoSantander.setBoletoTitulo(b);
            }
        }
        if (titulo != null) {
            configuracao = titulo.getConfiguracaoCnab();
        }
        retornoSantander.setTitulo(titulo);
        String codMovRetorno = line.substring(108, 110).trim();
        if (codMovRetorno != null && !codMovRetorno.isEmpty()) {
            retornoSantander.setCodMovRetorno(codMovRetorno);
            retornoSantander.setDescMovRet(ConstantsRetornoSantander400.getInfoMovRetornoByCodigo(codMovRetorno));
            retornoSantander.setBaixarPeloMovRetorno(this.verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(codMovRetorno));
            retornoSantander.setRejeitado(this.verificarSeTituloRejeitadoByCodMovRetornoRecebimento(codMovRetorno));
        } else {
            retornoSantander.setBaixarPeloMovRetorno(Boolean.FALSE);
        }
        if (configuracao != null && configuracao.getValorTarifa() == 1) {
            String valorTarifaInteiro = line.substring(214, 225);
            String valorTarifaDecimal = line.substring(225, 227);
            Double valorTarifa = UtilityArquivoCnab.formatarNumero(valorTarifaInteiro, valorTarifaDecimal);
            retornoSantander.setValorTarifaCobranca(valorTarifa);
        } else {
            retornoSantander.setValorTarifaCobranca(0.0);
        }
        if (configuracao != null && configuracao.getValorIof() == 1) {
            String valorIofInteiro = line.substring(214, 225);
            String valorIofDecimal = line.substring(225, 227);
            Double valorIof = UtilityArquivoCnab.formatarNumero(valorIofInteiro, valorIofDecimal);
            retornoSantander.setValorIof(valorIof);
        } else {
            retornoSantander.setValorIof(0.0);
        }
        if (configuracao != null && configuracao.getValorOutrosCreditos() == 1) {
            String valorOutrosCreditosInteira = line.substring(279, 290);
            String valorOutrosCreditosDecimal = line.substring(290, 292);
            Double valorOutrosCreditos = UtilityArquivoCnab.formatarNumero(valorOutrosCreditosInteira, valorOutrosCreditosDecimal);
            retornoSantander.setValorOutrosCreditos(valorOutrosCreditos);
        } else {
            retornoSantander.setValorOutrosCreditos(0.0);
        }
        if (configuracao != null && configuracao.getValorAbatimento() == 1) {
            String valorAbatimentoInteiro = line.substring(227, 238);
            String valorAbatimentoDecimal = line.substring(238, 240);
            Double valorAbatimento = UtilityArquivoCnab.formatarNumero(valorAbatimentoInteiro, valorAbatimentoDecimal);
            retornoSantander.setValorAbatimento(valorAbatimento);
        } else {
            retornoSantander.setValorAbatimento(0.0);
        }
        if (configuracao != null && configuracao.getValorDespesaBancaria() == 1) {
            String valorOutrasDespesasInteiro = line.substring(188, 199);
            String valorOutrasDespesasDecimal = line.substring(199, 201);
            Double valorOutrasDespesas = UtilityArquivoCnab.formatarNumero(valorOutrasDespesasInteiro, valorOutrasDespesasDecimal);
            retornoSantander.setValorDespesasBancarias(valorOutrasDespesas);
        } else {
            retornoSantander.setValorDespesasBancarias(0.0);
        }
        if (configuracao != null && configuracao.getValorJuros() == 1) {
            String valorJurosInteiro = line.substring(266, 277);
            String valorJurosDecimal = line.substring(277, 279);
            Double valorJuros = UtilityArquivoCnab.formatarNumero(valorJurosInteiro, valorJurosDecimal);
            retornoSantander.setValorJuros(valorJuros);
        } else {
            retornoSantander.setValorJuros(0.0);
        }
        if (configuracao != null && configuracao.getValorDesconto() == 1) {
            String valorDescontoInteiro = line.substring(240, 251);
            String valorDescontoDecimal = line.substring(251, 253);
            Double valorDesconto = UtilityArquivoCnab.formatarNumero(valorDescontoInteiro, valorDescontoDecimal);
            retornoSantander.setValorDesconto(valorDesconto);
        } else {
            retornoSantander.setValorDesconto(0.0);
        }
        String valorBaixaInteiro = line.substring(253, 264);
        String valorBaixaDecimal = line.substring(264, 266);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorBaixaInteiro, valorBaixaDecimal);
        retornoSantander.setValorBaixa(valorBaixa);
        if (configuracao != null && configuracao.getValorMulta() == 1) {
            retornoSantander.setValorMulta(0.0);
        } else {
            retornoSantander.setValorMulta(0.0);
        }
        String valorTituloInteiro = line.substring(152, 163);
        String valorTituloDecimal = line.substring(163, 165);
        Double valorTitulo = UtilityArquivoCnab.formatarNumero(valorTituloInteiro, valorTituloDecimal);
        retornoSantander.setValorTitulo(valorTitulo);
    }

    @Override
    public List<RetornoRecebimentoCnab> getList() {
        return this.retornoSantanderRecebimento400CNAB;
    }

    public Boolean verificarSeTituloPodeSerBaixadoPeloCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "06": {
                return Boolean.TRUE;
            }
            case "17": {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Short verificarSeTituloRejeitadoByCodMovRetornoRecebimento(String codMovRetorno) {
        switch (codMovRetorno) {
            case "03": {
                return (short)1;
            }
        }
        return (short)0;
    }
}

