/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.autorizacaodebitoconta._200;

import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabAutorizacaoDebito;
import com.touchcomp.basementor.model.vo.RemessaCnabAutorizacaoDebito;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.recebimento.UtilitySicoob;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaAutorizacaoDebitoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRemessaSicoobAutorizacaoDebito200
implements RemessaAutorizacaoDebitoCnabInterface {
    private File arquivo;
    private Integer quantidadeLancamentos = 0;
    private Double valorTotalLancamentos = 0.0;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilitySicoob.getFileNameAutorizacaoDebito(numSequencialRemessa) + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        this.quantidadeLancamentos = 0;
        this.valorTotalLancamentos = 0.0;
    }

    @Override
    public void buildHeaderFile(RemessaCnabAutorizacaoDebito remessaAutorizacao, ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(this.arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        BorderoTitulos bordero = ((ItemRemessaCnabAutorizacaoDebito)remessaAutorizacao.getItemRemessaAutorizacao().get(0)).getItemBordero().getBorderoCobranca();
        p.append("0");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_ARQUIVO", configuracao));
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 4));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrCliente(), 7));
        p.append(UtilityArquivoCnab.getValueByKey("IDENTIFICACAO_EMPRESA", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("CODIGO_MOVIMENTACAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("DESTINO_MOVIMENTACAO", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8DigitosFormatyyyyMMdd(remessaAutorizacao.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 162));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabAutorizacaoDebito remessaAutorizacao, ConfiguracaoCnab configuracao) throws IOException {
    }

    @Override
    public void buildDetail(RemessaCnabAutorizacaoDebito remessaAutorizacao, ConfiguracaoCnab configuracao) throws IOException {
        for (ItemRemessaCnabAutorizacaoDebito i : remessaAutorizacao.getItemRemessaAutorizacao()) {
            this.buildDetailSegmento01(i, configuracao);
        }
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao) throws IOException {
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(this.arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("9");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(this.quantidadeLancamentos.toString(), 5));
        String valorTotalLancamento = ContatoFormatUtil.formataNumero((Number)this.valorTotalLancamentos, (int)2);
        valorTotalLancamento = ToolString.refina((String)valorTotalLancamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorTotalLancamento, 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 155));
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 200);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }

    private void buildDetailSegmento01(ItemRemessaCnabAutorizacaoDebito item, ConfiguracaoCnab configuracao) throws IOException {
        FileWriter fileWriter = new FileWriter(this.arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("1");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_MOVIMENTO", configuracao));
        String contaAndDV = item.getContaBancaria().getContaCorrente() + item.getContaBancaria().getDvContaCorrente();
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(contaAndDV, 10));
        String nomeCooperado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeCooperado.length() <= 40) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeCooperado, 40));
        } else {
            p.append(nomeCooperado.substring(0, 40));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 14));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 12));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        if (ToolMethods.isStrWithData((String)item.getRemessaAutorizacaoDebito().getNrDocObsArquivo())) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(item.getRemessaAutorizacaoDebito().getNrDocObsArquivo(), 10));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(titulo.getIdentificador().toString(), 10));
        }
        this.valorTotalLancamentos = this.valorTotalLancamentos + item.getValorDebito();
        String valorLancamento = ContatoFormatUtil.formataNumero((Number)item.getValorDebito(), (int)2);
        valorLancamento = ToolString.refina((String)valorLancamento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorLancamento, 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append("N");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 18));
        Integer n = this.quantidadeLancamentos;
        this.quantidadeLancamentos = this.quantidadeLancamentos + 1;
        p.println();
        p.flush();
        p.close();
    }
}

