/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.pagamento._240;

import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorlogger.TLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.pagamento._240.ConstantsRetornoSicoobPagamento240;
import mentorcore.service.impl.financeiro.cnabnovo.exceptions.ExceptionCnab;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RetornoPagamentoCnabInterface;
import mentorcore.service.impl.financeiro.cnabnovo.model.RetornoPagamentoCnab;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;

public class LayoutRetornoSicoobPagamento240
implements RetornoPagamentoCnabInterface {
    private final TLogger logger = TLogger.get(LayoutRetornoSicoobPagamento240.class);
    private BufferedReader buffer;
    private List<RetornoPagamentoCnab> retornoCNAB240PagamentoSicoob;
    private File arquivo;

    @Override
    public void createBufferedReader(File file) throws IOException {
        this.arquivo = file;
        FileReader fileReader = new FileReader(this.arquivo);
        this.buffer = new BufferedReader(fileReader);
    }

    @Override
    public void resetVariables() {
        this.retornoCNAB240PagamentoSicoob = new ArrayList<RetornoPagamentoCnab>();
    }

    @Override
    public Boolean isBankValid(InstituicaoValores instValor) throws IOException {
        String line = this.buffer.readLine();
        if (line.substring(7, 8).equals("0")) {
            this.analyzeHeader(line);
        }
        String nrBanco = line.substring(0, 3);
        return nrBanco.equals(instValor.getNrBanco());
    }

    private void analyzeHeader(String line) throws IOException {
        if (line.substring(142, 143).equals("1")) {
            throw new IOException("O arquivo selecionado n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd de Retorno e sim uma Remessa. Selecione um arquivo de Retorno. Opera\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo cancelada!");
        }
    }

    @Override
    public void readFile(EmpresaFinanceiro empresaFinanceiro) throws IOException, ExceptionCnab {
        while (this.buffer.ready()) {
            String line = this.buffer.readLine();
            RetornoPagamentoCnab retornoSicoob = new RetornoPagamentoCnab();
            if (line.substring(5, 6).equals("1")) {
                retornoSicoob.setTipoRegistro("1");
                this.setRetornoPagamentoSicoobHeaderLote(retornoSicoob, line);
                this.retornoCNAB240PagamentoSicoob.add(retornoSicoob);
                continue;
            }
            if (line.substring(7, 8).equals("3") && !line.substring(17, 19).equals("52")) {
                retornoSicoob.setTipoRegistro("3");
                if (line.substring(13, 14).equals("J")) {
                    retornoSicoob.setTipoRegistro("3");
                    this.setRetornoPagamentoSicoobDatailSegJ(retornoSicoob, line);
                    this.retornoCNAB240PagamentoSicoob.add(retornoSicoob);
                    continue;
                }
                if (line.substring(13, 14).equals("A")) {
                    retornoSicoob.setTipoRegistro("3");
                    this.setRetornoPagamentoSicoobDatailSegA(retornoSicoob, line);
                    this.retornoCNAB240PagamentoSicoob.add(retornoSicoob);
                    continue;
                }
                if (!line.substring(13, 14).equals("O")) continue;
                retornoSicoob.setTipoRegistro("3");
                this.setRetornoPagamentoSicoobDatailSegO(retornoSicoob, line);
                this.retornoCNAB240PagamentoSicoob.add(retornoSicoob);
                continue;
            }
            if (!line.substring(7, 8).equals("5")) continue;
            retornoSicoob.setTipoRegistro("5");
            this.setRetornoPagamentoSicoobTrailerLote(retornoSicoob, line);
            this.retornoCNAB240PagamentoSicoob.add(retornoSicoob);
        }
    }

    private void setRetornoPagamentoSicoobDatailSegJ(RetornoPagamentoCnab retornoPagamentoSicoob, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoSicoob.setNrTitulo(line.substring(182, 202));
        retornoPagamentoSicoob.setNrNossoNumero(line.substring(202, 222));
        retornoPagamentoSicoob.setLoteServico(line.substring(3, 7));
        retornoPagamentoSicoob.setDataPagamento(line.substring(144, 152));
        retornoPagamentoSicoob.setNumeroProtocolo(line.substring(202, 222));
        retornoPagamentoSicoob.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoSicoob.setMsgOcorrencia1(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoSicoob.setMsgOcorrencia2(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoSicoob.setMsgOcorrencia3(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoSicoob.setMsgOcorrencia4(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoSicoob.setMsgOcorrencia5(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(152, 165);
        String valorPagoDecimal = line.substring(165, 167);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoSicoob.setValorBaixa(valorBaixa);
    }

    @Override
    public List<RetornoPagamentoCnab> getList() {
        return this.retornoCNAB240PagamentoSicoob;
    }

    private void setRetornoPagamentoSicoobTrailerLote(RetornoPagamentoCnab retornoSicoob, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSicoob.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSicoob.setCodOcorrencia1(codOcorrencia1);
            retornoSicoob.setMsgOcorrencia1(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSicoob.setCodOcorrencia2(codOcorrencia2);
            retornoSicoob.setMsgOcorrencia2(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSicoob.setCodOcorrencia3(codOcorrencia3);
            retornoSicoob.setMsgOcorrencia3(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSicoob.setCodOcorrencia4(codOcorrencia4);
            retornoSicoob.setMsgOcorrencia4(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSicoob.setCodOcorrencia5(codOcorrencia5);
            retornoSicoob.setMsgOcorrencia5(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoSicoobHeaderLote(RetornoPagamentoCnab retornoSicoob, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoSicoob.setLoteServico(line.substring(3, 7));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoSicoob.setCodOcorrencia1(codOcorrencia1);
            retornoSicoob.setMsgOcorrencia1(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoSicoob.setCodOcorrencia2(codOcorrencia2);
            retornoSicoob.setMsgOcorrencia2(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoSicoob.setCodOcorrencia3(codOcorrencia3);
            retornoSicoob.setMsgOcorrencia3(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoSicoob.setCodOcorrencia4(codOcorrencia4);
            retornoSicoob.setMsgOcorrencia4(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoSicoob.setCodOcorrencia5(codOcorrencia5);
            retornoSicoob.setMsgOcorrencia5(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
    }

    private void setRetornoPagamentoSicoobDatailSegA(RetornoPagamentoCnab retornoPagamentoSicoob, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoSicoob.setNrTitulo(line.substring(73, 93));
        retornoPagamentoSicoob.setNrNossoNumero(line.substring(134, 154));
        retornoPagamentoSicoob.setLoteServico(line.substring(3, 7));
        retornoPagamentoSicoob.setDataPagamento(line.substring(93, 101));
        retornoPagamentoSicoob.setNumeroProtocolo(line.substring(134, 154));
        retornoPagamentoSicoob.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoSicoob.setMsgOcorrencia1(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoSicoob.setMsgOcorrencia2(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoSicoob.setMsgOcorrencia3(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoSicoob.setMsgOcorrencia4(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoSicoob.setMsgOcorrencia5(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(119, 132);
        String valorPagoDecimal = line.substring(132, 134);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoSicoob.setValorBaixa(valorBaixa);
    }

    private void setRetornoPagamentoSicoobDatailSegO(RetornoPagamentoCnab retornoPagamentoSicoob, String line) {
        String codOcorrencia5;
        String codOcorrencia4;
        String codOcorrencia3;
        String codOcorrencia2;
        retornoPagamentoSicoob.setNrTitulo(line.substring(122, 142));
        retornoPagamentoSicoob.setNrNossoNumero(line.substring(142, 162));
        retornoPagamentoSicoob.setLoteServico(line.substring(3, 7));
        retornoPagamentoSicoob.setDataPagamento(line.substring(99, 107));
        retornoPagamentoSicoob.setNumeroProtocolo(line.substring(142, 162));
        retornoPagamentoSicoob.setNrSequencialRegistro(line.substring(8, 13));
        String codOcorrencia1 = line.substring(230, 232).trim();
        if (codOcorrencia1 != null && !codOcorrencia1.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia1(codOcorrencia1);
            retornoPagamentoSicoob.setMsgOcorrencia1(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia1));
        }
        if ((codOcorrencia2 = line.substring(232, 234).trim()) != null && !codOcorrencia2.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia2(codOcorrencia2);
            retornoPagamentoSicoob.setMsgOcorrencia2(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia2));
        }
        if ((codOcorrencia3 = line.substring(234, 236).trim()) != null && !codOcorrencia3.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia3(codOcorrencia3);
            retornoPagamentoSicoob.setMsgOcorrencia3(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia3));
        }
        if ((codOcorrencia4 = line.substring(236, 238).trim()) != null && !codOcorrencia4.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia4(codOcorrencia4);
            retornoPagamentoSicoob.setMsgOcorrencia4(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia4));
        }
        if ((codOcorrencia5 = line.substring(238, 240).trim()) != null && !codOcorrencia5.isEmpty()) {
            retornoPagamentoSicoob.setCodOcorrencia5(codOcorrencia5);
            retornoPagamentoSicoob.setMsgOcorrencia5(ConstantsRetornoSicoobPagamento240.getInfoMovRetornoByCodigo(codOcorrencia5));
        }
        String valorPagoInteiro = line.substring(107, 120);
        String valorPagoDecimal = line.substring(120, 122);
        Double valorBaixa = UtilityArquivoCnab.formatarNumero(valorPagoInteiro, valorPagoDecimal);
        retornoPagamentoSicoob.setValorBaixa(valorBaixa);
    }
}

