/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.recebimento._240;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemRemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.RemessaCnabCobranca;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.service.impl.financeiro.cnabnovo.bancos.sicoob.recebimento.UtilitySicoob;
import mentorcore.service.impl.financeiro.cnabnovo.interfaces.RemessaRecebimentoCnabInterface;
import mentorcore.service.impl.financeiro.utility.UtilityArquivoCnab;
import mentorcore.utilities.impl.financeiro.UtilityValidationCnab;

public class LayoutRemessaSicoobRecebimento240
implements RemessaRecebimentoCnabInterface {
    private File arquivo;
    private static Integer numeroSequencial;

    @Override
    public void createFile(File file, String extension, Long numSequencialRemessa, ConfiguracaoCnab configuracao) throws IOException {
        this.arquivo = new File(file, UtilitySicoob.getFileName(numSequencialRemessa) + extension);
        if (this.arquivo.exists()) {
            throw new IOException("J\u00e1 existe um arquivo com o mesmo nome na pasta selecionada!");
        }
        this.arquivo.createNewFile();
    }

    @Override
    public void resetCounter() {
        numeroSequencial = 1;
    }

    @Override
    public void buildHeaderFile(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 4));
        p.append("0");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj()), 14));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio() != null && !bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) {
            if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException(" O N\u00famero Convenio Recebimento possui mais de 20 caracteres. Favor verificar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().isEmpty()) {
            p.append(" ");
        } else {
            p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("SICOOB", 30));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append("1");
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.getHoraGeracao(remessaCobranca.getHoraGeracao()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(remessaCobranca.getNumeroSequenciaArquivo()), 6));
        p.append("081");
        p.append("00000");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 29));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildHeaderPackage(RemessaCnabCobranca remessaCobranca, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        BorderoTitulos bordero = ((ItemRemessaCnabCobranca)remessaCobranca.getItemRemessaCobranca().get(0)).getItemBordero().getBorderoCobranca();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("1");
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_OPERACAO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("TIPO_SERVICO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 2));
        p.append("040");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(remessaCobranca.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(remessaCobranca.getEmpresa().getPessoa().getComplemento().getCnpj(), 15));
        if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio() != null && !bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().isEmpty()) {
            if (bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio().length() > 20) {
                p.close();
                this.getFile().delete();
                throw new IOException(" O N\u00famero Convenio Recebimento possui mais de 20 caracteres. Favor verificar!");
            }
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bordero.getCarteiraCobranca().getContaValor().getNumeroConvenio(), 20));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().isEmpty()) {
            p.append(" ");
        } else {
            p.append(bordero.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(bordero.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(bordero.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        if (remessaCobranca.getEmpresa().getPessoa().getNome().length() > 30) {
            p.append(remessaCobranca.getEmpresa().getPessoa().getNome().substring(0, 30).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(remessaCobranca.getEmpresa().getPessoa().getNome(), 30).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_1", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("MENSAGEM_2", configuracao));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(remessaCobranca.getNumeroSequenciaArquivo()), 8));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(remessaCobranca.getDataCadastro()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 33));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildDetail(RemessaCnabCobranca remessa, Short tipoNumero, ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        String tipoMovimento = ToolString.refina((String)remessa.getTipoRemessa().getCodigo());
        if (tipoMovimento == null || tipoMovimento.isEmpty()) {
            throw new IOException("Nenhum codigo foi encontrado para o Tipo de Movimento selecionado. Contate o suporte tecnico!");
        }
        for (ItemRemessaCnabCobranca item : remessa.getItemRemessaCobranca()) {
            String segementoR = UtilityArquivoCnab.getValueByKey("SEGMENTO_R", configuracao);
            String segementoS = UtilityArquivoCnab.getValueByKey("SEGMENTO_S", configuracao);
            this.buildDetailSegmentoP(item.getItemBordero().getBorderoCobranca(), item, tipoNumero, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoQ(item, configuracao, tipoMovimento, codificacaoArquivo);
            this.buildDetailSegmentoR(item, configuracao, tipoMovimento, codificacaoArquivo);
            if (!segementoS.equals("1")) continue;
            this.buildDetailSegmentoS(item, configuracao, tipoMovimento, codificacaoArquivo);
        }
    }

    private void buildDetailSegmentoP(BorderoTitulos borderoTitulos, ItemRemessaCnabCobranca item, Short tipoNumero, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        BoletoTitulo boleto = item.getBoleto();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(numeroSequencial), 5));
        p.append("P");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia(), 5));
        if (borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia() == null || borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia().isEmpty()) {
            p.append(" ");
        } else {
            p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getDvAgencia());
        }
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(borderoTitulos.getCarteiraCobranca().getContaValor().getNrConta(), 12));
        p.append(borderoTitulos.getCarteiraCobranca().getContaValor().getDvConta());
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        String tipoConvenio = UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao);
        Object nossoNumeroFormatado = "";
        if (tipoConvenio.equals("2")) {
            String numCooperativa = borderoTitulos.getCarteiraCobranca().getContaValor().getAgenciaValor().getNrAgencia();
            String codigoCliente = borderoTitulos.getCarteiraCobranca().getContaValor().getNrCliente();
            String nossoNumero = String.valueOf(boleto.getNumeroTituloInst());
            String dvNossoNumero = UtilitySicoob.getDvNossoNumero(numCooperativa, codigoCliente, nossoNumero);
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComZeroEsquerda(nossoNumero + dvNossoNumero, 10);
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(titulo.getNumParcTituloEstnota()), 2);
            nossoNumeroFormatado = (String)nossoNumeroFormatado + "01";
            nossoNumeroFormatado = (String)nossoNumeroFormatado + "4";
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComBrancoDireita("", 5);
            p.append((CharSequence)nossoNumeroFormatado);
        } else if (tipoConvenio.equals("1")) {
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComZeroEsquerda("", 10);
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(titulo.getNumParcTituloEstnota()), 2);
            nossoNumeroFormatado = (String)nossoNumeroFormatado + "01";
            nossoNumeroFormatado = (String)nossoNumeroFormatado + String.valueOf(UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO_BOLETO", configuracao) == null || UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO_BOLETO", configuracao).isEmpty() ? "4" : Boolean.valueOf(UtilityArquivoCnab.getValueByKey("TIPO_IMPRESSAO_BOLETO", configuracao).isEmpty()));
            nossoNumeroFormatado = (String)nossoNumeroFormatado + UtilityArquivoCnab.completarComBrancoDireita("", 5);
            p.append((CharSequence)nossoNumeroFormatado);
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Tipo de Conv\u00eanio/Emiss\u00e3o Bloqueto invalido ou n\u00e3o informado na configura\u00e7\u00e3o CNAB. Contate o Suporte Tecnico!");
        }
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira() == null || borderoTitulos.getCarteiraCobranca().getCodigoCarteira().isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException("Primeiro informe o C\u00f3digo da Carteira na Carteira " + String.valueOf(borderoTitulos.getCarteiraCobranca()).toUpperCase() + ". Contate o Suporte Tecnico!");
        }
        if (borderoTitulos.getCarteiraCobranca().getCodigoCarteira().length() != 1) {
            p.close();
            this.getFile().delete();
            throw new IOException("O C\u00f3digo da Carteira deve possuir apenas 1 caracter! Favor verificar.");
        }
        p.append(borderoTitulos.getCarteiraCobranca().getCodigoCarteira());
        p.append(UtilityArquivoCnab.getValueByKey("FORMA_CAD_BANCO", configuracao));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("EMISSAO_BLOQUETO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("DISTRIBUICAO_BLOQUETO", configuracao));
        if (tipoNumero.equals((short)1)) {
            if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota()), 15));
            } else if (titulo.getFaturaCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getFaturaCte().getIdentificador()), 15));
            } else if (titulo.getRps() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getRps().getNumero()), 15));
            } else if (titulo.getOrdemCompra() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getOrdemCompra().getIdentificador()), 15));
            } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getInfPagamentoPedido().getPedido().getIdentificador()), 15));
            } else if (titulo.getPedidoComercio() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getPedidoComercio().getIdentificador()), 15));
            } else if (titulo.getAdiantamentoViagem() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getAdiantamentoViagem().getIdentificador()), 15));
            } else if (titulo.getNotaContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getNotaContratoLocacao().getNumero()), 15));
            } else if (titulo.getContratoLocacao() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getContratoLocacao().getNumeroContrato()), 15));
            } else if (titulo.getApuracaoLocacaoContrato() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getApuracaoLocacaoContrato().getIdentificador()), 15));
            } else if (titulo.getCte() != null) {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getCte().getNumero()), 15));
            } else {
                p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getIdentificador()), 15));
            }
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getIdentificador()), 15));
        }
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataVencimento()));
        Double valorBoleto = boleto.getValorBoleto() != null && boleto.getValorBoleto() > 0.0 ? boleto.getValorBoleto() : titulo.getValor();
        String valorCobrado = ContatoFormatUtil.formataNumero((Number)valorBoleto, (int)2);
        valorCobrado = ToolString.refina((String)valorCobrado);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorCobrado, 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.getValueByKey("ESPECIE_TITULO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("ACEITE", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataEmissao()));
        p.append(UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao));
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(ToolDate.nextDays((Date)titulo.getDataVencimento(), (int)1)));
        String codJurosMora = UtilityArquivoCnab.getValueByKey("COD_JUROS_MORA", configuracao);
        if (codJurosMora.equals("1")) {
            Double valorJurosDia = titulo.getVrJurosDia();
            if (valorJurosDia == null) {
                valorJurosDia = 0.0;
            }
            String valorMoraMes = ContatoFormatUtil.formataNumero((Number)valorJurosDia, (int)2);
            valorMoraMes = ToolString.refina((String)valorMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMoraMes, 15));
        } else if (codJurosMora.equals("2")) {
            String texaMoraMes = ContatoFormatUtil.formataNumero((Number)titulo.getPercJurosMes(), (int)2);
            texaMoraMes = ToolString.refina((String)texaMoraMes);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaMoraMes, 15));
        } else if (codJurosMora.equals("0")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Codigo de Juros Mora inv\u00e1lido ou n\u00e3o informado na configura\u00e7\u00e3o CNAB. Contate o Suporte Tecnico!");
        }
        String codDesconto = UtilityArquivoCnab.getValueByKey("COD_DESCONTO_1", configuracao);
        p.append(codDesconto);
        p.append(UtilityArquivoCnab.formatarDatas8Digitos(titulo.getDataLimiteDesconto()));
        if (codDesconto.equals("1")) {
            String valorDescont = ContatoFormatUtil.formataNumero((Number)(titulo.getDescontoFinanceiro() + titulo.getValorDescontosEmbutido()), (int)2);
            valorDescont = ToolString.refina((String)valorDescont);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorDescont, 15));
        } else if (codDesconto.equals("2")) {
            String texaDesconto = ContatoFormatUtil.formataNumero((Number)titulo.getPercDescontoMes(), (int)2);
            texaDesconto = ToolString.refina((String)texaDesconto);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(texaDesconto, 15));
        } else if (codDesconto.equals("0")) {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        } else {
            p.close();
            this.getFile().delete();
            throw new IOException("Codigo de Desconto inv\u00e1lido ou n\u00e3o informado na configura\u00e7\u00e3o CNAB. Contate o Suporte Tecnico!");
        }
        String valorIof = ContatoFormatUtil.formataNumero((Number)titulo.getVrIofPago(), (int)2);
        valorIof = ToolString.refina((String)valorIof);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorIof, 15));
        String valorAbatimento = ContatoFormatUtil.formataNumero((Number)titulo.getVrAbatimento(), (int)2);
        valorAbatimento = ToolString.refina((String)valorAbatimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorAbatimento, 15));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getIdentificador()), 25));
        p.append(UtilityArquivoCnab.getValueByKey("COD_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("NUM_DIAS_PROTESTO", configuracao));
        p.append(UtilityArquivoCnab.getValueByKey("COD_BAIXA_DEVOLUCAO", configuracao));
        p.append("   ");
        p.append("09");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoQ(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(numeroSequencial), 5));
        p.append("Q");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        String erroPessoa = UtilityValidationCnab.isValidDadosBasicoPessoa(titulo.getPessoa());
        if (erroPessoa != null && !erroPessoa.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erroPessoa);
        }
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(titulo.getPessoa().getComplemento().getCnpj(), 15));
        String nomeSacado = ToolString.substituiCaractereEspecial((String)titulo.getPessoa().getNome());
        if (nomeSacado.length() > 40) {
            p.append(nomeSacado.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacado, 40).toUpperCase());
        }
        Endereco enderecoCliente = titulo.getPessoa().getEnderecoCobranca() != null ? titulo.getPessoa().getEnderecoCobranca() : titulo.getPessoa().getEndereco();
        String erro = UtilityValidationCnab.isValidAddress(enderecoCliente, titulo.getPessoa());
        if (erro != null && !erro.isEmpty()) {
            p.close();
            this.getFile().delete();
            throw new IOException(erro);
        }
        String complemento = ToolMethods.isStrWithData((String)enderecoCliente.getComplemento()) ? enderecoCliente.getComplemento() : "";
        String endereco = ToolString.substituiCaractereEspecial((String)(enderecoCliente.getLogradouro().toUpperCase() + " " + enderecoCliente.getNumero() + " " + complemento.toUpperCase()));
        if (endereco.length() > 40) {
            p.append(endereco.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(endereco, 40).toUpperCase());
        }
        String bairro = ToolString.substituiCaractereEspecial((String)enderecoCliente.getBairro());
        if (bairro.length() > 15) {
            p.append(bairro.substring(0, 15).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(bairro, 15).toUpperCase());
        }
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 1, titulo.getPessoa().getNome()));
        p.append(UtilityArquivoCnab.getDadosCep(enderecoCliente.getCep(), 2, titulo.getPessoa().getNome()));
        String cidade = ToolString.substituiCaractereEspecial((String)enderecoCliente.getCidade().getDescricao());
        if (cidade.length() > 15) {
            p.append(cidade.toUpperCase().substring(0, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(cidade.toUpperCase(), 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(enderecoCliente.getCidade().getUf().getSigla(), 2));
        p.append(UtilityArquivoCnab.getTipoInscricaoUmDigito(titulo.getEmpresa().getPessoa()));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(ToolString.refina((String)titulo.getEmpresa().getPessoa().getComplemento().getCnpj()), 15));
        String nomeSacadoAvalista = ToolString.substituiCaractereEspecial((String)titulo.getEmpresa().getPessoa().getNome());
        if (nomeSacadoAvalista.length() > 40) {
            p.append(nomeSacadoAvalista.substring(0, 40).toUpperCase());
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(nomeSacadoAvalista, 40).toUpperCase());
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("COD_BCO_CORRESPONDENTE_COMP", configuracao), 3));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("NUM_BANCO_CORRESPONDENTE", configuracao), 20));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoR(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(numeroSequencial), 5));
        p.append("R");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        String codMulta = UtilityArquivoCnab.getValueByKey("COD_MULTA", configuracao);
        p.append(codMulta);
        if (codMulta != null && codMulta.equals("1") || codMulta.equals("2")) {
            p.append(UtilityArquivoCnab.formatarDatas8Digitos(ToolDate.nextDays((Date)titulo.getDataVencimento(), (int)1)));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroDireita("", 8));
        }
        if (codMulta.equals("1")) {
            Double valorMultaFixa = 0.0;
            Double percMulta = titulo.getPercMulta();
            if (percMulta != null && percMulta > 0.0) {
                valorMultaFixa = ContatoFormatUtil.arrredondarNumero((Double)(titulo.getValor() * (percMulta / 100.0)), (int)2);
            }
            String valorMulta = ContatoFormatUtil.formataNumero((Number)valorMultaFixa, (int)2);
            valorMulta = ToolString.refina((String)valorMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(valorMulta, 15));
        } else if (codMulta.equals("2")) {
            String percMulta = ContatoFormatUtil.formataNumero((Number)titulo.getPercMulta(), (int)2);
            percMulta = ToolString.refina((String)percMulta);
            p.append(UtilityArquivoCnab.completarComZeroEsquerda(percMulta, 15));
        } else {
            p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 15));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 10));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_3", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_4", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 20));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 8));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 3));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 5));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 12));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 1));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void buildDetailSegmentoS(ItemRemessaCnabCobranca item, ConfiguracaoCnab configuracao, String tipoMovimento, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        Titulo titulo = item.getItemBordero().getTitulo();
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("3");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(numeroSequencial), 5));
        p.append("S");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 1));
        p.append(tipoMovimento);
        p.append("3");
        if (titulo.getInfPagamentoNfPropria() != null && titulo.getInfPagamentoNfPropria().getNotaFiscalPropria() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente NF: " + String.valueOf(titulo.getInfPagamentoNfPropria().getNotaFiscalPropria().getNumeroNota()) + " Parc.: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getFaturaCte() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente CTE: " + String.valueOf(titulo.getFaturaCte().getIdentificador()) + " Parc.: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getRps() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente RPS: " + (ToolMethods.isNotNull((Object)titulo.getRps().getNumero()) != false ? String.valueOf(titulo.getRps().getNumero()) : "") + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getOrdemCompra() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente OC: " + String.valueOf(titulo.getOrdemCompra().getIdentificador()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getInfPagamentoPedido() != null && titulo.getInfPagamentoPedido().getPedido() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente PEDIDO: " + String.valueOf(titulo.getInfPagamentoPedido().getPedido().getIdentificador()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getPedidoComercio() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente PED.COMER.: " + String.valueOf(titulo.getPedidoComercio().getIdentificador()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getAdiantamentoViagem() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente AD.VIAGEM: " + String.valueOf(titulo.getAdiantamentoViagem().getIdentificador()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getNotaContratoLocacao() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente NT.CONT.LOCA.: " + String.valueOf(titulo.getNotaContratoLocacao().getNumero()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getContratoLocacao() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente CONT.LOCA.: " + String.valueOf(titulo.getContratoLocacao().getNumeroContrato()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getApuracaoLocacaoContrato() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente AP.CONT.LOC.: " + String.valueOf(titulo.getApuracaoLocacaoContrato().getIdentificador()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else if (titulo.getCte() != null) {
            p.append(UtilityArquivoCnab.completarComBrancoDireita(String.valueOf(titulo.getCte().getNumero()), 25));
            p.append(UtilityArquivoCnab.completarComBrancoDireita("Referente CTE: " + String.valueOf(titulo.getCte().getNumero()) + " Parc: " + String.valueOf(titulo.getNumParcTituloEstnota()) + "/" + String.valueOf(titulo.getNumeroParcelas()), 40));
        } else {
            p.append(UtilityArquivoCnab.completarComBrancoDireita("", 40));
        }
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_6", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_7", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_8", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita(UtilityArquivoCnab.getValueByKey("MENSAGEM_9", configuracao), 40));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 22));
        Integer n = numeroSequencial;
        numeroSequencial = numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerPackage(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("756");
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 4));
        p.append("5");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        Integer registros = numeroSequencial + 1;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(registros), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 17));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 8));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 117));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void buildTrailerFile(ConfiguracaoCnab configuracao, String codificacaoArquivo) throws IOException {
        PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.arquivo, true), codificacaoArquivo));
        p.append("756");
        p.append("9999");
        p.append("9");
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 9));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("1", 6));
        Integer registros = numeroSequencial + 3;
        p.append(UtilityArquivoCnab.completarComZeroEsquerda(String.valueOf(registros), 6));
        p.append(UtilityArquivoCnab.completarComZeroEsquerda("", 6));
        p.append(UtilityArquivoCnab.completarComBrancoDireita("", 205));
        p.println();
        p.flush();
        p.close();
    }

    @Override
    public void validationBeforePrint() throws FileNotFoundException, IOException {
        UtilityArquivoCnab.validationBeforePrintCnab(this.getFile(), 240);
    }

    @Override
    public File getFile() throws IOException {
        return this.arquivo;
    }
}

